/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.webservice.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.soaextension.tibcobw.nameformatter.BWGenericFormatter;
import com.wily.soaextension.tibcobw.util.KConstants;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;

public class WebServicesFormatter
extends BWGenericFormatter {
    public static final String C_SOAP_SERVICE_CONFIG = "SoapServiceConfig";

    public WebServicesFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    public String getNamespace(InvocationData data) {
        String namespace = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object soapServiceConfig;
            Object invocationObj = data.getInvocationObject();
            if (invocationObj != null && (soapServiceConfig = TibcoReflectionCache.getFDefaultXDataSoapletFinisherISoapServiceConfig(invocationObj)) != null) {
                if (soapServiceConfig.getClass().getSimpleName().equalsIgnoreCase(C_SOAP_SERVICE_CONFIG)) {
                    namespace = (String)TibcoReflectionCache.getMSoapServiceConfigGetConcreteWsdlNamespace(soapServiceConfig);
                } else {
                    Object endpointName = TibcoBWUtils.getField(soapServiceConfig, KConstants.KF_SOAPSERVICECONFIGADAPTER_ENDPOINTNAME);
                    if (endpointName != null) {
                        namespace = (String)TibcoReflectionCache.getMExpandedNameGetNamespaceURI(endpointName);
                    }
                }
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesFormatter:getNamespace: " + namespace);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return namespace == null || namespace.trim().length() == 0 || namespace.equals("UnknownNamespace") ? "UnknownNamespace" : namespace;
    }

    @Override
    public String getWebServiceURI(InvocationData data) {
        String webServiceURI = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object transportContext;
            Object defaultSoapMessage;
            Object invocationObj = data.getInvocationObject();
            if (invocationObj != null && (defaultSoapMessage = TibcoReflectionCache.getFDefaultXDataSoapletFinisherSoapMessage(invocationObj)) != null && (transportContext = TibcoReflectionCache.getMSoapMessageGetTransportContext(defaultSoapMessage)) != null) {
                Object url = TibcoReflectionCache.getMTransportContextGetUrl(transportContext);
                webServiceURI = url.toString();
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesFormatter:getWebServiceURI: " + webServiceURI);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return webServiceURI == null || webServiceURI.trim().length() == 0 || webServiceURI.equals("UnknownServiceName") ? "UnknownServiceName" : webServiceURI;
    }

    @Override
    public String getOperationName(InvocationData data) {
        String operationName = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object operationContext;
            Object invocationObj = data.getInvocationObject();
            if (invocationObj != null && (operationContext = TibcoReflectionCache.getFDefaultXDataSoapletFinisherOperationContext(invocationObj)) != null) {
                operationName = (String)TibcoReflectionCache.getMOperationContextGetOperationName(operationContext);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesFormatter:getOperationName: " + operationName);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_OPERATION_NAME", bomb);
        }
        return operationName == null || operationName.trim().length() == 0 || operationName.equals("UnknownOperationName") ? "UnknownOperationName" : operationName;
    }
}

