/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.webservice.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.webservice.nameformatter.WebServicesServerFormatterHC;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class WebServicesOperationFormatterHC
extends WebServicesServerFormatterHC {
    public static final String C_SOAP_SERVICE_CONFIG = "SoapServiceConfig";

    public WebServicesOperationFormatterHC(IAgent agent) {
        super(agent);
    }

    @Override
    public String getOperationName(InvocationData data) {
        String operationName = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object xDataAdapSoaplet;
            Object dSoapApplication = data.getInvocationObject();
            if (dSoapApplication != null && (xDataAdapSoaplet = TibcoReflectionCache.getFDefaultSoapApplicationBodySoaplet(dSoapApplication)) != null) {
                operationName = (String)TibcoReflectionCache.getFXDataAdapterSoapletOperationName(xDataAdapSoaplet);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesServerFormatter.getOperationName: " + operationName);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_OPERATION_NAME", bomb);
        }
        return operationName == null || operationName.trim().length() == 0 || operationName.equals("UnknownOperationName") ? "UnknownOperationName" : operationName;
    }

    @Override
    public IBlameComponent getKey(IModuleFeedbackChannel feedback, String name, InvocationData data) {
        String namespace = super.getNamespace(data);
        data.put("com.wily.soaextension.tibcobw.NamespaceKey", (Object)namespace);
        String operationName = this.getOperationName(data);
        data.put("com.wily.soaextension.tibcobw.OperationNameKey", (Object)operationName);
        return ABlameComponent.getArrayInstance((Object[])new Object[]{name, namespace, operationName});
    }
}

