/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.webservice.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.soaextension.tibcobw.nameformatter.BWGenericFormatterHC;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.InvocationTargetException;

public class WebServicesServerFormatterHC
extends BWGenericFormatterHC {
    public static final String C_SOAP_SERVICE_CONFIG = "SoapServiceConfig";

    public WebServicesServerFormatterHC(IAgent agent) {
        super(agent);
    }

    @Override
    public String getNamespace(InvocationData data) {
        String namespace = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object mConfig;
            Object headerSoaplet;
            Object invObj = data.getInvocationObject();
            if (invObj != null && (headerSoaplet = TibcoReflectionCache.getFDefaultSoapApplicationHeaderSoaplet(invObj)) != null && (mConfig = TibcoReflectionCache.getFXDataAdapterSoapletISoapServiceConfig(headerSoaplet)) != null) {
                namespace = this.duringMconfigExist(mConfig);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesServerFormatter.getNamespace: " + namespace);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return namespace == null || namespace.trim().length() == 0 || namespace.equals("UnknownNamespace") ? "UnknownNamespace" : namespace;
    }

    private String duringMconfigExist(Object mConfig) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String namespace = null;
        if (mConfig.getClass().getSimpleName().equalsIgnoreCase(C_SOAP_SERVICE_CONFIG)) {
            namespace = (String)TibcoReflectionCache.getMSoapServiceConfigGetConcreteWsdlNamespace(mConfig);
        } else {
            Object endpointName = TibcoReflectionCache.getFSoapServiceConfigAdapterEndpointName(mConfig);
            if (endpointName != null) {
                namespace = (String)TibcoReflectionCache.getMExpandedNameGetNamespaceURI(endpointName);
            }
        }
        return namespace;
    }

    @Override
    public String getWebServiceURI(InvocationData data) {
        String webServiceURI = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object tUri;
            Object tCtx;
            Object soapMessage = data.getInvocationParameterAsObject(1);
            if (soapMessage != null && (tCtx = TibcoReflectionCache.getMSoapMessageGetTransportContext(soapMessage)) != null && (tUri = TibcoReflectionCache.getMTransportContextGetTransportUri(tCtx)) != null) {
                webServiceURI = tUri.toString();
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesServerFormatter.getWebServiceURI: " + webServiceURI);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return webServiceURI == null || webServiceURI.trim().length() == 0 || webServiceURI.equals("UnknownServiceName") ? "UnknownServiceName" : webServiceURI;
    }

    @Override
    public String getOperationName(InvocationData data) {
        String operationName = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object xDataAdapSoaplet;
            Object dSoapApplication = data.getInvocationObject();
            if (dSoapApplication != null && (xDataAdapSoaplet = TibcoReflectionCache.getFDefaultSoapApplicationBodySoaplet(dSoapApplication)) != null) {
                operationName = (String)TibcoReflectionCache.getFXDataAdapterSoapletOperationName(xDataAdapSoaplet);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesServerFormatter.getOperationName: " + operationName);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_OPERATION_NAME", bomb);
        }
        return operationName == null || operationName.trim().length() == 0 || operationName.equals("UnknownOperationName") ? "UnknownOperationName" : operationName;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel feedback, String name, InvocationData data) {
        String namespace = this.getNamespace(data);
        data.put("com.wily.soaextension.tibcobw.NamespaceKey", (Object)namespace);
        return ABlameComponent.getArrayInstance((Object[])new Object[]{name, namespace});
    }
}

