/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.webservice.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.feature.FaultFeature;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.SharedDataStructure2;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.CountMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.FaultedBlameTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.tibcobw.util.KConstants;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ClientSOAPFaultTracer
extends BlamePointTracer {
    boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();

    public ClientSOAPFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    private void processError(InvocationData data, String component, WilyTransactionElement start) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        boolean soapFlag = false;
        String objString = null;
        Throwable error = data.getInvocationThrownException();
        Object fData = TibcoReflectionCache.getMgetData(error);
        if (fData != null) {
            Method mAttribute = TibcoReflectionCache.getMAttributeGetStringValue(fData);
            Object fDataObj = mAttribute.invoke(fData, KConstants.EMPTY_OBJECT_ARRAY);
            if (fDataObj != null) {
                objString = (String)fDataObj;
            }
            if (soapFlag = objString != null) {
                String errorMessage = "SOAP Fault: " + start.getComponentName() + ": " + objString;
                if (this.isDebugEnabled) {
                    TibcoBWUtils.getLogger().debug("ClientSOAPFaultTracer - SOAP Fault Message: " + errorMessage);
                }
                FaultFeature.constructAndSendFaultSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
                FaultFeature.decorateTransactionsWithFault((InvocationData)data, (String)errorMessage);
                if (start instanceof FaultedBlameTransactionElement) {
                    FaultedBlameTransactionElement faultelem = (FaultedBlameTransactionElement)start;
                    FaultFeature.incrementFaultMetric((FaultedBlameTransactionElement)faultelem, (IStackElement)data);
                }
            }
        }
        Throwable errorNew = error;
        String errorMessage = String.valueOf(component) + ": " + errorNew.getClass().getName() + ": " + errorNew.getMessage();
        if (this.isDebugEnabled) {
            TibcoBWUtils.getLogger().debug("ClientSOAPFaultTracer - Error Message: " + errorMessage);
        }
        ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
        ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
        ErrorFeature.incrementErrorMetric((WilyTransactionElement)start, (IStackElement)data);
    }

    protected WilyTransactionElement constructTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation info) {
        HashMap<SharedDataStructure2, AgentMetric[]> agentMetrics = new HashMap<SharedDataStructure2, AgentMetric[]>();
        AgentMetric[] errorMetric = this.createErrorsMetric(String.valueOf(componentName) + ":" + "Errors Per Interval");
        CountMetricGathererWrapper wrapper = CountMetricGathererWrapper.getFactory((boolean)true);
        SharedDataStructure2 errorsSds = new SharedDataStructure2((ISharedElement)wrapper);
        agentMetrics.put(errorsSds, errorMetric);
        AgentMetric[] soapFaults = this.createErrorsMetric(String.valueOf(componentName) + ":" + "SOAP Faults Per Interval");
        return FaultFeature.createFaultedBlameTransactionElement((Object)key, (String)componentName, (int)blameStatus, (boolean)isStartTrace, (ITransactionElement)parent, (IBlameTransactionElement)previous, (IBlameTransactionElement)start, agentMetrics, null, null, null, (IRepository)errorsSds, null, (ProbeInformation)info, (AgentMetric[])soapFaults);
    }

    protected void updateCustomMetricsIfAny(WilyTransactionElement start, InvocationData data) {
        if (data.hasInvocationThrownException()) {
            try {
                String componentName = start.getComponentName();
                this.processError(data, componentName, start);
            }
            catch (Exception bomb) {
                TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_CLIENT_SOAPFAULT_TRACER", bomb);
            }
        }
    }

    protected ABlameComponent getBlameComponent(int tracerIndex, InvocationData data) {
        Object key = this.getBlameKey(data);
        return ABlameComponent.getInstance((Object)key);
    }

    protected Object getBlameKey(InvocationData data) {
        return String.valueOf(this.getComponentName(data)) + "|" + "SOAP Faults Per Interval";
    }
}

