/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.webservice.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.FaultFeature;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.FaultedBlameTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.tibcobw.util.KConstants;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;
import java.util.HashMap;

public class SOAPFaultTracer
extends BlamePointTracer {
    String objString = null;
    public static final String SOAP_FAULT_PER_INTERVAL = "SOAP Faults Per Interval";

    public SOAPFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected void updateCustomMetricsIfAny(WilyTransactionElement start, InvocationData data) {
        try {
            Method mAttribute;
            Object xiNodeObj;
            Object xiNodeObject;
            boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
            this.formatParameterizedResource(data);
            Object invObj = data.getInvocationObject();
            if (invObj != null && (xiNodeObject = data.getInvocationParameterAsObject(0)) != null && (xiNodeObj = (mAttribute = TibcoReflectionCache.getMAttributeGetStringValue(xiNodeObject)).invoke(xiNodeObject, KConstants.EMPTY_OBJECT_ARRAY)) != null) {
                this.objString = (String)xiNodeObj;
            }
            if (this.objString != null) {
                String errorMessage = "SOAP Fault: " + start.getComponentName() + ": " + this.objString;
                if (isDebugEnabled) {
                    TibcoBWUtils.getLogger().debug(errorMessage);
                }
                FaultFeature.constructAndSendFaultSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
                FaultFeature.decorateTransactionsWithFault((InvocationData)data, (String)errorMessage);
            }
            if (start instanceof FaultedBlameTransactionElement) {
                FaultedBlameTransactionElement faultelem = (FaultedBlameTransactionElement)start;
                FaultFeature.incrementFaultMetric((FaultedBlameTransactionElement)faultelem, (IStackElement)data);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_SOAPFAULTTRACER Thrown in Thread " + Thread.currentThread() + "DATA IS " + data, bomb);
        }
    }

    protected WilyTransactionElement constructTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation info) {
        HashMap agentMetrics = new HashMap();
        AgentMetric[] soapFaults = this.createErrorsMetric(String.valueOf(componentName) + ":" + SOAP_FAULT_PER_INTERVAL);
        return FaultFeature.createFaultedBlameTransactionElement((Object)key, (String)componentName, (int)blameStatus, (boolean)isStartTrace, (ITransactionElement)parent, (IBlameTransactionElement)previous, (IBlameTransactionElement)start, agentMetrics, null, null, null, null, null, (ProbeInformation)info, (AgentMetric[])soapFaults);
    }

    protected ABlameComponent getBlameComponent(int tracerIndex, InvocationData data) {
        Object key = this.getBlameKey(data);
        return ABlameComponent.getInstance((Object)key);
    }

    protected Object getBlameKey(InvocationData data) {
        return String.valueOf(this.getComponentName(data)) + "|" + SOAP_FAULT_PER_INTERVAL;
    }
}

