/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.webservice.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.BackendTracer;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.soaextension.tibcobw.webservice.nameformatter.WebServiceNameHelper;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class WebServiceConsumerTracer
extends BackendTracer {
    private static final String SEQUENCE_NUMBER2 = "Sequence Number";
    private static final String SESSION_ID2 = "Session ID";
    public static final String OPT_NAME = "OptName";
    public static final String WSAP_NAME = "WSAPName";
    public static final String SEQUENCE_NUMBER = "SequenceNumber";
    public static final String SESSION_ID = "SessionID";
    private static final Object[] EMPTYOBJECTARRAY = new Object[0];
    private static final Class[] EMPTYCLASSARRAY = new Class[0];
    private static final String GET_FIELD_MAP = "getFieldMap";
    private static Method getFieldMapMethod;
    private static Module sModule;
    private IModuleFeedbackChannel feedback;
    private static final WebServiceNameHelper webServiceNameHelper;

    static {
        sModule = new Module("Tibco WebService Consumer Tracer");
        webServiceNameHelper = new WebServiceNameHelper();
    }

    private static Method getGetFieldMapMethod() {
        return getFieldMapMethod;
    }

    private static void setGetFieldMapMethod(Method getFieldMapMethod) {
        WebServiceConsumerTracer.getFieldMapMethod = getFieldMapMethod;
    }

    public WebServiceConsumerTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object object) {
        super(agent, attributeListing, probeIdentification, object);
        this.feedback = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        data.setParameterCallback(new IInvocationDataParameterCallback(){

            public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map arg1) {
                Map fieldMap = WebServiceConsumerTracer.this.lookupMap(data);
                arg1.putAll(fieldMap);
            }
        });
        Map fieldMap = this.lookupMap(data);
        String corId = (String)fieldMap.get("WilyTraceID");
        if (corId != null) {
            new CorrelationId(corId);
        } else {
            this.feedback.warn(sModule, "No correlation id found in inbound webservice request");
        }
        String wsapName = "unset";
        String optName = "unset";
        if (fieldMap.containsKey(WSAP_NAME)) {
            wsapName = (String)fieldMap.get(WSAP_NAME);
            data.put(WSAP_NAME, fieldMap.get(WSAP_NAME));
        }
        if (fieldMap.containsKey(OPT_NAME)) {
            optName = (String)fieldMap.get(OPT_NAME);
            data.put(OPT_NAME, fieldMap.get(OPT_NAME));
        }
        if (this.getModuleFeedback().isDebugEnabled()) {
            this.getModuleFeedback().debug("Reading in new Thread - CorrelationID: " + this.getComponentTracer().getCrossProcessDataCache().getCorrelationID() + "; wsapName: " + wsapName + "; optName: " + optName);
        }
        String sessionID = (String)fieldMap.get(SESSION_ID);
        String sequenceNumber = (String)fieldMap.get(SEQUENCE_NUMBER);
        fieldMap.remove(WSAP_NAME);
        fieldMap.remove(SEQUENCE_NUMBER);
        fieldMap.remove(SESSION_ID);
        fieldMap.remove(OPT_NAME);
        super.ITracer_startTrace(tracerIndex, data);
        this.getComponentTracer().addExtraParameter(SESSION_ID2, sessionID);
        this.getComponentTracer().addExtraParameter(SEQUENCE_NUMBER2, sequenceNumber);
    }

    private Map lookupMap(InvocationData data) {
        try {
            Object requestExecutor = data.getInvocationObject();
            Object transportContext = webServiceNameHelper.analyzeTransportContext(requestExecutor, this.feedback);
            if (transportContext != null) {
                if (WebServiceConsumerTracer.getGetFieldMapMethod() == null) {
                    WebServiceConsumerTracer.setGetFieldMapMethod(transportContext.getClass().getMethod(GET_FIELD_MAP, EMPTYCLASSARRAY));
                    getFieldMapMethod.setAccessible(true);
                }
                this.feedback.debug(sModule, "LookupMap returned " + transportContext + " field is " + getFieldMapMethod);
                return (Map)getFieldMapMethod.invoke(transportContext, EMPTYOBJECTARRAY);
            }
        }
        catch (Exception e) {
            this.feedback.error((Throwable)e);
            this.feedback.error(sModule, "Error with code injection - Version change???");
        }
        return new HashMap();
    }
}

