/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.webservice.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.ASingleInstanceTracerFactoryHC;
import com.wily.soaextension.tibcobw.transport.tracer.RequestParameterContainer;
import com.wily.soaextension.tibcobw.util.TibcoBWUtils;
import com.wily.soaextension.tibcobw.util.TibcoReflectionCache;
import com.wily.util.properties.AttributeListing;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WebServiceDetectionTracer
extends ASingleInstanceTracerFactoryHC {
    public static final String URI = "uri";
    public static final String OPERATION = "operation";
    public static final String NAMESPACE = "namespace";
    public static final String K_UNKNOWN_WEBSERVICE = "UnknownServiceName";
    public static final String K_UNKNOWN_OPERATION = "UnknownOperationName";
    public static final String K_UNKNOWN_NAMESPACE = "UnknownNamespace";
    public static final String KUNKNOWNTRANSPORT = "UnknownTransport";
    public static final String K_UNKNOWN_QUEUE_TYPE = "UnknownQueueType";
    public static final String K_UNKNOWN_QUEUE_NAME = "UnknownQueue";
    private static final String C_SOAP_JMS_REQUESTOR = "com.tibco.bw.soap.share.reqrep.SoapJmsRequestor";
    public static final String ERROR_IN_WEBSERVICE_NAME = "ERROR_IN_WEBSERVICE_NAME";

    public WebServiceDetectionTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int arg0, InvocationData arg1) {
    }

    public void ITracer_startTrace(int arg0, InvocationData data) {
        try {
            RequestParameterContainer.get().put(NAMESPACE, this.getNamespace(data));
            RequestParameterContainer.get().put(OPERATION, this.getOperationName(data));
            RequestParameterContainer.get().put(URI, this.getWebServiceURI(data));
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), ERROR_IN_WEBSERVICE_NAME, bomb);
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public String getNamespace(InvocationData data) {
        String namespace = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object service;
            Object requestor;
            Object soapSendReceive = data.getInvocationObject();
            if (soapSendReceive != null && (requestor = TibcoReflectionCache.getFSoapSendReceiveActivityRequestor(soapSendReceive)) != null && (service = TibcoReflectionCache.getFSoapRequestorISoapServiceConfig(requestor)) != null) {
                namespace = (String)TibcoReflectionCache.getFSoapCommonConfigWsdlNamespace(service);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesClientFormatter.getNamespace: " + namespace);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), ERROR_IN_WEBSERVICE_NAME, bomb);
        }
        return namespace == null || namespace.trim().length() == 0 || namespace.equals(K_UNKNOWN_NAMESPACE) ? K_UNKNOWN_NAMESPACE : namespace;
    }

    public String getWebServiceURI(InvocationData data) {
        String webServiceURI = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object soapSendReceive = data.getInvocationObject();
            if (soapSendReceive != null) {
                webServiceURI = this.duringSoapSendReceiveExist(soapSendReceive);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesClientFormatter.getWebServiceURI: " + webServiceURI);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), ERROR_IN_WEBSERVICE_NAME, bomb);
        }
        return webServiceURI == null || webServiceURI.trim().length() == 0 || webServiceURI.equals(K_UNKNOWN_WEBSERVICE) ? K_UNKNOWN_WEBSERVICE : webServiceURI;
    }

    private String duringSoapSendReceiveExist(Object soapSendReceive) throws NoSuchFieldException, IllegalAccessException {
        String webServiceURI = null;
        Object requestor = TibcoReflectionCache.getFSoapSendReceiveActivityRequestor(soapSendReceive);
        if (requestor != null) {
            webServiceURI = this.duringRequestorNotNull(requestor);
        }
        return webServiceURI;
    }

    private String duringRequestorNotNull(Object requestor) throws NoSuchFieldException, IllegalAccessException {
        String webServiceURI = null;
        if (requestor.getClass().getName().equalsIgnoreCase(C_SOAP_JMS_REQUESTOR)) {
            Map urlToServiceConfigListMap;
            Object engineConfig = TibcoReflectionCache.getFSoapRequestorSoapEngineConfig(requestor);
            if (engineConfig != null && (urlToServiceConfigListMap = (Map)TibcoReflectionCache.getFSoapEngineConfigUrlToServiceConfigListMap(engineConfig)) != null) {
                Set col = urlToServiceConfigListMap.keySet();
                Iterator itr = col.iterator();
                while (itr.hasNext()) {
                    webServiceURI = itr.next().toString();
                }
            }
        } else {
            Object endpointConfig = TibcoReflectionCache.getFSoapHttpRequestorSoapEndpointConfig(requestor);
            if (endpointConfig != null) {
                webServiceURI = (String)TibcoReflectionCache.getFSoapEndpointConfigurationkString(endpointConfig);
            }
        }
        return webServiceURI;
    }

    public String getOperationName(InvocationData data) {
        String operationName = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object requestor;
            Object soapSendReceive = data.getInvocationObject();
            if (soapSendReceive != null && (requestor = TibcoReflectionCache.getFSoapSendReceiveActivityRequestor(soapSendReceive)) != null) {
                operationName = (String)TibcoReflectionCache.getFSoapRequestorOperationName(requestor);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesClientFormatter.getOperationName: " + operationName);
            }
        }
        catch (Exception bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_OPERATION_NAME", bomb);
        }
        return operationName == null || operationName.trim().length() == 0 || operationName.equals(K_UNKNOWN_OPERATION) ? K_UNKNOWN_OPERATION : operationName;
    }

    public void doOnStartTrace(int paramInt, IStackElement paramIStackElement, ITransactionElement paramITransactionElement) {
    }

    public void doOnEndTrace(int paramInt, IStackElement paramIStackElement, ITransactionElement paramITransactionElement) {
    }

    protected void doOnAbortedTransactionEndTrace(int arg0, IStackElement arg1) {
    }
}

