/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAMQUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.MQClassLoaderUtil;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QMRepository;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QMVO;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QueueManagerRepository;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QueueRepository;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QueueVO;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.MQDistributionListVO;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.MQTransactionTracerConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import com.wily.util.feedback.Module;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MQTransactionTracerUtil
extends MQClassLoaderUtil
implements MQTransactionTracerConstants {
    public static Map distributionListObjects = new WeakHashMap();
    public static Map qmActivityQueues = new WeakHashMap();
    public static Map sessionMessageProducers = new WeakHashMap();
    private static final Module kModule = new Module("MQTransactionTracerUtil");
    private static final String CLASS_NAME = "MQTransactionTracerUtil.";
    public static final String CORRELATION_ATTR_NAME = "CorID";
    public static final String MQ_CORRELATION_PROPERTY_NAME = "CA_APM_CorID";
    public static final String MQ_DESTINATION_PROPERTY_NAME = "CA_APM_Destination_Queue_Name";

    public static int getMQProviderVersion(Object jmsObject) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQProviderVersion(jmsObject) entry");
        int mqProviderVersion = 6;
        try {
            if (jmsObject != null) {
                String providerVersion = CAMQUtils.getJMSObjectProperty(jmsObject, "XMSC_WMQ_PROVIDER_VERSION");
                mqProviderVersion = !providerVersion.trim().equalsIgnoreCase("unspecified") ? Integer.parseInt(providerVersion.length() > 1 ? providerVersion.substring(0, 1) : providerVersion) : Integer.parseInt(CAMQUtils.getJMSObjectProperty(jmsObject, "version"));
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQProviderVersion(jmsObject) Ignoring method call for MQ6.x " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage()));
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQProviderVersion(jmsObject) mqProviderVersion " + mqProviderVersion);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQProviderVersion(jmsObject) exit");
        return mqProviderVersion;
    }

    public static String getJMSCorrelationID(Object jmsMessage) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSCorrelationID(jmsMessage) entry");
        String correlationID = "000000000000000000000000000000000000000000000000";
        try {
            if (jmsMessage != null) {
                Class<?> jmsMessageClass = jmsMessage.getClass();
                String jmsMessageClassName = jmsMessageClass.getName();
                String jmsMessageSuperClassName = jmsMessageClass.getSuperclass().getName();
                String jmsMessageSuper2ClassName = jmsMessageClass.getSuperclass().getSuperclass().getName();
                if (jmsMessageClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuperClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuper2ClassName.equals("com.ibm.jms.JMSMessage")) {
                    correlationID = (String)mJMSMessage_getJMSCorrelationID.invoke(jmsMessage, new Object[0]);
                } else if (jmsMessageClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuperClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuper2ClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl")) {
                    correlationID = (String)mJmsMessageImpl_getJMSCorrelationID.invoke(jmsMessage, new Object[0]);
                } else {
                    Method mMessage_getJMSCorrelationID = jmsMessageClass.getMethod("getJMSCorrelationID", new Class[0]);
                    correlationID = (String)mMessage_getJMSCorrelationID.invoke(jmsMessage, new Object[0]);
                }
                if (correlationID != null && correlationID.length() > 48) {
                    correlationID = correlationID.substring(3);
                }
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSCorrelationID(jmsMessage) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSCorrelationID(jmsMessage) correlationID " + correlationID);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSCorrelationID(jmsMessage) exit");
        return correlationID == null ? "000000000000000000000000000000000000000000000000" : correlationID.toUpperCase();
    }

    public static String getJMSMessageID(Object jmsMessage) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSMessageID(jmsMessage) entry");
        String messageID = "000000000000000000000000000000000000000000000000";
        try {
            if (jmsMessage != null) {
                Class<?> jmsMessageClass = jmsMessage.getClass();
                String jmsMessageClassName = jmsMessageClass.getName();
                String jmsMessageSuperClassName = jmsMessageClass.getSuperclass().getName();
                String jmsMessageSuper2ClassName = jmsMessageClass.getSuperclass().getSuperclass().getName();
                if (jmsMessageClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuperClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuper2ClassName.equals("com.ibm.jms.JMSMessage")) {
                    messageID = (String)mJMSMessage_getJMSMessageID.invoke(jmsMessage, new Object[0]);
                } else if (jmsMessageClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuperClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuper2ClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl")) {
                    messageID = (String)mJmsMessageImpl_getJMSMessageID.invoke(jmsMessage, new Object[0]);
                } else {
                    Method mMessage_getJMSMessageID = jmsMessageClass.getMethod("getJMSMessageID", new Class[0]);
                    messageID = (String)mMessage_getJMSMessageID.invoke(jmsMessage, new Object[0]);
                }
                if (messageID != null && messageID.length() > 48) {
                    messageID = messageID.substring(3);
                }
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSMessageID(jmsMessage) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSMessageID(jmsMessage) messageID " + messageID);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSMessageID(jmsMessage) exit");
        return messageID == null ? "000000000000000000000000000000000000000000000000" : messageID.toUpperCase();
    }

    public static void setJMSReportbitAndReplyToQueue(Object jmsMessage, Object jmsDestination) {
        block16: {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setJMSReportbitAndReplyToQueue(jmsMessage) entry");
            Object replyToQueue = null;
            int reportOpts = 4;
            try {
                if (jmsMessage == null || jmsDestination == null) break block16;
                Class<?> jmsMessageClass = jmsMessage.getClass();
                String jmsMessageClassName = jmsMessageClass.getName();
                String jmsMessageSuperClassName = jmsMessageClass.getSuperclass().getName();
                String jmsMessageSuper2ClassName = jmsMessageClass.getSuperclass().getSuperclass().getName();
                if (jmsMessageClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuperClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuper2ClassName.equals("com.ibm.jms.JMSMessage")) {
                    replyToQueue = mJMSMessage_getJMSReplyTo.invoke(jmsMessage, new Object[0]);
                    if (replyToQueue == null) {
                        mJMSMessage_setJMSReplyTo.invoke(jmsMessage, jmsDestination);
                    }
                    try {
                        Integer reportOptions = (Integer)mJMSMessage_getIntProperty.invoke(jmsMessage, "JMS_IBM_MQMD_Report");
                        if (reportOptions != null && reportOptions != 0) {
                            reportOpts |= reportOptions.intValue();
                        }
                    }
                    catch (Exception exception) {}
                    mJMSMessage_setIntProperty.invoke(jmsMessage, "JMS_IBM_MQMD_Report", new Integer(reportOpts));
                    break block16;
                }
                if (jmsMessageClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuperClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuper2ClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl")) {
                    replyToQueue = mJmsMessageImpl_getJMSReplyTo.invoke(jmsMessage, new Object[0]);
                    if (replyToQueue == null) {
                        mJmsMessageImpl_setJMSReplyTo.invoke(jmsMessage, jmsDestination);
                    }
                    try {
                        Integer reportOptions = (Integer)mJmsMessageImpl_getIntProperty.invoke(jmsMessage, "JMS_IBM_MQMD_Report");
                        if (reportOptions != null && reportOptions != 0) {
                            reportOpts |= reportOptions.intValue();
                        }
                    }
                    catch (Exception exception) {}
                    mJmsMessageImpl_setIntProperty.invoke(jmsMessage, "JMS_IBM_MQMD_Report", new Integer(reportOpts));
                    break block16;
                }
                Method mMessage_getJMSReplyTo = jmsMessageClass.getMethod("getJMSReplyTo", new Class[0]);
                replyToQueue = mMessage_getJMSReplyTo.invoke(jmsMessage, new Object[0]);
                if (replyToQueue == null) {
                    Method mMessage_setJMSReplyTo = jmsMessageClass.getMethod("setJMSReplyTo", CLS_Destination);
                    mMessage_setJMSReplyTo.invoke(jmsMessage, jmsDestination);
                }
                Method mMessage_getIntProperty = jmsMessageClass.getMethod("getIntProperty", String.class);
                try {
                    Integer reportOptions = (Integer)mMessage_getIntProperty.invoke(jmsMessage, "JMS_IBM_MQMD_Report");
                    if (reportOptions != null && reportOptions != 0) {
                        reportOpts |= reportOptions.intValue();
                    }
                }
                catch (Exception exception) {}
                Method mMessage_setIntProperty = jmsMessageClass.getMethod("setIntProperty", String.class, Integer.TYPE);
                mMessage_setIntProperty.invoke(jmsMessage, "JMS_IBM_MQMD_Report", new Integer(reportOpts));
            }
            catch (Exception e) {
                MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setJMSReportbitAndReplyToQueue(jmsMessage) ", (Throwable)e);
            }
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setJMSReportbitAndReplyToQueue(jmsMessage) exit");
    }

    public static void setJMSDestinationBooleanProperty(Object jmsDestination, String propertyName, boolean propertyValue) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setJMSDestinationBooleanProperty(jmsDestination,propertyName,propertyValue) entry");
        try {
            if (jmsDestination != null) {
                mJmsPropertyContextImpl_setBooleanProperty.invoke(jmsDestination, propertyName, new Boolean(propertyValue));
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setJMSDestinationBooleanProperty(jmsDestination,propertyName,propertyValue) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setJMSDestinationBooleanProperty(jmsDestination,propertyName,propertyValue) exit");
    }

    public static String getJMSDestinationName(Object jmsDestination) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSDestinationName(jmsDestination) entry");
        String jmsDestinationName = null;
        try {
            if (jmsDestination != null) {
                Class<?> jmsDestinationClass = jmsDestination.getClass();
                String jmsDestinationClassName = jmsDestinationClass.getName();
                if (jmsDestinationClassName.equals("com.ibm.mq.jms.MQQueue") || jmsDestinationClassName.equals("com.ibm.mq.jms.MQDestination") || jmsDestinationClassName.equals("com.ibm.msg.client.jms.admin.JmsDestinationImpl") || jmsDestinationClassName.equals("com.ibm.msg.client.jms.admin.JmsJndiDestinationImpl")) {
                    jmsDestinationName = (String)mJmsDestinationImpl_getName.invoke(jmsDestination, new Object[0]);
                } else if (!jmsDestinationClassName.equals("com.ibm.mq.jms.MQTemporaryQueue")) {
                    jmsDestinationClassName.equals("com.ibm.msg.client.jms.internal.JmsTemporaryQueueImpl");
                }
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSDestinationName(jmsDestination) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSDestinationName(jmsDestination) jmsDestinationName " + jmsDestinationName);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSDestinationName(jmsDestination) exit");
        return jmsDestinationName;
    }

    public static Hashtable getJMSPropertiesObject(Object jmsObject, Object jmsDestination) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSPropertiesObject(jmsObject) entry");
        Hashtable jmsProperties = null;
        try {
            if (jmsObject != null) {
                jmsProperties = CAMQUtils.getJMSObjectProperties(jmsObject, jmsDestination);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSPropertiesObject(jmsObject) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSPropertiesObject(jmsObject) jmsProperties " + jmsProperties);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSPropertiesObject(jmsObject) exit");
        return jmsProperties;
    }

    public static Object getJMSSessionObject(Object jmsObject) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSSessionObject(jmsObject) entry");
        Object jmsSessionObject = null;
        try {
            if (jmsObject != null) {
                String jmsObjectClassName = jmsObject.getClass().getName();
                if (jmsObjectClassName.equals("com.ibm.mq.jms.MQMessageProducer") || jmsObjectClassName.equals("com.ibm.mq.jms.MQQueueSender")) {
                    Object jmsMessageProducerObject = fMQMessageProducer_commonProducer.get(jmsObject);
                    jmsSessionObject = fJmsMessageProducerImpl_session.get(jmsMessageProducerObject);
                } else if (jmsObjectClassName.equals("com.ibm.mq.jms.MQMessageConsumer") || jmsObjectClassName.equals("com.ibm.mq.jms.MQQueueReceiver")) {
                    Object jmsMessageConsumerObject = fMQMessageConsumer_commonConsumer.get(jmsObject);
                    jmsSessionObject = fJmsMessageConsumerImpl_session.get(jmsMessageConsumerObject);
                }
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSSessionObject(jmsObject) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSSessionObject(jmsObject) exit");
        return jmsSessionObject;
    }

    public static Object getJMSDestinationObject(Object jmsObject) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSDestinationObject(jmsObject) entry");
        Object jmsDestinationObject = null;
        try {
            if (jmsObject != null) {
                String jmsObjectClassName = jmsObject.getClass().getName();
                if (jmsObjectClassName.equals("com.ibm.mq.jms.MQMessageProducer") || jmsObjectClassName.equals("com.ibm.mq.jms.MQQueueSender")) {
                    Object jmsMessageProducerObject = fMQMessageProducer_commonProducer.get(jmsObject);
                    String jmsMessageProducerClassName = jmsMessageProducerObject.getClass().getName();
                    if (jmsMessageProducerClassName.equals("com.ibm.msg.client.jms.internal.JmsQueueSenderImpl")) {
                        jmsDestinationObject = fJmsQueueSenderImpl_queue.get(jmsMessageProducerObject);
                    } else if (jmsMessageProducerClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageProducerImpl")) {
                        jmsDestinationObject = fJmsMessageProducerImpl_destination.get(jmsMessageProducerObject);
                    }
                } else if (jmsObjectClassName.equals("com.ibm.mq.jms.MQMessageConsumer") || jmsObjectClassName.equals("com.ibm.mq.jms.MQQueueReceiver")) {
                    Object jmsMessageConsumerObject = fMQMessageConsumer_commonConsumer.get(jmsObject);
                    String jmsMessageConsumerClassName = jmsMessageConsumerObject.getClass().getName();
                    if (jmsMessageConsumerClassName.equals("com.ibm.msg.client.jms.internal.JmsQueueReceiverImpl")) {
                        jmsDestinationObject = fJmsQueueReceiverImpl_queue.get(jmsMessageConsumerObject);
                    } else if (jmsMessageConsumerClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl")) {
                        jmsDestinationObject = fJmsMessageConsumerImpl_destination.get(jmsMessageConsumerObject);
                    }
                } else if (jmsObjectClassName.equals("com.ibm.mq.jms.MQSession$FacadeMessageListener")) {
                    Object mdbWrapperObject;
                    String mdbWrapperObjectClassName;
                    if (fMQSession$FacadeMessageListener_listener != null && !(mdbWrapperObjectClassName = (mdbWrapperObject = fMQSession$FacadeMessageListener_listener.get(jmsObject)).getClass().getName()).equals("com.ibm.mq.connector.inbound.MessageEndpointWrapper")) {
                        Field mdbWrapperJmsDest = null;
                        mdbWrapperJmsDest = mdbWrapperObject.getClass().getDeclaredField("jmsDest");
                        mdbWrapperJmsDest.setAccessible(true);
                        jmsDestinationObject = mdbWrapperJmsDest.get(mdbWrapperObject);
                    }
                } else if (jmsObjectClassName.equals("com.ibm.mq.jms.MQMessageConsumer$FacadeMessageListener") && fMQMessageConsumer$FacadeMessageListener_this$0 != null) {
                    Object jmsParentObject = fMQMessageConsumer$FacadeMessageListener_this$0.get(jmsObject);
                    jmsDestinationObject = MQTransactionTracerUtil.getJMSDestinationObject(jmsParentObject);
                }
            }
        }
        catch (NoSuchFieldException nsfEx) {
            jmsDestinationObject = null;
            MQPPLog.getLogger().warn(kModule, "MQTransactionTracerUtil.getJMSDestinationObject(jmsObject) " + nsfEx.getMessage());
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSDestinationObject(jmsObject) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSDestinationObject(jmsObject) jmsDestinationObject " + jmsDestinationObject);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSDestinationObject(jmsObject) exit");
        return jmsDestinationObject;
    }

    public static Object getJMSListenerParent(Object jmsListenerObject) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSListenerParent(jmsObject) entry");
        Object jmsListenerParent = null;
        try {
            if (jmsListenerObject != null) {
                String jmsObjectClassName = jmsListenerObject.getClass().getName();
                if (jmsObjectClassName.equals("com.ibm.mq.jms.MQSession$FacadeMessageListener")) {
                    if (fMQSession$FacadeMessageListener_this$0 == null) {
                        fMQSession$FacadeMessageListener_this$0 = jmsListenerObject.getClass().getDeclaredField("this$0");
                        fMQSession$FacadeMessageListener_this$0.setAccessible(true);
                    }
                    jmsListenerParent = fMQSession$FacadeMessageListener_this$0.get(jmsListenerObject);
                } else if (jmsObjectClassName.equals("com.ibm.mq.jms.MQMessageConsumer$FacadeMessageListener")) {
                    if (fMQMessageConsumer$FacadeMessageListener_this$0 == null) {
                        fMQMessageConsumer$FacadeMessageListener_this$0 = jmsListenerObject.getClass().getDeclaredField("this$0");
                        fMQMessageConsumer$FacadeMessageListener_this$0.setAccessible(true);
                    }
                    jmsListenerParent = fMQMessageConsumer$FacadeMessageListener_this$0.get(jmsListenerObject);
                }
            }
        }
        catch (NoSuchFieldException nsfEx) {
            jmsListenerParent = null;
            MQPPLog.getLogger().warn(kModule, "MQTransactionTracerUtil.getJMSListenerParent(jmsObject) " + nsfEx.getMessage());
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSListenerParent(jmsObject) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSListenerParent(jmsObject) jmsListenerParent " + jmsListenerParent);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSListenerParent(jmsObject) exit");
        return jmsListenerParent;
    }

    public static String getMQCorrelationID(Object mqMessage) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQCorrelationID(mqMessage) entry");
        String correlationID = "000000000000000000000000000000000000000000000000";
        Class<?> mqMessageClass = mqMessage.getClass();
        if (mqMessageClass.getName().equals("com.ibm.mq.MQMessage") || mqMessageClass.getSuperclass().getName().equals("com.ibm.mq.MQMsg2") || mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMessage") || mqMessageClass.getSuperclass().getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2")) {
            mqMessageClass = mqMessageClass.getSuperclass();
        }
        try {
            if (mqMessageClass.getName().equals("com.ibm.mq.MQMsg2")) {
                String corrID = MQTransactionTracerUtil.getHexId(MQTransactionTracerUtil.getBytes(mMQMsg2_getCorrelationId.invoke(mqMessage, new Object[0])));
                int length = corrID.length() - 48;
                correlationID = corrID.substring(length, corrID.length());
                MQPPLog.getLogger().debug(kModule, "MQMsg2 correlationID: " + correlationID);
            } else if (mqMessageClass.getName().equals("com.ibm.mq.MQMD")) {
                String corrID = MQTransactionTracerUtil.getHexId(MQTransactionTracerUtil.getBytes(fMQMD_correlationId.get(mqMessage)));
                int length = corrID.length() - 48;
                correlationID = corrID.substring(length, corrID.length());
                MQPPLog.getLogger().debug(kModule, "MQMessage correlationID: " + correlationID);
            } else if (mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2")) {
                String corrID = MQTransactionTracerUtil.getHexId(MQTransactionTracerUtil.getBytes(mMQMsg26_getCorrelationId.invoke(mqMessage, new Object[0])));
                int length = corrID.length() - 48;
                correlationID = corrID.substring(length, corrID.length());
                MQPPLog.getLogger().debug(kModule, "MQMsg2 correlationID: " + correlationID);
            } else if (mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMD")) {
                String corrID = MQTransactionTracerUtil.getHexId(MQTransactionTracerUtil.getBytes(fMQMD6_correlationId.get(mqMessage)));
                int length = corrID.length() - 48;
                correlationID = corrID.substring(length, corrID.length());
                MQPPLog.getLogger().debug(kModule, "MQMessage correlationID: " + correlationID);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQCorrelationID(mqMessage) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQCorrelationID(mqMessage) exit");
        return correlationID == null ? "000000000000000000000000000000000000000000000000" : correlationID.toUpperCase();
    }

    public static String getMQMessageID(Object mqMessage) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQMessageID(mqMessage) entry");
        String messageID = "000000000000000000000000000000000000000000000000";
        Class<?> mqMessageClass = mqMessage.getClass();
        if (mqMessageClass.getName().equals("com.ibm.mq.MQMessage") || mqMessageClass.getSuperclass().getName().equals("com.ibm.mq.MQMsg2") || mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMessage") || mqMessageClass.getSuperclass().getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2")) {
            mqMessageClass = mqMessageClass.getSuperclass();
        }
        try {
            if (mqMessageClass.getName().equals("com.ibm.mq.MQMsg2")) {
                String MsgID = MQTransactionTracerUtil.getHexId(MQTransactionTracerUtil.getBytes(mMQMsg2_getMessageId.invoke(mqMessage, new Object[0])));
                int length = MsgID.length() - 48;
                messageID = MsgID.substring(length, MsgID.length());
                MQPPLog.getLogger().debug(kModule, "MQMsg2 messageID: " + messageID);
            } else if (mqMessageClass.getName().equals("com.ibm.mq.MQMD")) {
                String MsgID = MQTransactionTracerUtil.getHexId(MQTransactionTracerUtil.getBytes(fMQMD_messageId.get(mqMessage)));
                int length = MsgID.length() - 48;
                messageID = MsgID.substring(length, MsgID.length());
                MQPPLog.getLogger().debug(kModule, "MQMessage messageID: " + messageID);
            } else if (mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2")) {
                String MsgID = MQTransactionTracerUtil.getHexId(MQTransactionTracerUtil.getBytes(mMQMsg26_getMessageId.invoke(mqMessage, new Object[0])));
                int length = MsgID.length() - 48;
                messageID = MsgID.substring(length, MsgID.length());
                MQPPLog.getLogger().debug(kModule, "MQMsg2 messageID: " + messageID);
            } else if (mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMD")) {
                String MsgID = MQTransactionTracerUtil.getHexId(MQTransactionTracerUtil.getBytes(fMQMD6_messageId.get(mqMessage)));
                int length = MsgID.length() - 48;
                messageID = MsgID.substring(length, MsgID.length());
                MQPPLog.getLogger().debug(kModule, "MQMessage messageID: " + messageID);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQMessageID(mqMessage) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQMessageID(mqMessage) exit");
        return messageID == null ? "000000000000000000000000000000000000000000000000" : messageID.toUpperCase();
    }

    public static void setReportbitAndReplyToQueue(Object mqMessage) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setReportbitAndReplyToQueue(mqMessage) entry");
        String replyToQueue = null;
        int reportOpts = 4;
        Class<?> mqMessageClass = mqMessage.getClass();
        if (mqMessageClass.getName().equals("com.ibm.mq.MQMessage") || mqMessageClass.getSuperclass().getName().equals("com.ibm.mq.MQMsg2") || mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMessage") || mqMessageClass.getSuperclass().getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2")) {
            mqMessageClass = mqMessageClass.getSuperclass();
        }
        try {
            if (mqMessageClass.getName().equals("com.ibm.mq.MQMsg2")) {
                String sUserId;
                replyToQueue = (String)mMQMsg2_getReplyToQueueName.invoke(mqMessage, new Object[0]);
                if (replyToQueue == null || (replyToQueue = replyToQueue.trim()).length() == 0 || "CA_WILY_REPLY_NONE".equals(replyToQueue)) {
                    mMQMsg2_setReplyToQueueName.invoke(mqMessage, "SYSTEM.ADMIN.ACTIVITY.QUEUE");
                }
                mMQMsg2_setReport.invoke(mqMessage, new Integer(reportOpts |= ((Integer)mMQMsg2_getReport.invoke(mqMessage, new Object[0])).intValue()));
                if (TraceProperties.extractUserid && (sUserId = (String)mMQMsg2_getUserId.invoke(mqMessage, new Object[0])) != null && (sUserId = sUserId.trim()).length() > 0) {
                    MQPPLog.getLogger().info(kModule, "UserId: " + sUserId);
                }
            } else if (mqMessageClass.getName().equals("com.ibm.mq.MQMD")) {
                String sUserId;
                replyToQueue = (String)fMQMD_replyToQueueName.get(mqMessage);
                if (replyToQueue == null || replyToQueue.trim().length() == 0) {
                    fMQMD_replyToQueueName.set(mqMessage, "SYSTEM.ADMIN.ACTIVITY.QUEUE");
                }
                fMQMD_report.setInt(mqMessage, reportOpts |= fMQMD_report.getInt(mqMessage));
                if (TraceProperties.extractUserid && (sUserId = (String)fMQMD_userId.get(mqMessage)) != null && (sUserId = sUserId.trim()).length() > 0) {
                    MQPPLog.getLogger().info(kModule, "UserId: " + sUserId);
                }
            } else if (mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2")) {
                String sUserId;
                replyToQueue = (String)mMQMsg26_getReplyToQueueName.invoke(mqMessage, new Object[0]);
                if (replyToQueue == null || (replyToQueue = replyToQueue.trim()).length() == 0 || "CA_WILY_REPLY_NONE".equals(replyToQueue)) {
                    mMQMsg26_setReplyToQueueName.invoke(mqMessage, "SYSTEM.ADMIN.ACTIVITY.QUEUE");
                }
                mMQMsg26_setReport.invoke(mqMessage, new Integer(reportOpts |= ((Integer)mMQMsg26_getReport.invoke(mqMessage, new Object[0])).intValue()));
                if (TraceProperties.extractUserid && (sUserId = (String)mMQMsg26_getUserId.invoke(mqMessage, new Object[0])) != null && (sUserId = sUserId.trim()).length() > 0) {
                    MQPPLog.getLogger().info(kModule, "UserId: " + sUserId);
                }
            } else if (mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMD")) {
                String sUserId;
                replyToQueue = (String)fMQMD6_replyToQueueName.get(mqMessage);
                if (replyToQueue == null || replyToQueue.trim().length() == 0) {
                    fMQMD6_replyToQueueName.set(mqMessage, "SYSTEM.ADMIN.ACTIVITY.QUEUE");
                }
                fMQMD6_report.setInt(mqMessage, reportOpts |= fMQMD6_report.getInt(mqMessage));
                if (TraceProperties.extractUserid && (sUserId = (String)fMQMD6_userId.get(mqMessage)) != null && (sUserId = sUserId.trim()).length() > 0) {
                    MQPPLog.getLogger().info(kModule, "UserId: " + sUserId);
                }
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setReportbitAndReplyToQueue(mqMessage) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setReportbitAndReplyToQueue(mqMessage) exit");
    }

    public static void setMessageUserID(Object mqMessage) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setMessageUserID(mqMessage) entry");
        String userID = "CA_WILY";
        Class<?> mqMessageClass = mqMessage.getClass();
        if (mqMessageClass.getName().equals("com.ibm.mq.MQMessage") || mqMessageClass.getSuperclass().getName().equals("com.ibm.mq.MQMsg2") || mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMessage") || mqMessageClass.getSuperclass().getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2")) {
            mqMessageClass = mqMessageClass.getSuperclass();
        }
        try {
            if (mqMessageClass.getName().equals("com.ibm.mq.MQMsg2")) {
                mMQMsg2_setUserId.invoke(mqMessage, userID);
            } else if (mqMessageClass.getName().equals("com.ibm.mq.MQMD")) {
                fMQMD_userId.set(mqMessage, userID);
            } else if (mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2")) {
                mMQMsg26_setUserId.invoke(mqMessage, userID);
            } else if (mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMD")) {
                fMQMD6_userId.set(mqMessage, userID);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setMessageUserID(mqMessage) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setMessageUserID(mqMessage) exit");
    }

    public static int getAliasBaseQueueType(Object mqQueue, String qName) {
        QueueVO queueVO = QueueRepository.getQueueVO(mqQueue, qName);
        return queueVO.getBaseQueueType();
    }

    public static int getAliasBaseQueueDefinitionType(Object mqQueue, String qName) {
        QueueVO queueVO = QueueRepository.getQueueVO(mqQueue, qName);
        return queueVO.getBaseQueueDefinitionType();
    }

    public static String getAliasBaseQueueName(Object mqQueue, String qName) {
        QueueVO queueVO = QueueRepository.getQueueVO(mqQueue, qName);
        return queueVO.getBaseQueueName();
    }

    public static int getQueueDefinitionType(Object mqQueue, String qName) {
        QueueVO queueVO = QueueRepository.getQueueVO(mqQueue, qName);
        return queueVO.getQueueDefinitionType();
    }

    public static int getQueueType(Object mqQueue, String qName) {
        QueueVO queueVO = QueueRepository.getQueueVO(mqQueue, qName);
        return queueVO.getQueueType();
    }

    public static String getQueueManagerName(Object mqQueue) {
        QueueVO queueVO = QueueRepository.getQueueVO(mqQueue, null);
        return queueVO.getQmName();
    }

    public static QueueVO getQueueVO(Object mqQueue, Object mqQueueManager, String queueName, Hashtable props) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getQueueVO(mqQueue, mqQueueManager, queueName, props) entry");
        QueueVO queueVO = null;
        if (props != null) {
            queueVO = QueueRepository.getQueueVO(mqQueue, queueName, props);
        } else if (mqQueue != null) {
            queueVO = QueueRepository.getQueueVO(mqQueue, queueName);
        } else if (mqQueueManager != null) {
            queueVO = QueueManagerRepository.getQueueVO(mqQueueManager, queueName);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getQueueVO(mqQueue, mqQueueManager, queueName, props) queueVO " + queueVO);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getQueueVO(mqQueue, mqQueueManager, queueName, props) exit");
        return queueVO;
    }

    public static Object getQueueManager(Object mqQueue) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getQueueManager(mqQueue) entry");
        Object qm = null;
        if (mqQueue == null) {
            return qm;
        }
        try {
            qm = mqQueue.getClass().getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueue") ? fMQQueue6_mgr.get(mqQueue) : fMQQueue_mgr.get(mqQueue);
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getQueueManager(mqQueue) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getQueueManager(mqQueue) qm " + qm);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getQueueManager(mqQueue) exit");
        return qm;
    }

    public static String getQMName(Object mqQueueManager) {
        QMVO qmVO = QMRepository.getQMVO(mqQueueManager);
        return qmVO.getQMName();
    }

    public static String getQueueName(Object mqQueue) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getQueueName(mqQueue) entry");
        String qName = null;
        if (mqQueue == null) {
            return qName;
        }
        try {
            qName = mqQueue.getClass().getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueue") ? ((String)fMQManagedObject6_name.get(mqQueue)).trim() : ((String)fMQManagedObject_name.get(mqQueue)).trim();
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getQueueName(mqQueue) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getQueueName(mqQueue) qName " + qName);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getQueueName(mqQueue) exit");
        return qName;
    }

    public static Object createDummyMessage(QueueVO queueVO, Object mqMessage, Object objMessageID) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.createDummyMessage(queueVO, mqMessage, objMessageID) entry");
        Object dummyMQMessage = null;
        Object arrMessageId = objMessageID;
        String sUserId = "";
        long lPutDateTime = 0L;
        int expiryTime = -1;
        boolean mqv6Message = false;
        MQClassLoaderUtil.initialize(mqMessage.getClass().getClassLoader());
        try {
            Class<?> mqMessageClass = mqMessage.getClass();
            if (mqMessageClass.getName().equals("com.ibm.mq.MQMessage") || mqMessageClass.getSuperclass().getName().equals("com.ibm.mq.MQMsg2") || mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMessage") || mqMessageClass.getSuperclass().getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2")) {
                mqMessageClass = mqMessageClass.getSuperclass();
            }
            if (mqMessageClass.getName().equals("com.ibm.mq.MQMsg2")) {
                if (arrMessageId == null) {
                    arrMessageId = mMQMsg2_getMessageId.invoke(mqMessage, new Object[0]);
                }
                sUserId = ((String)mMQMsg2_getUserId.invoke(mqMessage, new Object[0])).trim();
                expiryTime = (Integer)mMQMsg2_getExpiry.invoke(mqMessage, new Object[0]);
                lPutDateTime = (Long)mMQMsg2_getPutTimeMillis.invoke(mqMessage, new Object[0]);
            } else if (mqMessageClass.getName().equals("com.ibm.mq.MQMD")) {
                if (arrMessageId == null) {
                    arrMessageId = fMQMD_messageId.get(mqMessage);
                }
                sUserId = ((String)fMQMD_userId.get(mqMessage)).trim();
                expiryTime = fMQMD_expiry.getInt(mqMessage);
                lPutDateTime = ((GregorianCalendar)fMQMD_putDateTime.get(mqMessage)).getTimeInMillis();
            } else if (mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2")) {
                mqv6Message = true;
                if (arrMessageId == null) {
                    arrMessageId = mMQMsg26_getMessageId.invoke(mqMessage, new Object[0]);
                }
                sUserId = ((String)mMQMsg26_getUserId.invoke(mqMessage, new Object[0])).trim();
                expiryTime = (Integer)mMQMsg26_getExpiry.invoke(mqMessage, new Object[0]);
                lPutDateTime = (Long)mMQMsg26_getPutTimeMillis.invoke(mqMessage, new Object[0]);
            } else if (mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMD")) {
                mqv6Message = true;
                if (arrMessageId == null) {
                    arrMessageId = fMQMD6_messageId.get(mqMessage);
                }
                sUserId = ((String)fMQMD6_userId.get(mqMessage)).trim();
                expiryTime = fMQMD6_expiry.getInt(mqMessage);
                lPutDateTime = ((GregorianCalendar)fMQMD6_putDateTime.get(mqMessage)).getTimeInMillis();
            }
            if (mqv6Message) {
                dummyMQMessage = CLS_MQMessage6.newInstance();
                fMQMD6_correlationId.set(dummyMQMessage, arrMessageId);
                fMQMD6_persistence.setInt(dummyMQMessage, 0);
                fMQMD6_format.set(dummyMQMessage, "MQSTR   ");
                mMQMessage6_writeString.invoke(dummyMQMessage, "APPLICATION_NAME=CA_WILY_MQPP||PUT_DATE_TIME=" + MQTransactionTracerUtil.convertTimeinMillisToGMT(lPutDateTime) + "||" + "QUEUE_MANAGER_NAME" + "=" + queueVO.getQmName() + "||" + "QUEUE_NAME" + "=" + queueVO.getQueueName() + "||" + "USER_ID" + "=" + sUserId + "||" + "MESSAGE_EXPIRY" + "=" + String.valueOf(expiryTime));
            } else {
                dummyMQMessage = CLS_MQMessage.newInstance();
                fMQMD_correlationId.set(dummyMQMessage, arrMessageId);
                fMQMD_persistence.setInt(dummyMQMessage, 0);
                fMQMD_format.set(dummyMQMessage, "MQSTR   ");
                mMQMessage_writeString.invoke(dummyMQMessage, "APPLICATION_NAME=CA_WILY_MQPP||PUT_DATE_TIME=" + MQTransactionTracerUtil.convertTimeinMillisToGMT(lPutDateTime) + "||" + "QUEUE_MANAGER_NAME" + "=" + queueVO.getQmName() + "||" + "QUEUE_NAME" + "=" + queueVO.getQueueName() + "||" + "USER_ID" + "=" + sUserId + "||" + "MESSAGE_EXPIRY" + "=" + String.valueOf(expiryTime));
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.createDummyMessage(queueVO, mqMessage, objMessageID) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.createDummyMessage(queueVO, mqMessage, objMessageID) dummyMQMessage " + dummyMQMessage);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.createDummyMessage(queueVO, mqMessage, objMessageID) exit");
        return dummyMQMessage;
    }

    public static void putDummyMessage(Object mqQueueManager, Object dummyMQMessage) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.putDummyMessage(mqQueueManager, dummyMQMessage) entry");
        if (dummyMQMessage == null) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.putDummyMessage(mqQueueManager, dummyMQMessage) Input dummy MQ message is NULL");
            return;
        }
        Object activityQueue = qmActivityQueues.get(mqQueueManager);
        try {
            if (activityQueue == null) {
                activityQueue = MQTransactionTracerUtil.accessQueueOnQueueManager(mqQueueManager, "SYSTEM.ADMIN.ACTIVITY.QUEUE", 8240);
                qmActivityQueues.put(mqQueueManager, activityQueue);
            }
            if (activityQueue.getClass().getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueue")) {
                mMQQueue6_put.invoke(activityQueue, dummyMQMessage);
            } else {
                mMQQueue_put.invoke(activityQueue, dummyMQMessage);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.putDummyMessage(mqQueueManager, dummyMQMessage) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.putDummyMessage(mqQueueManager, dummyMQMessage) exit");
    }

    public static Object createDummyJMSMessage(QueueVO queueVO, Object jmsMessage, Object jmsSessionObject, long timeToLive) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.createDummyMessage(queueVO, jmsMessage, jmsSessionObject, timeToLive) entry");
        Object dummyJMSMessage = null;
        String jmsMessageId = null;
        long lPutDateTime = 0L;
        MQClassLoaderUtil.initialize(Thread.currentThread().getContextClassLoader());
        try {
            Class<?> jmsMessageClass = jmsMessage.getClass();
            String jmsMessageClassName = jmsMessageClass.getName();
            String jmsMessageSuperClassName = jmsMessageClass.getSuperclass().getName();
            String jmsMessageSuper2ClassName = jmsMessageClass.getSuperclass().getSuperclass().getName();
            if (jmsMessageClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuperClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuper2ClassName.equals("com.ibm.jms.JMSMessage")) {
                jmsMessageId = (String)mJMSMessage_getJMSMessageID.invoke(jmsMessage, new Object[0]);
                lPutDateTime = (Long)mJMSMessage_getJMSTimestamp.invoke(jmsMessage, new Object[0]);
            } else if (jmsMessageClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuperClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuper2ClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl")) {
                jmsMessageId = (String)mJmsMessageImpl_getJMSMessageID.invoke(jmsMessage, new Object[0]);
                lPutDateTime = (Long)mJmsMessageImpl_getJMSTimestamp.invoke(jmsMessage, new Object[0]);
            } else {
                Method mMessage_getJMSMessageID = jmsMessageClass.getMethod("getJMSMessageID", new Class[0]);
                jmsMessageId = (String)mMessage_getJMSMessageID.invoke(jmsMessage, new Object[0]);
                Method mMessage_getJMSTimestamp = jmsMessageClass.getMethod("getJMSMessageID", new Class[0]);
                lPutDateTime = (Long)mMessage_getJMSTimestamp.invoke(jmsMessage, new Object[0]);
            }
            timeToLive = timeToLive <= 0L ? -1L : (timeToLive + 100L) / 100L;
            dummyJMSMessage = mJmsSessionImpl_createTextMessage.invoke(jmsSessionObject, new Object[0]);
            mJmsMessageImpl_setJMSCorrelationID.invoke(dummyJMSMessage, jmsMessageId);
            mJmsMessageImpl_setJMSDeliveryMode.invoke(dummyJMSMessage, new Integer(1));
            mJmsTextMessageImpl_setText.invoke(dummyJMSMessage, "APPLICATION_NAME=CA_WILY_MQPP||PUT_DATE_TIME=" + MQTransactionTracerUtil.convertTimeinMillisToGMT(lPutDateTime) + "||" + "QUEUE_MANAGER_NAME" + "=" + queueVO.getQmName() + "||" + "QUEUE_NAME" + "=" + queueVO.getQueueName() + "||" + "MESSAGE_EXPIRY" + "=" + String.valueOf(timeToLive));
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.createDummyMessage(queueVO, jmsMessage, jmsSessionObject, timeToLive) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.createDummyMessage(queueVO, jmsMessage, jmsSessionObject, timeToLive) exit");
        return dummyJMSMessage;
    }

    public static void sendDummyMessage(Object jmsSession, Object dummyJMSMessage, long timeToLive) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.sendDummyMessage(jmsMessageProducer, dummyJMSMessage, timeToLive) entry");
        if (dummyJMSMessage == null) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.sendDummyMessage(jmsMessageProducer, dummyJMSMessage, timeToLive) Input dummy JMS message is NULL");
            return;
        }
        Object activityMessageProducer = sessionMessageProducers.get(jmsSession);
        try {
            if (activityMessageProducer == null) {
                activityMessageProducer = MQTransactionTracerUtil.createMessageProducer(jmsSession, "SYSTEM.ADMIN.ACTIVITY.QUEUE");
                sessionMessageProducers.put(jmsSession, activityMessageProducer);
            }
            mJmsMessageProducerImpl_send.invoke(activityMessageProducer, dummyJMSMessage, new Integer(1), new Integer(4), new Long(timeToLive));
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.sendDummyMessage(jmsMessageProducer, dummyJMSMessage, timeToLive) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.sendDummyMessage(jmsMessageProducer, dummyJMSMessage, timeToLive) exit");
    }

    public static Object accessQueueOnQueueManager(Object mqQueueManager, String qName, int openOptions) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.accessQueueOnQueueManager(mqQueueManager, qName, openOptions) entry");
        Object queue = null;
        try {
            queue = mqQueueManager.getClass().getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager") ? mMQQueueManager6_accessQueue.invoke(mqQueueManager, qName, new Integer(openOptions)) : mMQQueueManager_accessQueue.invoke(mqQueueManager, qName, new Integer(openOptions));
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.accessQueueOnQueueManager(mqQueueManager, qName, openOptions) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.accessQueueOnQueueManager(mqQueueManager, qName, openOptions) queue " + queue);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.accessQueueOnQueueManager(mqQueueManager, qName, openOptions) exit");
        return queue;
    }

    public static Object createMessageProducer(Object jmsSession, String qName) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.createMessageProducer(jmsSession, qName) entry");
        Object messageProducer = null;
        try {
            Object jmsQueue = mJmsSessionImpl_createQueue.invoke(jmsSession, qName);
            messageProducer = mJmsSessionImpl_createProducer.invoke(jmsSession, jmsQueue);
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.createMessageProducer(jmsSession, qName) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.createMessageProducer(jmsSession, qName) exit");
        return messageProducer;
    }

    public static Object createTemporaryQueue(Object mqObject, String queueName) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.createTemporaryQueue(mqObject, queueName) entry for Queue : " + queueName);
        Object mqQueue = null;
        if (mqObject == null || queueName == null || queueName.trim().length() == 0) {
            return mqQueue;
        }
        Object queueManagerObject = null;
        String mqObjectClassName = mqObject.getClass().getName();
        queueManagerObject = mqObjectClassName.equals("com.ibm.mq.MQQueueManager") || mqObjectClassName.equals("com.ibm.mq.MQSPIQueueManager") || mqObjectClassName.equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager") ? mqObject : MQTransactionTracerUtil.getQueueManager(mqObject);
        if (queueManagerObject != null) {
            Class<?> mqQueueManagerClass = queueManagerObject.getClass();
            try {
                mqQueue = mqQueueManagerClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager") ? mMQQueueManager6_accessQueue.invoke(queueManagerObject, queueName, new Integer(32)) : mMQQueueManager_accessQueue.invoke(queueManagerObject, queueName, new Integer(32));
            }
            catch (Exception e) {
                MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.createTemporaryQueue(mqObject, queueName) ", (Throwable)e);
            }
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.createTemporaryQueue(mqObject, queueName) mqQueue " + mqQueue);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.createTemporaryQueue(mqObject, queueName) exit");
        return mqQueue;
    }

    public static void closeQueue(Object mqQueue) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.closeQueue(mqQueue) entry");
        if (mqQueue != null) {
            try {
                if (mqQueue.getClass().getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueue")) {
                    mMQQueue6_close.invoke(mqQueue, new Object[0]);
                } else {
                    mMQQueue_close.invoke(mqQueue, new Object[0]);
                }
            }
            catch (Exception e) {
                MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.closeQueue(mqQueue) ", (Throwable)e);
            }
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.closeQueue(mqQueue) exit");
    }

    public static void closeMessageProducer(Object messageProducer) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.closeMessageProducer(messageProducer) entry");
        if (messageProducer != null) {
            try {
                mJmsMessageProducerImpl_close.invoke(messageProducer, new Object[0]);
            }
            catch (Exception e) {
                MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.closeMessageProducer(messageProducer) ", (Throwable)e);
            }
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.closeMessageProducer(messageProducer) exit");
    }

    public static void updatePutMessageOptionsContext(Object mqPutMessageOptions) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.updatePutMessageOptionsContext(mqPutMessageOptions) entry");
        try {
            if (mqPutMessageOptions.getClass().getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions")) {
                int options = fMQPutMessageOptions6_options.getInt(mqPutMessageOptions);
                fMQPutMessageOptions6_options.setInt(mqPutMessageOptions, options | 0x400);
            } else {
                int options = fMQPutMessageOptions_options.getInt(mqPutMessageOptions);
                fMQPutMessageOptions_options.setInt(mqPutMessageOptions, options | 0x400);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.updatePutMessageOptionsContext(mqPutMessageOptions) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.updatePutMessageOptionsContext(mqPutMessageOptions) exit");
    }

    public static void updatePutMessageOptions(Object mqPutMessageOptions) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.updatePutMessageOptions(mqPutMessageOptions) entry");
        mqPutMessageOptions.getClass();
        try {
            if (mqPutMessageOptions.getClass().getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions")) {
                int recordFields = fMQPutMessageOptions6_recordFields.getInt(mqPutMessageOptions);
                int options = fMQPutMessageOptions6_options.getInt(mqPutMessageOptions);
                if ((recordFields & 1) == 0 || (recordFields & 2) == 0) {
                    fMQPutMessageOptions6_recordFields.setInt(mqPutMessageOptions, recordFields | 1 | 2);
                    if ((options & 0x40) == 0) {
                        fMQPutMessageOptions6_options.setInt(mqPutMessageOptions, options | 0x40);
                    }
                }
            } else {
                int recordFields = fMQPutMessageOptions_recordFields.getInt(mqPutMessageOptions);
                int options = fMQPutMessageOptions_options.getInt(mqPutMessageOptions);
                if ((recordFields & 1) == 0 || (recordFields & 2) == 0) {
                    fMQPutMessageOptions_recordFields.setInt(mqPutMessageOptions, recordFields | 1 | 2);
                    if ((options & 0x40) == 0) {
                        fMQPutMessageOptions_options.setInt(mqPutMessageOptions, options | 0x40);
                    }
                }
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.updatePutMessageOptions(mqPutMessageOptions) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.updatePutMessageOptions(mqPutMessageOptions) exit");
    }

    public static Object getDistributionListQueueManager(Object mqDistributionList) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListQueueManager(mqDistributionList) entry");
        Object qm = null;
        MQDistributionListVO mqDistributionListVO = (MQDistributionListVO)distributionListObjects.get(mqDistributionList);
        if (mqDistributionListVO != null) {
            qm = mqDistributionListVO.getQueueManager();
        } else {
            mqDistributionListVO = new MQDistributionListVO();
        }
        try {
            if (qm == null) {
                qm = fMQDistributionList_mgr.get(mqDistributionList);
                mqDistributionListVO.setQueueManager(qm);
                distributionListObjects.put(mqDistributionList, mqDistributionListVO);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListQueueManager(mqDistributionList) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListQueueManager(mqDistributionList) qm " + qm);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListQueueManager(mqDistributionList) exit");
        return qm;
    }

    public static String getDistributionListQueueManagerName(Object mqDistributionList) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListQueueManagerName(mqDistributionList) entry");
        String qmName = null;
        MQDistributionListVO mqDistributionListVO = (MQDistributionListVO)distributionListObjects.get(mqDistributionList);
        if (mqDistributionListVO != null) {
            qmName = mqDistributionListVO.getQueueManagerName();
        } else {
            mqDistributionListVO = new MQDistributionListVO();
        }
        try {
            if (qmName == null || qmName.trim().length() == 0) {
                Object mqQueueManager = MQTransactionTracerUtil.getDistributionListQueueManager(mqDistributionList);
                qmName = MQTransactionTracerUtil.getQMName(mqQueueManager);
                mqDistributionListVO.setQueueManagerName(qmName);
                distributionListObjects.put(mqDistributionList, mqDistributionListVO);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListQueueManagerName(mqDistributionList) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListQueueManagerName(mqDistributionList) qmName " + qmName);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListQueueManagerName(mqDistributionList) exit");
        return qmName;
    }

    public static List getDistributionListQueueVOs(Object mqDistributionList) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListQueueVOs(mqDistributionList) entry");
        ArrayList<QueueVO> distributionQueueVOs = new ArrayList<QueueVO>();
        try {
            Object[] items = MQTransactionTracerUtil.getDistributionListItems(mqDistributionList);
            Object distributionListQM = MQTransactionTracerUtil.getDistributionListQueueManager(mqDistributionList);
            String distributionListQMName = MQTransactionTracerUtil.getDistributionListQueueManagerName(mqDistributionList);
            QueueVO queueVO = null;
            if (items != null && items.length > 0) {
                int i = 0;
                while (i < items.length) {
                    queueVO = MQTransactionTracerUtil.getDistributionListItemQueueVO(mqDistributionList, items[i], distributionListQM, distributionListQMName);
                    distributionQueueVOs.add(queueVO);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListQueueVOs(mqDistributionList) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListQueueVOs(mqDistributionList) distributionQueueVOs " + distributionQueueVOs);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListQueueVOs(mqDistributionList) exit");
        return distributionQueueVOs;
    }

    public static Object[] getDistributionListItems(Object mqDistributionList) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListItems(mqDistributionList) entry");
        Object[] items = null;
        try {
            items = (Object[])fMQDistributionList_items.get(mqDistributionList);
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListItems(mqDistributionList) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListItems(mqDistributionList) items " + items);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListItems(mqDistributionList) exit");
        return items;
    }

    public static String getDistributionItemQueueName(Object mqDistributionList, Object mqDistributionListItem) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionItemQueueName(mqDistributionList, mqDistributionListItem) entry");
        String queueName = null;
        try {
            queueName = (String)fMQDistributionListItem_queueName.get(mqDistributionListItem);
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionItemQueueName(mqDistributionList, mqDistributionListItem) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionItemQueueName(mqDistributionList, mqDistributionListItem) queueName " + queueName);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionItemQueueName(mqDistributionList, mqDistributionListItem) exit");
        return queueName;
    }

    public static String getDistributionItemQueueManagerName(Object mqDistributionList, Object mqDistributionListItem) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionItemQueueManagerName(mqDistributionList, mqDistributionListItem) entry");
        String qmName = null;
        try {
            qmName = (String)fMQDistributionListItem_queueManagerName.get(mqDistributionListItem);
            if (qmName == null || qmName.trim().length() == 0) {
                qmName = MQTransactionTracerUtil.getDistributionListQueueManagerName(mqDistributionList);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionItemQueueManagerName(mqDistributionList, mqDistributionListItem) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionItemQueueManagerName(mqDistributionList, mqDistributionListItem) distributionItemQueueManagerName " + qmName);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionItemQueueManagerName(mqDistributionList, mqDistributionListItem) exit");
        return qmName;
    }

    public static List getDistributionListMessageIDs(Object mqDistributionList) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListMessageIDs(mqDistributionList) entry");
        ArrayList<Object> messageIDs = new ArrayList<Object>();
        Object[] items = MQTransactionTracerUtil.getDistributionListItems(mqDistributionList);
        try {
            if (items != null && items.length != 0) {
                Object messageID = null;
                int i = 0;
                while (i < items.length) {
                    messageID = MQTransactionTracerUtil.getDistributionItemMessageID(items[i]);
                    messageIDs.add(messageID);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListMessageIDs(mqDistributionList) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListMessageIDs(mqDistributionList) messageIDs " + messageIDs);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListMessageIDs(mqDistributionList) exit");
        return messageIDs;
    }

    public static Object getDistributionItemMessageID(Object mqDistributionListItem) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionItemMessageID(mqDistributionListItem) entry");
        Object messageID = null;
        try {
            messageID = fMQMessageTracker_messageId.get(mqDistributionListItem);
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionItemMessageID(mqDistributionListItem) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionItemMessageID(mqDistributionListItem) messageID " + messageID);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionItemMessageID(mqDistributionListItem) exit");
        return messageID;
    }

    public static List getDistributionListCorrelationIDs(Object mqDistributionList) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListCorrelationIDs(mqDistributionList) entry");
        ArrayList<Object> correlationIDs = new ArrayList<Object>();
        Object[] items = MQTransactionTracerUtil.getDistributionListItems(mqDistributionList);
        try {
            if (items != null && items.length != 0) {
                Object correlationID = null;
                int i = 0;
                while (i < items.length) {
                    correlationID = MQTransactionTracerUtil.getDistributionItemCorrelationID(items[i]);
                    correlationIDs.add(correlationID);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListCorrelationIDs(mqDistributionList) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListCorrelationIDs(mqDistributionList) correlationIDs " + correlationIDs);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListCorrelationIDs(mqDistributionList) exit");
        return correlationIDs;
    }

    public static Object getDistributionItemCorrelationID(Object mqDistributionListItem) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionItemCorrelationID(mqDistributionListItem) entry");
        Object correlationID = null;
        try {
            correlationID = fMQMessageTracker_correlationId.get(mqDistributionListItem);
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionItemCorrelationID(mqDistributionListItem) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionItemCorrelationID(mqDistributionListItem) correlationID " + correlationID);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionItemCorrelationID(mqDistributionListItem) exit");
        return correlationID;
    }

    public static QueueVO getDistributionListItemQueueVO(Object mqDistributionList, Object mqDistributionListItem, Object distributionListQM, String distributionListQMName) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListItemQueueVO(mqDistributionList, mqDistributionListItem, distributionListQM, distributionListQMName) entry");
        QueueVO distributionItemQueueVO = null;
        try {
            String qName;
            String remoteQMName = MQTransactionTracerUtil.getDistributionItemQueueManagerName(mqDistributionList, mqDistributionListItem);
            if ((remoteQMName == null || remoteQMName.trim().length() == 0 || remoteQMName.trim().equalsIgnoreCase(distributionListQMName)) && (qName = MQTransactionTracerUtil.getDistributionItemQueueName(mqDistributionList, mqDistributionListItem)) != null && qName.trim().length() != 0) {
                distributionItemQueueVO = QueueManagerRepository.getQueueVO(distributionListQM, qName);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListItemQueueVO(mqDistributionList, mqDistributionListItem, distributionListQM, distributionListQMName) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListItemQueueVO(mqDistributionList, mqDistributionListItem, distributionListQM, distributionListQMName) distributionItemQueueVO " + distributionItemQueueVO);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getDistributionListItemQueueVO(mqDistributionList, mqDistributionListItem, distributionListQM, distributionListQMName) exit");
        return distributionItemQueueVO;
    }

    public static void clearAllObjects() {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.clearAllObjects entry");
        try {
            MQTransactionTracerUtil.closeSessionMessageProducers();
            MQTransactionTracerUtil.closeActivityQueues();
            MQTransactionTracerUtil.clearAllDistributionLists();
        }
        catch (Exception ex) {
            MQPPLog.getLogger().debug(kModule, ex.getMessage(), (Throwable)ex);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.clearAllObjects exit");
    }

    private static void clearAllDistributionLists() {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.clearAllDistributionLists entry");
        distributionListObjects.clear();
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.clearAllDistributionLists exit");
    }

    private static void closeActivityQueues() {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.closeActivityQueues entry");
        try {
            Collection activityQueues = qmActivityQueues.values();
            Iterator iter = activityQueues.iterator();
            while (iter.hasNext()) {
                MQTransactionTracerUtil.closeQueue(iter.next());
            }
            qmActivityQueues.clear();
        }
        catch (Exception ex) {
            MQPPLog.getLogger().debug(kModule, ex.getMessage(), (Throwable)ex);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.closeActivityQueues exit");
    }

    private static void closeSessionMessageProducers() {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.closeSessionMessageProducers entry");
        try {
            Collection messageProducers = sessionMessageProducers.values();
            Iterator iter = messageProducers.iterator();
            while (iter.hasNext()) {
                MQTransactionTracerUtil.closeMessageProducer(iter.next());
            }
            sessionMessageProducers.clear();
        }
        catch (Exception ex) {
            MQPPLog.getLogger().debug(kModule, ex.getMessage(), (Throwable)ex);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.closeSessionMessageProducers exit");
    }

    public static boolean shouldSetActivityBit(Object mqObject) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.shouldSetActivityBit(mqObject) entry");
        boolean activityFlag = false;
        Object mqQueueManager = null;
        Object activityQueue = null;
        int maxDepth = 0;
        int currentDepth = 0;
        int inhibitPut = 0;
        try {
            String objectClassName = mqObject.getClass().getName();
            if (objectClassName.equals("com.ibm.mq.MQQueue") || objectClassName.equals("com.ibm.mq.MQSPIQueue") || objectClassName.equals("com.ibm.mq.MQDestination")) {
                mqQueueManager = MQTransactionTracerUtil.getQueueManager(mqObject);
            } else if (objectClassName.equals("com.ibm.mq.MQQueueManager") || objectClassName.equals("com.ibm.mq.MQSPIQueueManager")) {
                mqQueueManager = mqObject;
            } else if (objectClassName.equals("com.ibm.mq.MQDistributionList")) {
                mqQueueManager = MQTransactionTracerUtil.getDistributionListQueueManager(mqObject);
            }
            if (mqQueueManager != null) {
                activityQueue = qmActivityQueues.get(mqQueueManager);
                if (activityQueue == null) {
                    activityQueue = MQTransactionTracerUtil.accessQueueOnQueueManager(mqQueueManager, "SYSTEM.ADMIN.ACTIVITY.QUEUE", 8240);
                    qmActivityQueues.put(mqQueueManager, activityQueue);
                }
                maxDepth = (Integer)mMQQueue_getMaximumDepth.invoke(activityQueue, new Object[0]);
                currentDepth = (Integer)mMQQueue_getCurrentDepth.invoke(activityQueue, new Object[0]);
                inhibitPut = (Integer)mMQQueue_getInhibitPut.invoke(activityQueue, new Object[0]);
                MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.shouldSetActivityBit(mqObject) Activity Queue Current Depth: " + currentDepth + " Maximum Depth: " + maxDepth);
                if ((double)currentDepth < 0.6 * (double)maxDepth && inhibitPut == 0) {
                    activityFlag = true;
                }
            }
        }
        catch (Exception ex) {
            MQPPLog.getLogger().debug(kModule, ex.getMessage(), (Throwable)ex);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.shouldSetActivityBit(mqObject) " + activityFlag);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.shouldSetActivityBit(mqObject) exit");
        return activityFlag;
    }

    public static int getMQReasonCode(Object mqObject) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQReasonCode(mqObject) entry");
        int reasonCode = 0;
        try {
            Class<?> mqObjectClass = mqObject.getClass();
            if (mqObjectClass.getName().equals("com.ibm.mq.MQSPIQueue") || mqObjectClass.getName().equals("com.ibm.mq.MQSPIQueueManager")) {
                mqObjectClass = mqObjectClass.getSuperclass();
            }
            if (mqObjectClass.getSuperclass().getName().equals("com.ibm.mq.MQDestination")) {
                mqObjectClass = mqObjectClass.getSuperclass();
            }
            Field fReason = mqObjectClass.getDeclaredField("reason");
            fReason.setAccessible(true);
            Object reasonPint = fReason.get(mqObject);
            reasonCode = reasonPint.getClass().getName().equals("com.ibm.mq.jmqi.handles.Pint") ? fPint6_x.getInt(reasonPint) : fPint_x.getInt(reasonPint);
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQReasonCode(mqObject) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQReasonCode(mqObject) reasonCode " + reasonCode);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQReasonCode(mqObject) exit");
        return reasonCode;
    }

    public static int getMQReasonCodeFromException(Exception inputException) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQReasonCodeFromException(mqObject) entry");
        int reasonCode = 0;
        try {
            Throwable mqe = null;
            mqe = CLS_MQException.isInstance(inputException) ? inputException : inputException.getCause();
            if (CLS_MQException.isInstance(mqe)) {
                reasonCode = fMQException_reasonCode.getInt(mqe);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQReasonCodeFromException(mqObject) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQReasonCodeFromException(mqObject) reasonCode " + reasonCode);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQReasonCodeFromException(mqObject) exit");
        return reasonCode;
    }

    public static byte[] getBytes(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
        bos.close();
        byte[] data = bos.toByteArray();
        return data;
    }

    public static String dumpHexId(byte[] myId) {
        String msgID = "";
        int i = 0;
        while (i < myId.length) {
            char b = (char)(myId[i] & 0xFF);
            if (b < '\u0010') {
                msgID = String.valueOf(msgID) + "0";
            }
            msgID = String.valueOf(msgID) + Integer.toHexString(b).toUpperCase();
            ++i;
        }
        return msgID;
    }

    public static String getHexId(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i];
            sb.append(Character.forDigit(b >> 4 & 0xF, 16));
            sb.append(Character.forDigit(b & 0xF, 16));
            ++i;
        }
        return new String(sb).toUpperCase();
    }

    public static long convertTimeinMillisToGMT(long putTime) {
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTimeInMillis(putTime - (long)cal1.get(15) - (long)cal1.get(16));
        return cal1.getTimeInMillis();
    }

    public static void addToCorrelation(IAgent agent, String messageID, String correlationID) {
        try {
            if (messageID != null && messageID.trim().length() != 0 && !"000000000000000000000000000000000000000000000000".equals(messageID)) {
                MQPPLog.getLogger().debug(kModule, "Adding messageID " + messageID + " to transaction trace");
                agent.IAgent_getComponentTracer().addExtraParameter("Cor" + messageID, "IScopeMQID");
            }
            if (correlationID != null && correlationID.trim().length() != 0 && !"000000000000000000000000000000000000000000000000".equals(correlationID) && !correlationID.equalsIgnoreCase(messageID)) {
                MQPPLog.getLogger().debug(kModule, "Adding correlationID " + correlationID + " to transaction trace");
                agent.IAgent_getComponentTracer().addExtraParameter("Cor" + correlationID, "IScopeMQID");
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, e.getMessage(), (Throwable)e);
        }
    }

    public static void addToCorrelation(final IAgent agent, final String messageID, final String correlationID, InvocationData invocationData) {
        invocationData.setParameterCallback(new IInvocationDataParameterCallback(){

            public void IInvocationDataParameterCallback_addParameters(InvocationData arg0, Map extraParamsMap) {
                MQTransactionTracerUtil.populateCorrelationID(agent, messageID, correlationID, extraParamsMap);
            }
        });
    }

    public static void populateCorrelationID(IAgent agent, String messageID, String correlationID, Map<String, String> extraParamsMap) {
        try {
            if (messageID != null && messageID.trim().length() != 0 && !"000000000000000000000000000000000000000000000000".equals(messageID)) {
                MQPPLog.getLogger().debug(kModule, "Adding messageID " + messageID + " to transaction trace");
                extraParamsMap.put("Cor" + messageID, "IScopeMQID");
            }
            if (correlationID != null && correlationID.trim().length() != 0 && !"000000000000000000000000000000000000000000000000".equals(correlationID) && !correlationID.equalsIgnoreCase(messageID)) {
                MQPPLog.getLogger().debug(kModule, "Adding correlationID " + correlationID + " to transaction trace");
                extraParamsMap.put("Cor" + correlationID, "IScopeMQID");
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, e.getMessage(), (Throwable)e);
        }
    }

    public static boolean shouldExcludeQueue(String qmName, String queueName) {
        boolean shouldExcludeList = false;
        try {
            Pattern queueRegexPattern;
            if (qmName != null && qmName.trim().length() != 0 && queueName != null && queueName.trim().length() != 0 && (queueRegexPattern = (Pattern)TraceProperties.excludeQMQueuesRegexMap.get(qmName.trim())) != null) {
                Matcher matcher = queueRegexPattern.matcher(queueName.trim());
                shouldExcludeList = matcher.matches();
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(kModule, e.getMessage(), (Throwable)e);
        }
        return shouldExcludeList;
    }

    public static int getMQMessageType(Object mqMessage) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQMessageType(mqMessage) entry");
        int messageType = -1;
        if (mqMessage != null) {
            Class<?> mqMessageClass = mqMessage.getClass();
            if (mqMessageClass.getName().equals("com.ibm.mq.MQMessage") || mqMessageClass.getSuperclass().getName().equals("com.ibm.mq.MQMsg2") || mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMessage") || mqMessageClass.getSuperclass().getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2")) {
                mqMessageClass = mqMessageClass.getSuperclass();
            }
            try {
                if (mqMessageClass.getName().equals("com.ibm.mq.MQMsg2")) {
                    messageType = (Integer)mMQMsg2_getMessageType.invoke(mqMessage, new Object[0]);
                } else if (mqMessageClass.getName().equals("com.ibm.mq.MQMD")) {
                    messageType = (Integer)fMQMD_messageType.get(mqMessage);
                } else if (mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2")) {
                    messageType = (Integer)mMQMsg26_getMessageType.invoke(mqMessage, new Object[0]);
                } else if (mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMD")) {
                    messageType = (Integer)fMQMD6_messageType.get(mqMessage);
                }
            }
            catch (Exception e) {
                MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQMessageType(mqMessage) ", (Throwable)e);
            }
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQMessageType(mqMessage) " + messageType);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQMessageType(mqMessage) exit");
        return messageType;
    }

    public static int getMQMessageFeedback(Object mqMessage) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQMessageFeedback(mqMessage) entry");
        int feedback = 0;
        if (mqMessage != null) {
            Class<?> mqMessageClass = mqMessage.getClass();
            if (mqMessageClass.getName().equals("com.ibm.mq.MQMessage") || mqMessageClass.getSuperclass().getName().equals("com.ibm.mq.MQMsg2") || mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMessage") || mqMessageClass.getSuperclass().getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2")) {
                mqMessageClass = mqMessageClass.getSuperclass();
            }
            try {
                if (mqMessageClass.getName().equals("com.ibm.mq.MQMsg2")) {
                    feedback = (Integer)mMQMsg2_getFeedback.invoke(mqMessage, new Object[0]);
                } else if (mqMessageClass.getName().equals("com.ibm.mq.MQMD")) {
                    feedback = (Integer)fMQMD_feedback.get(mqMessage);
                } else if (mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2")) {
                    feedback = (Integer)mMQMsg26_getFeedback.invoke(mqMessage, new Object[0]);
                } else if (mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMD")) {
                    feedback = (Integer)fMQMD6_feedback.get(mqMessage);
                }
            }
            catch (Exception e) {
                MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQMessageFeedback(mqMessage) ", (Throwable)e);
            }
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQMessageFeedback(mqMessage) " + feedback);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getMQMessageFeedback(mqMessage) exit");
        return feedback;
    }

    public static void setMQMessageFeedback(Object mqMessage, int newFeedback) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setMQMessageFeedback(mqMessage,newFeedback) entry");
        if (mqMessage != null) {
            Class<?> mqMessageClass = mqMessage.getClass();
            if (mqMessageClass.getName().equals("com.ibm.mq.MQMessage") || mqMessageClass.getSuperclass().getName().equals("com.ibm.mq.MQMsg2") || mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMessage") || mqMessageClass.getSuperclass().getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2")) {
                mqMessageClass = mqMessageClass.getSuperclass();
            }
            try {
                if (mqMessageClass.getName().equals("com.ibm.mq.MQMsg2")) {
                    mMQMsg2_setFeedback.invoke(mqMessage, new Integer(newFeedback));
                } else if (mqMessageClass.getName().equals("com.ibm.mq.MQMD")) {
                    fMQMD_feedback.set(mqMessage, new Integer(newFeedback));
                } else if (mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2")) {
                    mMQMsg26_setFeedback.invoke(mqMessage, new Integer(newFeedback));
                } else if (mqMessageClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQMD")) {
                    fMQMD6_feedback.set(mqMessage, new Integer(newFeedback));
                }
            }
            catch (Exception e) {
                MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setMQMessageFeedback(mqMessage,newFeedback) ", (Throwable)e);
            }
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setMQMessageFeedback(mqMessage,newFeedback) exit");
    }

    public static int getJMSMessageIntProperty(Object jmsMessage, String propertyName) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSMessageIntProperty(jmsMessage,propertyName) entry");
        int propertyValue = 0;
        Integer propertyInteger = null;
        if (jmsMessage != null && propertyName != null && propertyName.length() != 0) {
            try {
                Class<?> jmsMessageClass = jmsMessage.getClass();
                String jmsMessageClassName = jmsMessageClass.getName();
                String jmsMessageSuperClassName = jmsMessageClass.getSuperclass().getName();
                String jmsMessageSuper2ClassName = jmsMessageClass.getSuperclass().getSuperclass().getName();
                if (jmsMessageClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuperClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuper2ClassName.equals("com.ibm.jms.JMSMessage")) {
                    try {
                        propertyInteger = (Integer)mJMSMessage_getIntProperty.invoke(jmsMessage, propertyName);
                    }
                    catch (Exception exception) {}
                } else if (jmsMessageClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuperClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuper2ClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl")) {
                    try {
                        propertyInteger = (Integer)mJmsMessageImpl_getIntProperty.invoke(jmsMessage, propertyName);
                    }
                    catch (Exception exception) {}
                } else {
                    Method mMessage_getIntProperty = jmsMessageClass.getMethod("getIntProperty", String.class);
                    try {
                        propertyInteger = (Integer)mMessage_getIntProperty.invoke(jmsMessage, propertyName);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSMessageIntProperty(jmsMessage,propertyName) ", (Throwable)e);
            }
        }
        if (propertyInteger != null) {
            propertyValue = propertyInteger;
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSMessageIntProperty(jmsMessage,propertyName) " + propertyName + "=" + propertyValue);
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getJMSMessageIntProperty(jmsMessage,propertyName) exit");
        return propertyValue;
    }

    public static void setJMSMessageIntProperty(Object jmsMessage, String propertyName, int propertyValue) {
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setJMSMessageFeedback(jmsMessage,propertyName,propertyValue) entry");
        if (jmsMessage != null && propertyName != null && propertyName.length() != 0) {
            try {
                Class<?> jmsMessageClass = jmsMessage.getClass();
                String jmsMessageClassName = jmsMessageClass.getName();
                String jmsMessageSuperClassName = jmsMessageClass.getSuperclass().getName();
                String jmsMessageSuper2ClassName = jmsMessageClass.getSuperclass().getSuperclass().getName();
                if (jmsMessageClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuperClassName.equals("com.ibm.jms.JMSMessage") || jmsMessageSuper2ClassName.equals("com.ibm.jms.JMSMessage")) {
                    mJMSMessage_setIntProperty.invoke(jmsMessage, propertyName, new Integer(propertyValue));
                } else if (jmsMessageClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuperClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl") || jmsMessageSuper2ClassName.equals("com.ibm.msg.client.jms.internal.JmsMessageImpl")) {
                    mJmsMessageImpl_setIntProperty.invoke(jmsMessage, propertyName, new Integer(propertyValue));
                } else {
                    Method mMessage_setIntProperty = jmsMessageClass.getMethod("setIntProperty", String.class, Integer.TYPE);
                    mMessage_setIntProperty.invoke(jmsMessage, propertyName, new Integer(propertyValue));
                }
            }
            catch (Exception e) {
                MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setJMSMessageFeedback(jmsMessage,propertyName,propertyValue) ", (Throwable)e);
            }
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.setJMSMessageFeedback(jmsMessage,propertyName,propertyValue) exit");
    }

    public static boolean isGMOSetToForcePropsInRFH2(Object mqGetMessageOptions) {
        boolean isGMOSetToForcePropsInRFH2 = false;
        int gmoOptions = 0;
        if (mqGetMessageOptions != null) {
            try {
                gmoOptions = mqGetMessageOptions.getClass().getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions") ? fMQGetMessageOptions6_options.getInt(mqGetMessageOptions) : fMQGetMessageOptions_options.getInt(mqGetMessageOptions);
                if ((gmoOptions & 0x2000000) == 0x2000000) {
                    isGMOSetToForcePropsInRFH2 = true;
                }
            }
            catch (Exception e) {
                MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.isGMOSetToForcePropsInRFH2(mqGetMessageOptions) ", (Throwable)e);
            }
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.isGMOSetToForcePropsInRFH2(mqGetMessageOptions) isGMOSetToForcePropsInRFH2 " + isGMOSetToForcePropsInRFH2);
        return isGMOSetToForcePropsInRFH2;
    }

    public static String getRFH2MessageCorrelationProperty(Object rfh2Message) {
        String soapCorrelationID;
        block15: {
            soapCorrelationID = null;
            if (rfh2Message != null && rfh2Message.getClass().getName().equals("com.ibm.mq.soap.transport.jms.RFH2Message")) {
                try {
                    try {
                        int startPos;
                        if (mRFH2Message_get == null) {
                            mRFH2Message_get = rfh2Message.getClass().getMethod("get", new Class[0]);
                        }
                        if (fRFH2Message_usrBuff == null) {
                            fRFH2Message_usrBuff = rfh2Message.getClass().getDeclaredField("usrBuff");
                            fRFH2Message_usrBuff.setAccessible(true);
                        }
                        mRFH2Message_get.invoke(rfh2Message, new Object[0]);
                        Object rfh2UserProperties = fRFH2Message_usrBuff.get(rfh2Message);
                        if (rfh2UserProperties != null && (startPos = rfh2UserProperties.toString().indexOf("<CorIDForSOAPInvocation")) != -1) {
                            int startPos2 = rfh2UserProperties.toString().indexOf(">", startPos);
                            int lastPos = rfh2UserProperties.toString().indexOf("</CorIDForSOAPInvocation>");
                            soapCorrelationID = rfh2UserProperties.toString().substring(startPos2 + 1, lastPos);
                        }
                    }
                    catch (Exception e) {
                        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getRFH2MessageCorrelationProperty(rfh2Message) ", (Throwable)e);
                        try {
                            mMQMessage_setDataOffset.invoke(rfh2Message, new Integer(0));
                        }
                        catch (Exception e2) {
                            MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getRFH2MessageCorrelationProperty(rfh2Message) ", (Throwable)e2);
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        mMQMessage_setDataOffset.invoke(rfh2Message, new Integer(0));
                    }
                    catch (Exception e) {
                        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getRFH2MessageCorrelationProperty(rfh2Message) ", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    mMQMessage_setDataOffset.invoke(rfh2Message, new Integer(0));
                }
                catch (Exception e) {
                    MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getRFH2MessageCorrelationProperty(rfh2Message) ", (Throwable)e);
                }
            }
        }
        MQPPLog.getLogger().debug(kModule, "MQTransactionTracerUtil.getRFH2MessageCorrelationProperty(rfh2Message) soapCorrelationID " + soapCorrelationID);
        return soapCorrelationID;
    }

    public static void addCustomMQCorrelationParameter(Object mqMessage, InvocationData invocationData, String queueName) {
        if (mqMessage != null) {
            Object existingProperty = null;
            Map messageProperties = null;
            try {
                existingProperty = ReflectionUtils.invokeMethodOnObject((Object)mqMessage, (String)"getStringProperty", (Class[])new Class[]{String.class}, (Object[])new Object[]{MQ_CORRELATION_PROPERTY_NAME});
                new CorrelationId((String)existingProperty, true);
            }
            catch (InvocationTargetException e) {
                MQPPLog.getLogger().error(kModule, "getStringProperty() failed for message object (" + mqMessage + ") parameter to method: " + invocationData.getProbeInformation().getProbeIdentification().getProbeMethodName(), (Throwable)e);
            }
            catch (Throwable t) {
                MQPPLog.getLogger().error(kModule, "Failed reflection call for getStringProperty() on message object: " + mqMessage, t);
            }
            if (existingProperty == null) {
                String correlationID = (String)(existingProperty != null ? existingProperty : MQTransactionTracerUtil.getOutgoingCorrelationID(invocationData));
                try {
                    try {
                        messageProperties = MQTransactionTracerUtil.getMessageProperties(mqMessage);
                        MQTransactionTracerUtil.clearProperties(mqMessage);
                        MQPPLog.getLogger().debug(kModule, "Cleared the existing message properties on the outgoing message object");
                        ReflectionUtils.invokeMethodOnObject((Object)mqMessage, (String)"setStringProperty", (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{MQ_CORRELATION_PROPERTY_NAME, correlationID});
                        if (queueName != null || queueName.length() != 0) {
                            ReflectionUtils.invokeMethodOnObject((Object)mqMessage, (String)"setStringProperty", (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{MQ_DESTINATION_PROPERTY_NAME, queueName});
                        }
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getCause();
                        MQPPLog.getLogger().error(kModule, "setStringProperty() failed for message object (" + mqMessage + ") parameter to method: " + invocationData.getProbeInformation().getProbeIdentification().getProbeMethodName(), t);
                        MQTransactionTracerUtil.restoreProperties(mqMessage, messageProperties);
                        MQPPLog.getLogger().debug(kModule, "Restored the original message properties on the outgoing message object");
                    }
                    catch (Throwable t) {
                        MQPPLog.getLogger().error(kModule, "Failed reflection call for setStringProperty() on message object: " + mqMessage, t);
                        MQTransactionTracerUtil.restoreProperties(mqMessage, messageProperties);
                        MQPPLog.getLogger().debug(kModule, "Restored the original message properties on the outgoing message object");
                    }
                }
                finally {
                    MQTransactionTracerUtil.restoreProperties(mqMessage, messageProperties);
                    MQPPLog.getLogger().debug(kModule, "Restored the original message properties on the outgoing message object");
                }
            }
        }
    }

    private static final String getOutgoingCorrelationID(InvocationData invocationData) {
        String iD = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
        return iD;
    }

    public static Map getMessageProperties(Object jmsMessage) {
        HashMap properties = new HashMap();
        try {
            Enumeration propertyNames = (Enumeration)ReflectionUtils.invokeMethodOnObject((Object)jmsMessage, (String)"getPropertyNames", (Class[])new Class[0], (Object[])new Object[0]);
            while (propertyNames.hasMoreElements()) {
                Object propertyName = propertyNames.nextElement();
                Object propertyValueAsObject = ReflectionUtils.invokeMethodOnObject((Object)jmsMessage, (String)"getObjectProperty", (Class[])new Class[]{String.class}, (Object[])new Object[]{propertyName});
                properties.put(propertyName, propertyValueAsObject);
            }
        }
        catch (Exception exception) {
            MQPPLog.getLogger().debug(kModule, "Could not get JMS message properties using the JMS API: getObjectProperty() ");
        }
        return properties;
    }

    public static void clearProperties(Object jmsMessage) {
        try {
            ReflectionUtils.invokeMethodOnObject((Object)jmsMessage, (String)"clearProperties", (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (Exception exception) {
            MQPPLog.getLogger().debug(kModule, "Could not clear message properties using the JMS API: clearProperties() ");
        }
    }

    public static void restoreProperties(Object jmsMessage, Map properties) {
        for (Object key : properties.keySet()) {
            Object value = properties.get(key);
            Class[] paramTypes = new Class[]{String.class, Object.class};
            Object[] paramvalues = new Object[]{(String)key, value};
            try {
                ReflectionUtils.invokeMethodOnObject((Object)jmsMessage, (String)"setObjectProperty", (Class[])paramTypes, (Object[])paramvalues);
            }
            catch (Exception exception) {
                MQPPLog.getLogger().debug(kModule, "Could not restore message properties on the JMS message object: ");
            }
        }
    }

    public static String getDestinationQueueName(Object jmsMessageObject) {
        String destinationQueueName = null;
        try {
            destinationQueueName = (String)ReflectionUtils.invokeMethodOnObject((Object)jmsMessageObject, (String)"getStringProperty", (Class[])new Class[]{String.class}, (Object[])new Object[]{MQ_DESTINATION_PROPERTY_NAME});
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {}
        return destinationQueueName;
    }
}

