/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.AutoTracingClampProperty;
import com.wily.introscope.agent.trace.intelligent.AutoTracingCounterResetter;
import com.wily.introscope.agent.trace.intelligent.AutoTracingEnabledProperty;
import com.wily.introscope.agent.trace.intelligent.AutotraceCrossprocessCacheElementsLimit;
import com.wily.introscope.agent.trace.intelligent.AutotraceCrossprocessDownstreamGuidClamp;
import com.wily.introscope.agent.trace.intelligent.AutotraceCrossprocessUpstreamTimeout;
import com.wily.introscope.agent.trace.intelligent.AutotraceCrossprocessWorkerFrequency;
import com.wily.introscope.agent.trace.intelligent.DeepTraceProperties;
import com.wily.introscope.agent.trace.intelligent.DiscoveryTracingEnabledProperty;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import com.wily.util.properties.hot.LongConfigurationProperty;
import java.util.ArrayList;
import java.util.List;

public class DeepTraceConfigurations {
    private static final Module kModule = Logger.getModule();
    public static volatile boolean fErrorReportingEnabled = false;
    public static volatile boolean fDeepStallSnapshotEnabled = false;
    public static final boolean kDeepTracingEnabledDefaultValue = true;
    public static volatile boolean fDeepTracingEnabled = true;
    public static volatile int fMaxExceptionsCollected = 25;
    public static volatile long fComponentTimeThresholdForAutoTraceTrigger = 5L;
    private static final List<IDeepConfigurationListener> kDeepTracingPropertyListeners = new ArrayList<IDeepConfigurationListener>(1);
    static int fVisibilityGapAbsoluteThreshold = 10;
    static int fVisibilityGapPercentThreshold = 3;
    static int fVisibilityGapMaxMethodsReported = 50;

    public static void init(IAgent agent) {
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        BooleanConfigurationProperty deepTracingEnabled = new BooleanConfigurationProperty("introscope.agent.deep.trace.enabled", true, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer()){

            @Override
            public void set(Object newValue) {
                fDeepTracingEnabled = (Boolean)newValue;
                for (IDeepConfigurationListener listener : kDeepTracingPropertyListeners) {
                    listener.onChange(newValue);
                }
            }
        };
        cm.add(deepTracingEnabled, true);
        BooleanConfigurationProperty bcp = new BooleanConfigurationProperty("introscope.agent.deep.errorsnapshot.enable", true, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer()){

            @Override
            public void set(Object newValue) {
                fErrorReportingEnabled = (Boolean)newValue;
            }
        };
        cm.add(bcp, true);
        IntegerConfigurationProperty icp = new IntegerConfigurationProperty("introscope.agent.deep.errors.max.collected", 25, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer()){

            @Override
            public void set(Object newValue) {
                fMaxExceptionsCollected = (Integer)newValue;
            }
        };
        cm.add(icp, true);
        BooleanConfigurationProperty deepStallSnapshotEnabled = new BooleanConfigurationProperty(DeepTraceProperties.kDeepStallSnapshotProperty, true, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer()){

            @Override
            public void set(Object newValue) {
                fDeepStallSnapshotEnabled = (Boolean)newValue;
            }
        };
        cm.add(deepStallSnapshotEnabled, true);
        AutoTracingClampProperty clampProperty = new AutoTracingClampProperty("introscope.agent.deep.automatic.trace.clamp", 10, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        AutoTracingEnabledProperty autoTraceEnabledProperty = new AutoTracingEnabledProperty("introscope.agent.deep.automatic.trace.enabled", true, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        DiscoveryTracingEnabledProperty discoveryTraceEnabledProperty = new DiscoveryTracingEnabledProperty("introscope.agent.auto.discovery.trace.enabled", true, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        cm.add(clampProperty);
        cm.add(autoTraceEnabledProperty);
        cm.add(discoveryTraceEnabledProperty);
        IntervalHeartbeat heartBeat = agent.IAgent_getConfigHeartbeat();
        AutoTracingCounterResetter target = new AutoTracingCounterResetter();
        heartBeat.addBehavior((ITimestampedRunnable)target, "AutoTracing counter resetter", true, AutoTracingCounterResetter.kDelayInMillis, false);
        AutotraceCrossprocessWorkerFrequency workerFreq = new AutotraceCrossprocessWorkerFrequency("introscope.agent.deep.automatic.trace.crossprocess.worker.frequency", 3750, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        cm.add(workerFreq);
        AutotraceCrossprocessUpstreamTimeout upstreamTimeout = new AutotraceCrossprocessUpstreamTimeout("introscope.agent.deep.automatic.trace.crossprocess.upstream.timeout", 300000, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        cm.add(upstreamTimeout);
        AutotraceCrossprocessDownstreamGuidClamp downGuidClamp = new AutotraceCrossprocessDownstreamGuidClamp("introcosope.agent.deep.automatic.trace.crossprocess.downstream.guid.clamp", 100, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        cm.add(downGuidClamp);
        AutotraceCrossprocessCacheElementsLimit cacheElementsLimit = new AutotraceCrossprocessCacheElementsLimit("introscope.agent.deep.automatic.trace.crossprocess.cache.elements.limit", 250000, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        cm.add(cacheElementsLimit);
        LongConfigurationProperty lcp = new LongConfigurationProperty("introscope.agent.deep.automatic.trace.component.thresholdseconds", 5L, "Component time threshold for triggering automatic trace", "seconds", false, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer()){

            @Override
            public boolean validate(Object value) {
                return (Long)value >= 0L;
            }

            @Override
            public void set(Object newValue) {
                fComponentTimeThresholdForAutoTraceTrigger = (Long)newValue;
            }
        };
        cm.add(lcp, true);
        VisibililityGapAbsoluteThresholdProperty vgtp = new VisibililityGapAbsoluteThresholdProperty(agent);
        cm.add(vgtp, true);
        VisibililityGapPercentThresholdProperty vgpp = new VisibililityGapPercentThresholdProperty(agent);
        cm.add(vgpp);
    }

    public static void registerDeepTracingPropertyListener(IDeepConfigurationListener listener) {
        kDeepTracingPropertyListeners.add(listener);
    }

    public static boolean getDeepTracingStatus() {
        return fDeepTracingEnabled;
    }

    public static interface IDeepConfigurationListener {
        public void onChange(Object var1);
    }

    private static final class VisibililityGapAbsoluteThresholdProperty
    extends IntegerConfigurationProperty {
        volatile int value;

        VisibililityGapAbsoluteThresholdProperty(IAgent agent) {
            super("introscope.agent.deep.trace.visibility.absolute.threshold", 10, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fVisibilityGapAbsoluteThreshold = this.value = ((Integer)newValue).intValue();
        }
    }

    private static final class VisibililityGapPercentThresholdProperty
    extends IntegerConfigurationProperty {
        volatile int value;

        VisibililityGapPercentThresholdProperty(IAgent agent) {
            super("introscope.agent.deep.trace.visibility.percent.threshold", 3, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fVisibilityGapPercentThreshold = this.value = ((Integer)newValue).intValue();
        }
    }
}

