/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extension;

import com.wily.introscope.agent.AgentAdapter;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.DuplicateDynamicClassException;
import com.wily.introscope.agent.extension.InvalidDynamicClassException;
import com.wily.introscope.agent.extension.OptionalExtensionsManager;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.util.HashMap;
import java.util.Map;

public abstract class DynamicClassLookup {
    private final Lock fLock = new Lock();
    private final IAgent fAgent;
    private final Class fExpectedType;
    private final Class[] fConstructorParameterTypes;
    private final Map fDynamicClasses;

    public DynamicClassLookup(IAgent agent, Class expectedType, Class[] constructorParameterTypes) {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        this.fAgent = agent;
        this.fExpectedType = expectedType;
        this.fConstructorParameterTypes = constructorParameterTypes;
        this.fDynamicClasses = new HashMap();
    }

    private final Lock getLock() {
        return this.fLock;
    }

    protected final IAgent getAgent() {
        return this.fAgent;
    }

    protected final Class getExpectedType() {
        return this.fExpectedType;
    }

    protected final Class[] getConstructorParameterTypes() {
        return this.fConstructorParameterTypes;
    }

    protected final IModuleFeedbackChannel getModuleFeedback() {
        return this.getAgent().IAgent_getModuleFeedback();
    }

    protected final IStringLocalizer getStringLocalizer() {
        return this.getAgent().IAgent_getStringLocalizer();
    }

    public final void register(IPlugin plugin, final String dynamicName, Class dynamicClass, IStringLocalizer dynamicLocalizer) throws DuplicateDynamicClassException, InvalidDynamicClassException {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        if (!this.getExpectedType().isAssignableFrom(dynamicClass)) {
            OptionalExtensionsManager oem = this.fAgent.IAgent_getExtensionAdministrator().getOptionalExtensionManager();
            if (oem != null) {
                oem.addExtensionWithError(plugin);
            }
            throw new InvalidDynamicClassException("Class is not assignable to the expected type", (ILocalizableMessage)new FormattedLocalizableMessage("Agent_Extension_Dynamic_Class_Wrong_Type_Error", dynamicName));
        }
        try {
            dynamicClass.getConstructor(this.getConstructorParameterTypes());
        }
        catch (NoSuchMethodException nsme) {
            OptionalExtensionsManager oem = this.fAgent.IAgent_getExtensionAdministrator().getOptionalExtensionManager();
            if (oem != null) {
                oem.addExtensionWithError(plugin);
            }
            throw new InvalidDynamicClassException(nsme.getMessage(), (ILocalizableMessage)new FormattedLocalizableMessage("Agent_Extension_Dynamic_Class_Invalid_Constructor_Error", dynamicName));
        }
        catch (SecurityException se) {
            OptionalExtensionsManager oem = this.fAgent.IAgent_getExtensionAdministrator().getOptionalExtensionManager();
            if (oem != null) {
                oem.addExtensionWithError(plugin);
            }
            throw new InvalidDynamicClassException(se.getMessage(), (ILocalizableMessage)new FormattedLocalizableMessage("Agent_Extension_Dynamic_Class_Invalid_Constructor_Error", dynamicName));
        }
        try {
            this.addDynamicClassEntry(dynamicName, dynamicClass, dynamicLocalizer);
        }
        catch (DuplicateDynamicClassException e) {
            OptionalExtensionsManager oem = this.fAgent.IAgent_getExtensionAdministrator().getOptionalExtensionManager();
            if (oem != null) {
                oem.addExtensionWithError(plugin);
            }
            throw e;
        }
        if (plugin != null) {
            plugin.IPlugin_setCallback(new IPlugin.IPluginCallback(){

                @Override
                public void onUnload(IPlugin p) {
                    DynamicClassLookup.this.removeDynamicClassEntry(dynamicName);
                }

                @Override
                public void onLoad(IPlugin p) {
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addDynamicClassEntry(String dynamicName, Class dynamicClass, IStringLocalizer dynamicLocalizer) throws DuplicateDynamicClassException {
        Lock lock = this.getLock();
        synchronized (lock) {
            if (this.fDynamicClasses.containsKey(dynamicName)) {
                throw new DuplicateDynamicClassException("Attempting to register an dynamic class that is already registered", (ILocalizableMessage)new FormattedLocalizableMessage("Agent_Extension_Dynamic_Class_Duplicate_Registration_Error", dynamicName));
            }
            this.fDynamicClasses.put(dynamicName, new DynamicClassEntry(dynamicClass, AgentAdapter.createAdapter(this.getAgent(), dynamicLocalizer)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeDynamicClassEntry(String dynamicName) {
        Lock lock = this.getLock();
        synchronized (lock) {
            this.fDynamicClasses.remove(dynamicName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final DynamicClassEntry loadDynamicClassEntry(String dynamicName) throws Exception {
        Lock lock = this.getLock();
        synchronized (lock) {
            DynamicClassEntry entry = (DynamicClassEntry)this.fDynamicClasses.get(dynamicName);
            if (entry == null) {
                entry = new DynamicClassEntry(Class.forName(dynamicName), this.getAgent());
            }
            return entry;
        }
    }

    protected void addAllExtensions(DynamicClassLookup other) {
        this.fDynamicClasses.putAll(other.fDynamicClasses);
    }

    protected static final class DynamicClassEntry {
        private final Class fDynamicClass;
        private final IAgent fDynamicAgent;

        public DynamicClassEntry(Class dynamicClass, IAgent dynamicAgent) {
            this.fDynamicClass = dynamicClass;
            this.fDynamicAgent = dynamicAgent;
        }

        public Class getDynamicClass() {
            return this.fDynamicClass;
        }

        public IAgent getDynamicAgent() {
            return this.fDynamicAgent;
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

