/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.feature;

import com.wily.introscope.agent.feature.StallFeatureBase;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IIntegerFluctuatingCounterDataAccumulatorWrapper;
import com.wily.introscope.agent.trace.cas.INotAnOldModeStallSubscriber;
import com.wily.introscope.agent.trace.cas.IOldModeStallSubscriber;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.IStallSubscriber;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.StackRecursionHelper;
import com.wily.introscope.agent.trace.cas.TransactionTransitionException;
import com.wily.introscope.agent.trace.cas.UpdaterFactory;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.util.Set;

final class StallCheckBehaviorCorrect
implements ITimestampedRunnable {
    StallCheckBehaviorCorrect() {
    }

    /*
     * Exception decompiling
     */
    @Override
    public void ITimestampedRunnable_execute(long nowInMillis) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isComponentStalled(IStackElement currentInvocationData, long stallStart, WilyTransactionStructure structure) {
        return StallFeatureBase.isComponentStalled(currentInvocationData, stallStart);
    }

    private static void incrementSelfRepositories(Set vetoedRepositories, IStackElement currentInvocationData, long nowInMillis) {
        if (!(currentInvocationData instanceof INotAnOldModeStallSubscriber)) {
            if (currentInvocationData instanceof IOldModeStallSubscriber) {
                IOldModeStallSubscriber oldSubscriber = (IOldModeStallSubscriber)((Object)currentInvocationData);
                StallCheckBehaviorCorrect.updateStallRepository(vetoedRepositories, currentInvocationData, nowInMillis, oldSubscriber, false);
            } else {
                int j = 0;
                while (j < currentInvocationData.getStartCursorsCount()) {
                    IStallSubscriber stallSub;
                    ITransactionElement wte = currentInvocationData.getStartCursorAt(j);
                    if (wte != null && (stallSub = wte.getStallSubscriber()) != null) {
                        StallCheckBehaviorCorrect.updateStallRepository(vetoedRepositories, currentInvocationData, nowInMillis, stallSub, false);
                    }
                    ++j;
                }
            }
            currentInvocationData.setStalled();
        }
    }

    private static IStackElement findStalledParentIfAny(IStackElement parentInvocationData, long nowInMillis, long stallStart, WilyTransactionStructure structure) {
        int stackRecursionCounter = 0;
        for (IStackElement pivot = parentInvocationData; pivot != null; pivot = pivot.getParent()) {
            if (!StallCheckBehaviorCorrect.isComponentStalled(pivot, stallStart, structure)) continue;
            return parentInvocationData;
        }
        return null;
    }

    private static void incrementUpStreamRepositoriesIfSubscribed(Set vetoedRepositories, IStackElement currentInvocationData, long nowInMillis) {
        IStackElement pivot = currentInvocationData.getParent();
        int stackRecursionCounter = 0;
        while (pivot != null) {
            if (StallFeatureBase.hasAlreadyReported(pivot)) {
                pivot = pivot.getParent();
                if (stackRecursionCounter++ <= StackRecursionHelper.kMaxRecursive) continue;
                throw new TransactionTransitionException("Exceeded depth of stack, most likely because the stack is corrupted.");
            }
            if (!(pivot instanceof INotAnOldModeStallSubscriber)) {
                if (pivot instanceof IOldModeStallSubscriber) {
                    IOldModeStallSubscriber oldSubscriber = (IOldModeStallSubscriber)((Object)pivot);
                    StallCheckBehaviorCorrect.updateStallRepository(vetoedRepositories, pivot, nowInMillis, oldSubscriber, true);
                } else if (pivot instanceof InvocationData) {
                    int j = 0;
                    while (j < pivot.getStartCursorsCount()) {
                        IStallSubscriber stallSub;
                        ITransactionElement wte = pivot.getStartCursorAt(j);
                        if (wte != null && (stallSub = wte.getStallSubscriber()) != null && stallSub.subscribeToDownstreamStalls()) {
                            StallCheckBehaviorCorrect.updateStallRepository(vetoedRepositories, pivot, nowInMillis, stallSub, true);
                        }
                        ++j;
                    }
                }
            }
            pivot = pivot.getParent();
            if (stackRecursionCounter++ <= StackRecursionHelper.kMaxRecursive) continue;
            throw new TransactionTransitionException("Exceeded depth of stack, most likely because the stack is corrupted.");
        }
    }

    private static void updateStallRepository(Set vetoedRepositories, IStackElement invocationData, long nowInMillis, IOldModeStallSubscriber stallSub, boolean isSubscriber) {
        IIntegerFluctuatingCounterDataAccumulatorWrapper sds = stallSub.getSubscriptionStallAccumulator(!isSubscriber);
        if (sds != null) {
            if (!vetoedRepositories.contains(sds)) {
                sds.getAccumulator().IIntegerFluctuatingCounterDataAccumulator_increment(sds.getSnapshot());
                vetoedRepositories.add(sds);
                StallFeatureBase.addReportingInvocationData(invocationData, sds);
                invocationData.setStalled();
            }
        } else {
            WilyTransactionStructure.getInstance().getAgent().IAgent_getModuleFeedback().debug("startsub " + stallSub.toString() + " does not have a local stall repository");
        }
    }

    private static void updateStallRepository(Set vetoedRepositories, IStackElement invocationData, long nowInMillis, IStallSubscriber stallSub, boolean isSubscriber) {
        IRepository sds = stallSub.getLocalStallRepository();
        if (sds != null && !vetoedRepositories.contains(sds)) {
            int hashcode = invocationData.hashCode();
            sds.update(UpdaterFactory.getIncreasingUpdater(), 0L, nowInMillis, hashcode);
            vetoedRepositories.add(sds);
            StallFeatureBase.addReportingInvocationData(invocationData, sds);
            invocationData.setStalled();
        }
    }

    private static boolean shouldAbortTransaction(IStackElement data, long nowInMillis) {
        long th = StallFeatureBase.sTxnAbortThreshold.get();
        return th > 0L && data.getWallClockStartTime() < nowInMillis - th;
    }

    private void abortTransaction(IStackElement data, long nowInMillis) {
        long timeTaken = nowInMillis - data.getWallClockStartTime();
        WilyTransactionStructure.getInstance().abortTransaction(new TransactionTransitionException(String.format("Transaction took %d ms which is more than threshold %d ms set for aborting transaction", timeTaken, StallFeatureBase.sTxnAbortThreshold.get())), data);
    }
}

