/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.hc2.ImmutableTransactionContext;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicReference;

public class InjectedFieldCorrelationTracer
extends ASingleInstanceTracerFactory {
    public static final String injectedFieldName = "__Wily_txnContext";
    private IModuleFeedbackChannel feedback;
    private static final Module module = new Module("InjectedFieldCorrelationTracer");

    public InjectedFieldCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.feedback = agent.IAgent_getModuleFeedback();
    }

    protected ImmutableTransactionContext createContext(InvocationData data, Object invocationObject) {
        ImmutableTransactionContext context = new ImmutableTransactionContext(data.getWallClockStartTime(), new CorrelationId().getOutgoingCorrelationIdStrippedForHeader());
        if (this.feedback.isDebugEnabled(module)) {
            this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " created injected context in method " + invocationObject.getClass().getName() + "." + data.getProbeInformation().getProbeIdentification().getProbeMethodName() + "() " + context.getCorID().substring(0, 40));
        }
        return context;
    }

    protected void processContext(InvocationData data, Object invocationObject, ImmutableTransactionContext context) {
        if (this.feedback.isDebugEnabled(module)) {
            this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " found injected context in method " + invocationObject.getClass().getName() + "." + data.getProbeInformation().getProbeIdentification().getProbeMethodName() + "() " + context.getCorID().substring(0, 40));
        }
        new CorrelationId(context.getCorID());
    }

    private void processInjectedField(InvocationData data, Object invocationObject) {
        Field contextField = null;
        try {
            contextField = invocationObject.getClass().getDeclaredField(injectedFieldName);
        }
        catch (NoSuchFieldException e) {
            this.feedback.debug(module, "Couldn't find injected field __Wily_txnContext", e);
        }
        catch (SecurityException e) {
            this.feedback.debug(module, "Couldn't access injected field __Wily_txnContext", e);
        }
        if (contextField != null) {
            Object context;
            contextField.setAccessible(true);
            AtomicReference<Object> holder = null;
            try {
                context = contextField.get(invocationObject);
                if (context instanceof AtomicReference) {
                    holder = (AtomicReference<Object>)context;
                }
            }
            catch (IllegalArgumentException e) {
                this.feedback.debug(module, "Couldn't read injected field __Wily_txnContext", e);
            }
            catch (IllegalAccessException e) {
                this.feedback.debug(module, "Couldn't access injected field __Wily_txnContext", e);
            }
            if (holder == null) {
                holder = new AtomicReference<Object>();
                try {
                    contextField.set(invocationObject, holder);
                }
                catch (IllegalArgumentException e) {
                    this.feedback.debug(module, "Couldn't set injected field __Wily_txnContext", e);
                }
                catch (IllegalAccessException e) {
                    this.feedback.debug(module, "Couldn't access injected field __Wily_txnContext", e);
                }
                if (this.feedback.isDebugEnabled(module)) {
                    this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " set the context holder in the field for class " + invocationObject.getClass().getName());
                }
            }
            if ((context = (ImmutableTransactionContext)holder.get()) == null) {
                context = this.createContext(data, invocationObject);
                if (!holder.compareAndSet(null, context)) {
                    context = (ImmutableTransactionContext)holder.get();
                }
            } else {
                this.processContext(data, invocationObject, (ImmutableTransactionContext)context);
            }
        } else {
            this.feedback.warn(module, "Could not find injected field __Wily_txnContext in class " + invocationObject.getClass().getName());
        }
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        if (invocationObject != null) {
            this.processInjectedField(data, invocationObject);
            return;
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (data.getProbeInformation().getProbeIdentification().getProbeMethodName().equals("<init>")) {
            Object invocationObject = data.getInvocationObject();
            this.processInjectedField(data, invocationObject);
            return;
        }
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

