/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.AGatherer;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;

public abstract class ACombiningGatherer
extends AGatherer {
    private long fDataPointCount;

    protected ACombiningGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
    }

    @Override
    protected final ATimeslicedValue[] doHarvest(long when, BlameStackSnapshot blameStack) {
        ATimeslicedValue singleValue = this.harvestSingleValue(when, blameStack);
        return new ATimeslicedValue[]{singleValue};
    }

    @Override
    protected final void doReset(long when) {
        this.resetCombiningGatherer(when);
    }

    private void resetCombiningGatherer(long when) {
        this.doResetCombiningGatherer(when);
        this.fDataPointCount = 0L;
        this.resetStartTimestamp(when);
    }

    protected abstract void doResetCombiningGatherer(long var1);

    @Override
    protected final void doReinitialize() {
        this.fDataPointCount = 0L;
        this.doReinitializeCombiningGatherer();
    }

    protected abstract void doReinitializeCombiningGatherer();

    protected final ATimeslicedValue harvestSingleValue(long when, BlameStackSnapshot blameStack) {
        return this.doCombiningHarvest(when, blameStack);
    }

    protected abstract ATimeslicedValue doCombiningHarvest(long var1, BlameStackSnapshot var3);

    public final long getDataPointCount() {
        return this.fDataPointCount;
    }

    protected final void incrementDataPointCount() {
        this.addToDataPointCount(1);
        this.newDataPointsReceived();
    }

    protected final void incrementDataPointCountNonSync() {
        ++this.fDataPointCount;
        this.newDataPointsReceived();
    }

    protected final synchronized void addToDataPointCount(int count) {
        this.fDataPointCount += (long)count;
    }

    protected final synchronized void addToDataPointCount(long count) {
        this.fDataPointCount += count;
    }

    protected final void addToDataPointCountNonSync(long count) {
        this.fDataPointCount += count;
    }

    protected final boolean isFirstDataPoint() {
        return this.fDataPointCount == 0L;
    }

    public final boolean isEmpty() {
        return this.isFirstDataPoint();
    }

    @Override
    public final boolean IGatherer_canCombineData() {
        return true;
    }

    @Override
    public IMetricDataValue harvestAndReinitializeNonSync(long harvestTimeMS) {
        ATimeslicedValue result = this.harvestSingleValue(harvestTimeMS, BlameStackSnapshot.kEmptyBlameStackSnapshot);
        this.reset(harvestTimeMS);
        this.noteDataIsAbsent();
        return result;
    }

    @Override
    public IMetricDataValue harvestAndAbandonNonSync(long harvestTimeMS) {
        ATimeslicedValue result = this.harvestSingleValue(harvestTimeMS, BlameStackSnapshot.kEmptyBlameStackSnapshot);
        return result;
    }

    protected static ATimeslicedValue absentInt(IntegerTimeslicedValue value1, IntegerTimeslicedValue value2) {
        int avg;
        int max;
        int min;
        long count;
        if (value1.dataIsAbsent() && value2.dataIsAbsent()) {
            return new IntegerTimeslicedValue(value1.getType(), value1.getStartTimestampInMillis(), value2.getStopTimestampInMillis(), null, true);
        }
        if (value1.dataIsAbsent()) {
            count = value2.getDataPointCount();
            min = value2.getMinimum();
            max = value2.getMaximum();
            avg = value2.getValue();
        } else {
            count = value1.getDataPointCount();
            min = value1.getMinimum();
            max = value1.getMaximum();
            avg = value1.getValue();
        }
        return new IntegerTimeslicedValue(value1.getType(), value1.getStartTimestampInMillis(), value1.getStopTimestampInMillis(), null, count, false, avg, min, max);
    }

    protected static ATimeslicedValue absentLong(LongTimeslicedValue value1, LongTimeslicedValue value2) {
        long avg;
        long max;
        long min;
        long count;
        if (value1.dataIsAbsent() && value2.dataIsAbsent()) {
            return new LongTimeslicedValue(value1.getType(), value1.getStartTimestampInMillis(), value2.getStopTimestampInMillis(), null, true);
        }
        if (value1.dataIsAbsent()) {
            count = value2.getDataPointCount();
            min = value2.getMinimum();
            max = value2.getMaximum();
            avg = value2.getValue();
        } else {
            count = value1.getDataPointCount();
            min = value1.getMinimum();
            max = value1.getMaximum();
            avg = value1.getValue();
        }
        return new LongTimeslicedValue(value1.getType(), value1.getStartTimestampInMillis(), value1.getStopTimestampInMillis(), null, count, false, avg, min, max);
    }
}

