/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.container;

import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.stream.RegisteredMessageStreamPublisher;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BeanPublisher {
    private final Map fStreams = new HashMap();
    private final PostOffice fPostOffice;

    BeanPublisher(PostOffice po) {
        this.fPostOffice = po;
    }

    void activate() {
    }

    void deactivate() {
        for (RegisteredMessageStreamPublisher pub : this.fStreams.values()) {
            pub.close();
        }
        this.fStreams.clear();
    }

    void removeStream(String stream) {
        RegisteredMessageStreamPublisher pub = (RegisteredMessageStreamPublisher)this.fStreams.remove(stream);
        if (pub != null) {
            pub.close();
        }
    }

    void setStreamGroups(String name, String[] groups) {
        RegisteredMessageStreamPublisher pub = (RegisteredMessageStreamPublisher)this.fStreams.get(name);
        if (pub != null) {
            pub.setGroupAccess(groups);
        }
    }

    void createStream(String name, Class clazz) throws EntryAlreadyExistsException, InvalidIsengardInterface, ConnectionException {
        this.createStream(name, clazz, new HashMap());
    }

    void createStream(String name, Class clazz, Map properties) throws EntryAlreadyExistsException, InvalidIsengardInterface, ConnectionException {
        RegisteredMessageStreamPublisher stream = new RegisteredMessageStreamPublisher(this.fPostOffice, name, clazz, properties, null);
        this.fStreams.put(name, stream);
    }

    Object getPublisher() {
        Iterator it;
        Object o;
        RegisteredMessageStreamPublisher stream;
        if (this.fStreams.size() == 1 && (stream = (RegisteredMessageStreamPublisher)(o = (it = this.fStreams.values().iterator()).next())) != null) {
            return stream.getPublisher();
        }
        return null;
    }

    Object getPublisher(String name) {
        RegisteredMessageStreamPublisher stream = (RegisteredMessageStreamPublisher)this.fStreams.get(name);
        if (stream != null) {
            return stream.getPublisher();
        }
        return null;
    }

    public int getSubscriptionCount() {
        return this.fStreams.size();
    }
}

