/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.trace.common;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.brtm.trace.common.AbstractMethodCache;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import java.lang.reflect.Method;

public class SimpleMethodCache
extends AbstractMethodCache {
    private Method[] m_methodCache = null;

    public SimpleMethodCache(int size, String[] methodNames, String[] overrideClassNames) {
        this.m_methodCache = new Method[size];
        this.m_methodNames = methodNames;
        this.m_overrideClassNames = overrideClassNames;
    }

    @Override
    Method getMethod(Object object, int methodIndex, InvocationData invocationData, Class[] argClassArray, String tracerName) {
        if (object == null) {
            AgentShim.handleError((String)("Error: " + tracerName + ": object is null"), null);
            return null;
        }
        Method method = this.m_methodCache[methodIndex];
        if (method == null) {
            this.m_methodCache[methodIndex] = method = this.getMethodSignature(object, methodIndex, invocationData, argClassArray, false);
        }
        return method;
    }

    @Override
    Method getMethodForClass(Class objClass, int methodIndex, InvocationData invocationData, Class[] argClassArray, String tracerName) {
        if (objClass == null) {
            AgentShim.handleError((String)("Error: " + tracerName + ": classObj is null"), null);
            return null;
        }
        Method method = this.m_methodCache[methodIndex];
        if (method == null) {
            this.m_methodCache[methodIndex] = method = this.getMethodSignatureForClass(objClass, methodIndex, invocationData, argClassArray, false);
        }
        return method;
    }

    @Override
    boolean isMethodPresent(Object obj, int methodIndex, Class[] argClassArray, String tracerName) {
        if (obj == null) {
            AgentShim.handleError((String)("Error: " + tracerName + ": object is null"), null);
            return false;
        }
        Method method = this.m_methodCache[methodIndex];
        if (method == null) {
            this.m_methodCache[methodIndex] = method = this.getMethodSignature(obj, methodIndex, null, argClassArray, true);
        }
        return method != null;
    }

    Method getMethodSignature(Object object, int methodIndex, InvocationData data, Class[] argClassArray, boolean silent) {
        if (object == null) {
            AgentShim.handleError((String)"Error: SimpleMethodCache: object is null", null);
            return null;
        }
        if (this.getOverrideClassName(methodIndex) != null && this.getOverrideClassName(methodIndex).length() > 0) {
            ClassLoader classLoader = object.getClass().getClassLoader();
            Class<?> overriddenClass = null;
            try {
                overriddenClass = Class.forName(this.getOverrideClassName(methodIndex), true, classLoader);
            }
            catch (ClassNotFoundException e) {
                AgentShim.handleError((String)("BRT: getMethodSignature: Unable find " + this.getOverrideClassName(methodIndex)), (Throwable)e);
                return null;
            }
            return this.getMethodSignatureForClass(overriddenClass, methodIndex, data, argClassArray, silent);
        }
        return this.getMethodSignatureForClass(object.getClass(), methodIndex, data, argClassArray, silent);
    }

    Method getMethodSignatureForClass(Class classObj, int methodIndex, InvocationData data, Class[] argClassArray, boolean silent) {
        if (classObj == null) {
            AgentShim.handleError((String)"Error: SimpleMethodCache: classObj is null", null);
            return null;
        }
        String methodName = this.getMethodName(methodIndex);
        Method method = null;
        try {
            method = classObj.getMethod(methodName, argClassArray);
        }
        catch (Exception e) {
            String classMethodName = "Unknown";
            if (data != null) {
                ProbeIdentification pid = data.getProbeInformation().getProbeIdentification();
                classMethodName = String.valueOf(pid.getProbeClassName()) + " " + pid.getProbeMethodName();
            }
            if (!silent) {
                AgentShim.handleError((String)("Error: SimpleMethodCache a problem occurred while getting signature of method: " + methodName + " at probe point: " + classMethodName), (Throwable)e);
            }
            return null;
        }
        if (method == null) {
            if (!silent) {
                AgentShim.handleError((String)("Error: SimpleMethodCache no " + methodName + " method found"), null);
            }
            return null;
        }
        return method;
    }
}

