/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.cache;

import com.wily.rave.agent.cache.IRaveContentFullCache;
import com.wily.rave.utils.PersistentState;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

public class RaveCache
implements IRaveContentFullCache {
    private PersistentState fPersistedData;
    private HashMap fDataMap;
    private boolean fMemDirty;

    private RaveCache(PersistentState persistedData, HashMap dataMap) {
        this.fPersistedData = persistedData;
        this.fDataMap = dataMap;
        this.fMemDirty = false;
    }

    private RaveCache(String path, String file, HashMap dataMap) throws IOException {
        this(new PersistentState(path, file, true), dataMap);
    }

    public RaveCache(String path, String file) throws IOException {
        this(path, file, new HashMap());
    }

    @Override
    public Serializable get(Serializable key) {
        return (Serializable)this.fDataMap.get(key);
    }

    @Override
    public void set(Serializable key, Serializable data) {
        this.fDataMap.put(key, data);
        this.fMemDirty = true;
    }

    @Override
    public void remove(Serializable key) {
        this.fDataMap.remove(key);
        this.fMemDirty = true;
    }

    @Override
    public boolean dirty() {
        return this.fMemDirty;
    }

    @Override
    public Set keySet() {
        return this.fDataMap.keySet();
    }

    @Override
    public Collection values() {
        return this.fDataMap.values();
    }

    @Override
    public void clear() {
        this.fDataMap.clear();
        this.fMemDirty = true;
    }

    public void write() throws IOException {
        this.fPersistedData.write((Serializable)this.fDataMap);
    }

    public void writeAndCommit() throws IOException {
        this.fPersistedData.writeAndCommit((Serializable)this.fDataMap);
        this.fMemDirty = false;
    }

    public void read() throws IOException {
        if (this.fMemDirty) {
            this.fDataMap = (HashMap)this.fPersistedData.read2(this.getClass().getClassLoader());
            this.fMemDirty = false;
        }
    }

    public void commit() throws IOException {
        if (this.fPersistedData.isDirty()) {
            this.fPersistedData.commit();
        }
        this.fMemDirty = false;
    }

    public static RaveCache deSerialize(String path, String name) throws IOException {
        PersistentState cacheFile = new PersistentState(path, name, true);
        HashMap dataMap = (HashMap)cacheFile.read();
        if (dataMap == null) {
            return null;
        }
        return new RaveCache(cacheFile, dataMap);
    }

    public static RaveCache deSerialize2(String path, String name, ClassLoader cl) throws IOException {
        PersistentState cacheFile = new PersistentState(path, name, true);
        HashMap dataMap = (HashMap)cacheFile.read2(cl);
        if (dataMap == null) {
            return null;
        }
        return new RaveCache(cacheFile, dataMap);
    }

    public void destroy() {
        this.fDataMap = null;
        this.fPersistedData.destroy();
        this.fPersistedData = null;
    }
}

