/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.classmonitor;

import com.wily.EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import com.wily.introscope.agent.transformer.IllegalClassFormatException;
import com.wily.rave.agent.ds.classmonitor.ClassInfoContainer;
import java.security.ProtectionDomain;

public final class ClassTransformer {
    private static final ClassTransformer transformerInternal;
    private volatile boolean enabled = true;
    private final LinkedQueue classesList = new LinkedQueue();
    static final ClassInfoContainer BOGUS_CLASS_INFO;

    static {
        try {
            Class.forName("com.wily.rave.agent.ds.classmonitor.ClassInfoContainer");
            Class.forName("com.wily.EDU.oswego.cs.dl.util.concurrent.LinkedQueue");
        }
        catch (Throwable throwable) {}
        transformerInternal = new ClassTransformer();
        BOGUS_CLASS_INFO = new ClassInfoContainer(null, null, null, false);
    }

    private ClassTransformer() {
    }

    public static final ClassTransformer getTransformer() {
        return transformerInternal;
    }

    public final void disable() throws InterruptedException {
        this.enabled = false;
        while (this.classesList.poll(0L) != null) {
        }
    }

    public final byte[] transform(boolean classLoaderIsAvailable, ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException, InterruptedException {
        if (ClassTransformer.class.getClassLoader() != loader && className != null && this.enabled) {
            this.classesList.offer(new ClassInfoContainer(loader, className, classfileBuffer, false), 0L);
        }
        return classfileBuffer;
    }

    public final ClassInfoContainer getNextClass(boolean keep) throws InterruptedException {
        if (keep) {
            return (ClassInfoContainer)this.classesList.peek();
        }
        return (ClassInfoContainer)this.classesList.poll(0L);
    }

    public final boolean processNextClass(IInfoContainerProcessor processor) throws InterruptedException {
        ClassInfoContainer processedEntry;
        ClassInfoContainer entry = null;
        try {
            entry = (ClassInfoContainer)this.classesList.poll(0L);
        }
        catch (InterruptedException e) {
            processor.onGetEntryException(e);
            throw e;
        }
        if (entry != null && (processedEntry = processor.processEntry(entry)) != null) {
            try {
                this.classesList.offer(processedEntry, 0L);
            }
            catch (InterruptedException e) {
                processor.onPutEntryException(processedEntry.getClassName(), e);
                throw e;
            }
        }
        return entry != null;
    }

    public static interface IInfoContainerProcessor {
        public ClassInfoContainer processEntry(ClassInfoContainer var1);

        public void onGetEntryException(Exception var1);

        public void onPutEntryException(String var1, Exception var2);
    }
}

