/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.file;

import com.wily.rave.agent.ds.file.fileSpec.AFileSpec;
import com.wily.util.LinkedHashSet;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class FileSet {
    protected IModuleFeedbackChannel fLogger;
    private LinkedHashSet fFileSet;

    public FileSet(IModuleFeedbackChannel logger) {
        this.fLogger = logger;
        this.fFileSet = new LinkedHashSet();
    }

    public FileSet(FileSet fileSetToClone) {
        this.fLogger = fileSetToClone.fLogger;
        this.fFileSet = fileSetToClone.fFileSet;
    }

    public Iterator getFileIterator() {
        Set copy = (Set)this.fFileSet.clone();
        return new IteratorWrapper(copy.iterator());
    }

    public void addFile(AFileSpec fileS) {
        if (!this.fFileSet.contains(fileS)) {
            this.fFileSet.add(fileS);
        }
    }

    public boolean removeFile(AFileSpec fileS) {
        return this.fFileSet.remove(fileS);
    }

    public boolean contains(AFileSpec fileS) {
        return this.fFileSet.contains(fileS);
    }

    public int size() {
        return this.fFileSet.size();
    }

    public void addAll(FileSet newFileSet) {
        this.fFileSet.addAll((Collection)newFileSet.fFileSet);
    }

    public Object[] toArray(Object[] a) {
        return this.fFileSet.toArray(a);
    }

    public Object[] toArray() {
        return this.fFileSet.toArray();
    }

    private static class IteratorWrapper
    implements Iterator {
        private Iterator fIterator;

        public IteratorWrapper(Iterator iterator) {
            this.fIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.fIterator.hasNext();
        }

        public Object next() {
            return this.fIterator.next();
        }

        @Override
        public void remove() {
            this.fIterator.remove();
        }
    }
}

