/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.file.fileSpec;

import com.wily.rave.agent.ds.file.fileSpec.AFileSpec;
import com.wily.rave.utils.HashCodeUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public final class ZipEntryFileSpec
extends AFileSpec {
    private static final long serialVersionUID = 1L;
    private static final Map fEntries = new WeakHashMap();
    public static final String kSeparator = ":";
    private AFileSpec fParent;

    public ZipEntryFileSpec() {
    }

    private ZipEntryFileSpec(AFileSpec parent, String name) {
        super(name);
        this.fParent = parent;
    }

    private static synchronized ZipEntryFileSpec get(ZipEntryFileSpec entry) {
        ZipEntryFileSpec oldFileSpec = null;
        WeakReference prevRef = (WeakReference)fEntries.get(entry);
        if (prevRef != null) {
            oldFileSpec = (ZipEntryFileSpec)prevRef.get();
        }
        if (oldFileSpec == null) {
            fEntries.put(entry, new WeakReference<ZipEntryFileSpec>(entry));
            return entry;
        }
        return oldFileSpec;
    }

    public static ZipEntryFileSpec get(AFileSpec parent, String name) {
        ZipEntryFileSpec entry = new ZipEntryFileSpec(parent, name);
        return ZipEntryFileSpec.get(entry);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ZipEntryFileSpec)) {
            return false;
        }
        ZipEntryFileSpec entry = (ZipEntryFileSpec)o;
        return entry.fName.equals(this.fName) && this.fParent.equals(entry.fParent);
    }

    public int hashCode() {
        return HashCodeUtils.accumulateHashCode((int)this.fParent.hashCode(), (Object)this.fName);
    }

    @Override
    public String toString() {
        return String.valueOf(this.fParent.toString()) + kSeparator + this.fName;
    }

    public AFileSpec getParentFileSpec() {
        return this.fParent;
    }

    @Override
    public String getFullName() {
        return this.toString();
    }

    private Object readResolve() throws ObjectStreamException {
        return ZipEntryFileSpec.get(this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.fParent = (AFileSpec)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.fParent);
    }
}

