/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class LinkedHashSet
implements Set,
Collection,
Cloneable {
    private final Node fHead;
    private Node fTail;
    private final HashMap fHash;

    public LinkedHashSet() {
        this.fTail = this.fHead = new Node(null);
        this.fHash = new HashMap();
    }

    public LinkedHashSet(Collection c) {
        this.fTail = this.fHead = new Node(null);
        this.fHash = new HashMap();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
    }

    @Override
    public int size() {
        return this.fHash.size();
    }

    @Override
    public boolean isEmpty() {
        return this.fHash.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.fHash.get(o) != null;
    }

    @Override
    public Iterator iterator() {
        return new NodeDataIterator(this.fHead.fNext);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.fHash.size()];
        this.copyIntoArray(array);
        return array;
    }

    public Object[] toArray(Object[] a) {
        Object[] array = a;
        if (a.length < this.fHash.size()) {
            array = (Object[])Array.newInstance(a.getClass(), this.fHash.size());
        }
        this.copyIntoArray(array);
        return array;
    }

    private void copyIntoArray(Object[] tgt) {
        int i = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            tgt[i] = iter.next();
            ++i;
        }
    }

    public boolean add(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.contains(o)) {
            return false;
        }
        this.fTail.fNext = new Node(o, null);
        this.fHash.put(o, this.fTail);
        this.fTail = this.fTail.fNext;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Node tmpNode = (Node)this.fHash.get(o);
        if (tmpNode == null) {
            return false;
        }
        tmpNode.fNext = tmpNode.fNext.fNext;
        if (tmpNode.fNext != null) {
            this.fHash.put(tmpNode.fNext.fData, tmpNode);
        } else {
            this.fTail = tmpNode;
        }
        this.fHash.remove(o);
        return true;
    }

    public boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection c) {
        boolean retVal = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            retVal |= this.add(iter.next());
        }
        return retVal;
    }

    public boolean retainAll(Collection c) {
        boolean retVal = false;
        for (Object o : this) {
            if (c.contains(o)) continue;
            this.remove(o);
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(Collection c) {
        boolean retVal = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            retVal |= this.remove(iter.next());
        }
        return retVal;
    }

    @Override
    public void clear() {
        this.fHash.clear();
        this.fHead.fNext = null;
        this.fTail = this.fHead;
    }

    public Object clone() {
        return new LinkedHashSet(this);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        Iterator i = this.iterator();
        Iterator j = ((Collection)other).iterator();
        while (i.hasNext() && j.hasNext()) {
            if (i.next().equals(j.next())) continue;
            return false;
        }
        return !i.hasNext() && !j.hasNext();
    }

    private static class Node {
        Object fData;
        Node fNext;

        public Node(Object data) {
            this(data, null);
        }

        public Node(Object data, Node next) {
            this.fData = data;
            this.fNext = next;
        }

        public Node getNext() {
            return this.fNext;
        }

        public void setNext(Node next) {
            this.fNext = next;
        }

        public Object getObject() {
            return this.fData;
        }

        public int hashCode() {
            return this.fData.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Node)) {
                return false;
            }
            Node otherNode = (Node)o;
            return this.fData.equals(otherNode.fData);
        }
    }

    private class NodeDataIterator
    implements Iterator {
        private Node fCurrent;

        public NodeDataIterator(Node head) {
            this.fCurrent = head;
        }

        @Override
        public boolean hasNext() {
            return this.fCurrent != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements.");
            }
            Node retNode = this.fCurrent;
            this.fCurrent = this.fCurrent.fNext;
            return retNode.fData;
        }

        @Override
        public void remove() {
            Object toRemove = this.fCurrent.fData;
            this.fCurrent = this.fCurrent.fNext;
            LinkedHashSet.this.remove(toRemove);
        }
    }
}

