/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties;

import com.wily.util.properties.PrefixedKeysIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EnvironmentPropertiesHandler {
    private final HashMap<String, String> envMap = new HashMap();
    private final String prefix = "apmenv_";
    private static volatile EnvironmentPropertiesHandler instance = null;
    private volatile boolean hasData = false;

    private EnvironmentPropertiesHandler() {
        this.buildApmEnvEntriesMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EnvironmentPropertiesHandler getInstance() {
        if (instance != null) return instance;
        Class<EnvironmentPropertiesHandler> clazz = EnvironmentPropertiesHandler.class;
        synchronized (EnvironmentPropertiesHandler.class) {
            if (instance != null) return instance;
            instance = new EnvironmentPropertiesHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void buildApmEnvEntriesMap() {
        try {
            Map<String, String> map = System.getenv();
            if (!map.isEmpty()) {
                PrefixedKeysIterator iterator = new PrefixedKeysIterator(map.keySet().iterator(), "apmenv_", false);
                StringBuilder builder = new StringBuilder(100);
                while (iterator.hasNext()) {
                    String translatedKey;
                    String key = iterator.next();
                    String value = map.get(key);
                    if (value == null || value.length() <= 0 || (translatedKey = this.parseKey(builder, key.toLowerCase().trim(), "apmenv_")).length() <= 0) continue;
                    this.envMap.put(translatedKey, value);
                    this.hasData = true;
                }
            }
        }
        catch (Exception exception) {}
    }

    private String parseKey(StringBuilder builder, String envKey, String prefix) {
        builder.setLength(0);
        int length = envKey.length();
        int i = prefix.length();
        while (i < length) {
            char x = envKey.charAt(i);
            if (x == '_') {
                builder.append('.');
            } else {
                builder.append(x);
            }
            ++i;
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EnvironmentPropertiesHandler newSingletonInstance() {
        Class<EnvironmentPropertiesHandler> clazz = EnvironmentPropertiesHandler.class;
        synchronized (EnvironmentPropertiesHandler.class) {
            instance = new EnvironmentPropertiesHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean hasData() {
        return this.hasData;
    }

    public String getProperty(String key) {
        if (this.hasData) {
            return this.envMap.get(key.toLowerCase());
        }
        return null;
    }

    public Set<String> getAllKeys() {
        if (this.hasData) {
            return Collections.unmodifiableSet(this.envMap.keySet());
        }
        return null;
    }
}

