/*
 * Decompiled with CFR 0.152.
 */
package com.wily.zos.common;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.zos.common.MetricWriter;

public abstract class Poller
implements ITimestampedRunnable {
    private IAgent agent;
    private IModuleFeedbackChannel feedback;
    private MetricWriter metricWriter;

    public Poller(IAgent agent) {
        this.agent = agent;
        this.feedback = agent.IAgent_getModuleFeedback();
        this.metricWriter = new MetricWriter(agent);
        this.initialize();
    }

    protected void initialize() {
    }

    public void ITimestampedRunnable_execute(long nowInMillis) {
        this.heartbeat();
    }

    protected abstract void heartbeat();

    protected void writeLong(String metricName, long value) {
        this.metricWriter.writeLong(metricName, value);
    }

    protected void writeLongDelta(String metricName, long value) {
        this.metricWriter.writeLongDelta(metricName, value);
    }

    protected void writeInt(String metricName, int value) {
        this.metricWriter.writeInt(metricName, value);
    }

    protected void writeIntDelta(String metricName, int value) {
        this.metricWriter.writeIntDelta(metricName, value);
    }

    protected void writeString(String metricName, String value) {
        this.metricWriter.writeString(metricName, value);
    }

    protected void writeAverageResponseTime(String metricName, long value) {
        this.metricWriter.writeAverageResponseTime(metricName, value);
    }

    protected void writeResponsesPerInterval(String metricName) {
        this.metricWriter.writeResponsesPerInterval(metricName);
    }

    protected void increment(String metricName) {
        this.metricWriter.increment(metricName);
    }

    protected void decrement(String metricName) {
        this.metricWriter.decrement(metricName);
    }

    protected AgentMetric longMetric(String metricName) {
        return this.metricWriter.longMetric(metricName);
    }

    protected AgentMetric intMetric(String metricName) {
        return this.metricWriter.intMetric(metricName);
    }

    protected AgentMetric stringMetric(String metricName) {
        return this.metricWriter.stringMetric(metricName);
    }

    protected AgentMetric averageMetric(String metricName) {
        return this.metricWriter.averageMetric(metricName);
    }

    protected AgentMetric intervalMetric(String metricName) {
        return this.metricWriter.intervalMetric(metricName);
    }

    protected void logInfo(String message) {
        this.feedback.info(message);
    }

    protected void logWarn(String message) {
        this.feedback.warn(message);
    }

    protected void logError(String message) {
        this.feedback.error(message);
    }

    protected void logDebug(String message) {
        this.feedback.debug(message);
    }
}

