/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.AJMXDataView;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongFluctuatingCounterDataAccumulator;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;

public class CompositeDataJMXDataView
extends AJMXDataView {
    private IDataAccumulator fAccumulator;
    private String fFullIntroscopeMetricName;
    private Hashtable fAccumulatorMap;

    public CompositeDataJMXDataView(IAgent agent, ObjectName on, MBeanServer server, String attributeName, String fullIntroscopeMetricName) {
        super(agent, on, server, attributeName);
        this.fFullIntroscopeMetricName = fullIntroscopeMetricName;
        this.fAccumulatorMap = new Hashtable();
    }

    @Override
    protected void doUpdate(Object currentValue) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        if (currentValue instanceof CompositeData) {
            CompositeData cd = (CompositeData)currentValue;
            CompositeType ct = cd.getCompositeType();
            Iterator<String> itemNames = ct.keySet().iterator();
            String itemName = "";
            if (itemNames != null) {
                while (itemNames.hasNext()) {
                    ILongFluctuatingCounterDataAccumulator accumulator;
                    itemName = itemNames.next();
                    Object value = cd.get(itemName);
                    if (ct.getType(itemName).getClassName().equals("java.lang.Long")) {
                        if (!this.fAccumulatorMap.containsKey(String.valueOf(this.fFullIntroscopeMetricName) + itemName)) {
                            accumulator = (ILongFluctuatingCounterDataAccumulator)this.getTypedAccumulator(true, itemName);
                            if (accumulator == null) continue;
                            this.fAccumulatorMap.put(String.valueOf(this.fFullIntroscopeMetricName) + itemName, accumulator);
                            accumulator.ILongCounterDataAccumulator_setValue(((Long)value).longValue());
                            continue;
                        }
                        accumulator = (ILongFluctuatingCounterDataAccumulator)this.fAccumulatorMap.get(String.valueOf(this.fFullIntroscopeMetricName) + itemName);
                        if (accumulator == null) continue;
                        accumulator.ILongCounterDataAccumulator_setValue(((Long)value).longValue());
                        continue;
                    }
                    if (!ct.getType(itemName).getClassName().equals("java.lang.Integer")) continue;
                    if (!this.fAccumulatorMap.containsKey(String.valueOf(this.fFullIntroscopeMetricName) + itemName)) {
                        accumulator = (IIntegerFluctuatingCounterDataAccumulator)this.getTypedAccumulator(false, itemName);
                        if (accumulator == null) continue;
                        this.fAccumulatorMap.put(String.valueOf(this.fFullIntroscopeMetricName) + itemName, accumulator);
                        accumulator.IIntegerCounterDataAccumulator_setValue(((Integer)value).intValue());
                        continue;
                    }
                    accumulator = (IIntegerFluctuatingCounterDataAccumulator)this.fAccumulatorMap.get(String.valueOf(this.fFullIntroscopeMetricName) + itemName);
                    if (accumulator == null) continue;
                    accumulator.IIntegerCounterDataAccumulator_setValue(((Integer)value).intValue());
                }
            }
        }
    }

    @Override
    protected IDataAccumulator getAccumulator(boolean forceCreate) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        if (forceCreate && this.fAccumulator == null) {
            this.fAccumulator = (IDataAccumulator)this.fAccumulatorMap.get(this.fFullIntroscopeMetricName);
        }
        return this.fAccumulator;
    }

    private IDataAccumulator getTypedAccumulator(boolean isLongAccumulator, String itemName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        if (isLongAccumulator) {
            return this.getAgent().IAgent_getDataAccumulatorFactory().createLongFluctuatingCounterDataAccumulator(String.valueOf(this.fFullIntroscopeMetricName) + " (" + itemName + ")");
        }
        return this.getAgent().IAgent_getDataAccumulatorFactory().createIntegerFluctuatingCounterDataAccumulator(String.valueOf(this.fFullIntroscopeMetricName) + " (" + itemName + ")");
    }

    @Override
    protected void doDestroy() {
        if (this.fAccumulator != null) {
            this.getAgent().IAgent_getDataAccumulatorFactory().removeDataAccumulator(this.fAccumulator);
            this.fAccumulator = null;
        }
        IDataAccumulator accumulator2 = null;
        for (IDataAccumulator accumulator2 : this.fAccumulatorMap.values()) {
            if (accumulator2 == null) continue;
            this.getAgent().IAgent_getDataAccumulatorFactory().removeDataAccumulator(accumulator2);
        }
        this.fAccumulatorMap.clear();
    }

    @Override
    public String getFullMetricName() {
        return this.fFullIntroscopeMetricName;
    }
}

