/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties;

import com.wily.util.IComparer;
import com.wily.util.Sorter;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import com.wily.util.properties.EnvironmentPropertiesHandler;
import com.wily.util.properties.PropertiesUtils;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;

public class IndexedProperties
extends Properties {
    private static final long serialVersionUID = -4663651679944106520L;
    private static final String kCanonicalBooleanTrueValue = "true";
    private static final String kCanonicalBooleanFalseValue = "false";
    private static final String kCanonicalBooleanMaybeValue = "maybe";
    private static final Random sRandomSource = new Random();
    public static EnvironmentPropertiesHandler envPropertyhandler = EnvironmentPropertiesHandler.getInstance();

    public IndexedProperties() {
    }

    public IndexedProperties(Properties defaultProperties) {
        super(defaultProperties);
    }

    public IndexedProperties(Map initialValues) {
        for (Map.Entry current : initialValues.entrySet()) {
            this.setProperty((String)current.getKey(), (String)current.getValue());
        }
    }

    public void combineIndexProperties(IndexedProperties[] indexPropertiesArr) {
        int i = 0;
        while (i < indexPropertiesArr.length) {
            if (indexPropertiesArr[i] != null) {
                this.putAll((Map<?, ?>)indexPropertiesArr[i]);
            }
            ++i;
        }
    }

    public static IndexedProperties newInstance(IndexedProperties properties) {
        IndexedProperties copy = new IndexedProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyKey = (String)enumeration.nextElement();
            String propertyValue = properties.getProperty(propertyKey);
            copy.setProperty(propertyKey, propertyValue);
        }
        return copy;
    }

    @Override
    public String getProperty(String key) {
        String envProp;
        String sysProp = System.getProperty(key);
        if (sysProp != null) {
            return sysProp;
        }
        if (envPropertyhandler != null && envPropertyhandler.hasData() && (envProp = envPropertyhandler.getProperty(key)) != null) {
            return envProp;
        }
        return super.getProperty(key);
    }

    public String getNonOverrideProperty(String key) {
        return super.getProperty(key);
    }

    public String getIndexedProperty(String key, int index) {
        return this.getProperty(String.valueOf(key) + "." + index);
    }

    public String getTrimmedIndexedProperty(String key, int index) {
        return this.getTrimmedProperty(String.valueOf(key) + "." + index);
    }

    public void putIndexedProperty(String key, int index, String property) {
        this.put(String.valueOf(key) + "." + index, property);
    }

    public String[] getIndexedProperties(String key) {
        return this.getIndexedProperties(key, false);
    }

    public String[] getTrimmedIndexedProperties(String key) {
        return this.getIndexedProperties(key, true);
    }

    private synchronized String[] getIndexedProperties(String key, boolean trimmed) {
        Vector<String> v = new Vector<String>();
        int i = 0;
        boolean done = false;
        while (!done) {
            String prop;
            String string = prop = trimmed ? this.getTrimmedIndexedProperty(key, i) : this.getIndexedProperty(key, i);
            if (prop != null) {
                v.addElement(prop);
            } else {
                done = true;
            }
            ++i;
        }
        Object[] props = new String[v.size()];
        v.copyInto(props);
        return props;
    }

    public String[] getAndCondenseAllIndexedProperties(String key) {
        return this.getAndCondenseAllIndexedProperties(key, false);
    }

    public String[] getAndCondenseAllTrimmedIndexedProperties(String key) {
        return this.getAndCondenseAllIndexedProperties(key, true);
    }

    private synchronized String[] getAndCondenseAllIndexedProperties(String key, boolean trimmed) {
        Vector<KeyIndex> v = new Vector<KeyIndex>();
        Enumeration<?> keys = this.propertyNames();
        while (keys.hasMoreElements()) {
            String nextKey = (String)keys.nextElement();
            int lastDotIndex = nextKey.lastIndexOf(46);
            if (lastDotIndex == -1 || !nextKey.substring(0, lastDotIndex).equals(key)) continue;
            try {
                int index = Integer.parseInt(nextKey.trim().substring(lastDotIndex + 1));
                v.addElement(new KeyIndex(index, nextKey));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        Object[] keyIndexArray = new KeyIndex[v.size()];
        v.copyInto(keyIndexArray);
        Sorter.sort(keyIndexArray, (IComparer)new KeyIndexComparer());
        String[] props = new String[keyIndexArray.length];
        int i = 0;
        while (i < props.length) {
            props[i] = trimmed ? this.getTrimmedProperty(((KeyIndex)keyIndexArray[i]).fKey) : this.getProperty(((KeyIndex)keyIndexArray[i]).fKey);
            ++i;
        }
        return props;
    }

    public synchronized void putIndexedProperties(String key, String[] values) {
        this.removeIndexedProperties(key);
        int i = 0;
        while (i < values.length) {
            this.putIndexedProperty(key, i, values[i]);
            ++i;
        }
    }

    public void addIndexedProperty(String key, String value) {
        String[] props = this.getIndexedProperties(key);
        this.putIndexedProperty(key, props.length, value);
    }

    public synchronized void removeIndexedProperties(String key) {
        int i = 0;
        boolean done = false;
        while (!done) {
            String prop = this.getIndexedProperty(key, i);
            if (prop != null) {
                this.remove(String.valueOf(key) + "." + i);
            } else {
                done = true;
            }
            ++i;
        }
    }

    public int getIntProperty(String key) {
        return this.getIntProperty(key, 0);
    }

    public int getIntProperty(String key, int defaultValue) {
        String p = this.getTrimmedProperty(key);
        if (p == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public int safeGetIntProperty(String key, int defaultValue, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        String p = this.getTrimmedProperty(key);
        if (p == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException numberFormatException) {
            feedback.warn(localizer.IStringLocalizer_getFormattedLocalizedString("Indexed_Properties_Integer_Wasnt_Key", key, p, "" + defaultValue));
            return defaultValue;
        }
    }

    public int safeGetNonNegativeIntProperty(String key, int defaultValue, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        Assertion.wilyAssert(false);
        int result = this.safeGetIntProperty(key, defaultValue, feedback, localizer);
        if (result < 0) {
            feedback.warn(localizer.IStringLocalizer_getFormattedLocalizedString("Indexed_Properties_Non_Negative_Integer_Wasnt_Key", key, "" + result, "" + defaultValue));
            result = defaultValue;
        }
        return result;
    }

    public int safeGetPositiveIntProperty(String key, int defaultValue, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        Assertion.wilyAssert(false);
        int result = this.safeGetIntProperty(key, defaultValue, feedback, localizer);
        if (result <= 0) {
            feedback.warn(localizer.IStringLocalizer_getFormattedLocalizedString("Indexed_Properties_Positive_Integer_Wasnt_Key", key, "" + result, "" + defaultValue));
            result = defaultValue;
        }
        return result;
    }

    public int safeGetGreaterThanOrEqualsDefaultIntProperty(String key, int defaultValue, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        Assertion.wilyAssert(false);
        int result = this.safeGetPositiveIntProperty(key, defaultValue, feedback, localizer);
        if (result < defaultValue) {
            feedback.warn(localizer.IStringLocalizer_getFormattedLocalizedString("Indexed_Properties_Greater_Than_Equals_Default_Wasnt_Key", key, Integer.toString(result), Integer.toString(defaultValue)));
            result = defaultValue;
        }
        return result;
    }

    public String[] safeGetSeparatedProperty(String key, String separator) {
        if (key == null || separator == null) {
            return null;
        }
        String p = this.getProperty(key);
        if (p == null) {
            return null;
        }
        p = p.trim();
        return StringUtils.parseList(p, separator);
    }

    public String[] safeGetSeparatedProperty(String key, String separator, String[] defaultValue) {
        String[] retVal = this.safeGetSeparatedProperty(key, separator);
        return retVal == null ? defaultValue : retVal;
    }

    public int getIndexedIntProperty(String key, int index) {
        return this.getIntProperty(String.valueOf(key) + "." + index);
    }

    public long getLongProperty(String key) {
        String p = this.getTrimmedProperty(key);
        if (p == null) {
            return 0L;
        }
        return Long.parseLong(p);
    }

    public long getLongProperty(String key, long defaultValue) {
        String p = this.getTrimmedProperty(key);
        if (p == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(p);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public boolean safeGetBooleanProperty(String key, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        return this.safeGetBooleanProperty(key, false, feedback, localizer);
    }

    public boolean safeGetBooleanProperty(String key, boolean defaultValue, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        String value = this.getTrimmedProperty(key);
        if (value == null) {
            return defaultValue;
        }
        boolean result = value.equalsIgnoreCase(kCanonicalBooleanTrueValue);
        if (value.equalsIgnoreCase(kCanonicalBooleanMaybeValue)) {
            return sRandomSource.nextBoolean();
        }
        if (!result && !value.equalsIgnoreCase(kCanonicalBooleanFalseValue)) {
            feedback.warn(localizer.IStringLocalizer_getFormattedLocalizedString("Indexed_Properties_Boolean_Wasnt_Key", key, value, "" + defaultValue));
            result = defaultValue;
        }
        return result;
    }

    public boolean getBooleanProperty(String key) {
        String b = this.getTrimmedProperty(key);
        if (b == null) {
            return false;
        }
        if (b.equalsIgnoreCase(kCanonicalBooleanMaybeValue)) {
            return sRandomSource.nextBoolean();
        }
        return b.equalsIgnoreCase(kCanonicalBooleanTrueValue);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String b = this.getTrimmedProperty(key);
        if (b == null) {
            return defaultValue;
        }
        if (b.equalsIgnoreCase(kCanonicalBooleanMaybeValue)) {
            return sRandomSource.nextBoolean();
        }
        return b.equalsIgnoreCase(kCanonicalBooleanTrueValue);
    }

    public void setBooleanProperty(String key, boolean value) {
        this.put(key, new Boolean(value).toString());
    }

    public void load(AttributeListing listing) {
        Iterator iterator = listing.getKeys();
        while (iterator.hasNext()) {
            String attribute = (String)iterator.next();
            String value = listing.get(attribute);
            this.put(attribute, value);
        }
    }

    public String getPasswordProperty(String key) {
        String e = this.getTrimmedProperty(key);
        if (e == null) {
            return null;
        }
        e = PropertiesUtils.decryptPassword(e);
        return e;
    }

    public String getTrimmedProperty(String property) {
        String result = this.getProperty(property);
        return result == null ? null : result.trim();
    }

    public String getTrimmedProperty(String property, String defaultValue) {
        String result = this.getProperty(property);
        return result == null ? defaultValue : result.trim();
    }

    public String getNamedProperty(String prefix, String name) {
        prefix = prefix.endsWith(".") ? prefix : String.valueOf(prefix) + ".";
        String property = this.getProperty(String.valueOf(prefix) + name);
        return property;
    }

    public String getTrimmedNamedProperty(String prefix, String name) {
        String property = this.getNamedProperty(prefix, name);
        return property == null ? null : property.trim();
    }

    private String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public void load(IResource resource) throws IOException {
        if (resource instanceof FileBasedResource) {
            FileReader r = resource.IResource_getSourceContents();
            this.load(r);
        } else {
            InputStream r = resource.IResource_getContents();
            this.load(r);
        }
    }

    @Override
    public synchronized void load(Reader inStream) throws IOException {
        try {
            int limit;
            char[] convtBuf = new char[1024];
            LineReader2 lr = new LineReader2(inStream);
            while ((limit = lr.readLine()) >= 0) {
                char c = '\u0000';
                int keyLen = 0;
                int valueStart = limit;
                boolean hasSep = false;
                boolean precedingBackslash = false;
                while (keyLen < limit) {
                    c = lr.lineBuf[keyLen];
                    if (!(c != '=' && c != ':' || precedingBackslash)) {
                        valueStart = keyLen + 1;
                        hasSep = true;
                        break;
                    }
                    if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                        valueStart = keyLen + 1;
                        break;
                    }
                    precedingBackslash = c == '\\' ? !precedingBackslash : false;
                    ++keyLen;
                }
                while (valueStart < limit) {
                    c = lr.lineBuf[valueStart];
                    if (c != ' ' && c != '\t' && c != '\f') {
                        if (hasSep || c != '=' && c != ':') break;
                        hasSep = true;
                    }
                    ++valueStart;
                }
                String key = this.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
                String value = this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
                this.put(key, value);
            }
        }
        finally {
            inStream.close();
        }
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        try {
            super.load(inStream);
        }
        finally {
            inStream.close();
        }
    }

    private class KeyIndex {
        public final int fIndex;
        public final String fKey;

        private KeyIndex(int index, String key) {
            this.fIndex = index;
            this.fKey = key;
        }
    }

    private class KeyIndexComparer
    implements IComparer {
        private KeyIndexComparer() {
        }

        @Override
        public boolean lessThan(Object obj1, Object obj2) {
            return ((KeyIndex)obj1).fIndex < ((KeyIndex)obj2).fIndex;
        }

        @Override
        public boolean equalTo(Object obj1, Object obj2) {
            return ((KeyIndex)obj1).fIndex == ((KeyIndex)obj2).fIndex;
        }
    }

    class LineReader2 {
        byte[] inBuf = new byte[8192];
        char[] inCharBuf = new char[8192];
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        Reader inStream;

        public LineReader2(Reader inStream) {
            this.inStream = inStream;
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream.read(this.inCharBuf, 0, 8192);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return -1;
                        }
                        return len;
                    }
                }
                c = (char)(0xFF & this.inCharBuf[this.inOff]);
                c = this.inCharBuf[this.inOff++];
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        isCommentLine = true;
                        continue;
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream.read(this.inCharBuf, 0, 8192);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

