/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.leakhunter;

import com.wily.introscope.agent.leakhunter.FieldRecord;
import com.wily.introscope.agent.leakhunter.LeakHunterSettings;
import com.wily.util.INameChangeListener;
import com.wily.util.LogFileUtilities;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.io.NullOutputStream;
import com.wily.util.text.IStringLocalizer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

final class LeakHunterLogFile
implements INameChangeListener {
    private final LeakHunterSettings fSettings;
    private final DateFormat fFormat;
    private final String fLineSeparator;
    private PrintWriter fWriter;
    private String fBaseFilename = null;
    private String fFullFilename = null;
    private static final int kSafeWindowsFileNameLength = 253;

    LeakHunterLogFile(LeakHunterSettings settings, boolean appendTimestampToLogFileName) {
        this.fSettings = settings;
        this.fWriter = this.initializeLogFile(appendTimestampToLogFileName);
        this.fFormat = DateFormat.getDateTimeInstance(3, 0);
        this.fLineSeparator = System.getProperty("line.separator");
    }

    private LeakHunterSettings getSettings() {
        return this.fSettings;
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.getSettings().getModuleFeedback();
    }

    private IStringLocalizer getStringLocalizer() {
        return this.getSettings().getStringLocalizer();
    }

    private boolean isAppendMode() {
        return this.getSettings().isAppendMode();
    }

    private String getLogFileLocation() {
        return this.getSettings().getLogFileLocation();
    }

    private PrintWriter initializeLogFile(boolean appendTimestampToLogFileName) {
        this.fBaseFilename = this.getLogFileLocation();
        String filename = this.fBaseFilename;
        if (filename != null) {
            if (appendTimestampToLogFileName) {
                try {
                    filename = LogFileUtilities.appendUniqueTimestampToLogFileName(filename);
                }
                catch (IOException ioe) {
                    this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Log_File_Unable_To_Append_Unique_Timestamp_Log_File", ioe.getMessage(), filename));
                    this.getModuleFeedback().verbose(ioe);
                }
            }
            try {
                FileOutputStream output = new FileOutputStream(filename, this.isAppendMode());
                this.fFullFilename = filename;
                if (this.isAppendMode()) {
                    this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Settings_Append_Log_File", this.fFullFilename));
                } else {
                    this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Settings_Overwrite_Log_File", this.fFullFilename));
                }
                return new PrintWriter(output, true);
            }
            catch (IOException ioe) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Log_File_Unable_To_Create_Log_File", ExtendedFile.safeGetCanonicalPath(new File(filename)), ioe.getMessage()));
                this.getModuleFeedback().verbose(ioe);
            }
        }
        return new PrintWriter(new NullOutputStream());
    }

    private PrintWriter getWriter() {
        return this.fWriter;
    }

    private String convertLineSeparators(String original) {
        return StringUtils.replace(original, "\n", this.fLineSeparator);
    }

    public synchronized void logNewPotentialLeak(String potentialLeakID, String className, String allocationMethod, long allocationTimestamp, String stackTraceAsString, String[] assignedFields, int size) {
        String unknown = this.getStringLocalizer().IStringLocalizer_getLocalizedString("LeakHunter_Log_File_Unknown_Data");
        String indentedUnknown = "\t" + unknown;
        StringBuilder fieldNames = new StringBuilder();
        if (assignedFields != null) {
            int fieldII = 0;
            while (fieldII < assignedFields.length && assignedFields[fieldII] != null) {
                fieldNames.append("\t");
                fieldNames.append(FieldRecord.getFullyQualifiedFieldName(assignedFields[fieldII]));
                fieldNames.append(this.fLineSeparator);
                ++fieldII;
            }
        }
        Date allocationDate = new Date(allocationTimestamp);
        String[] parameters = new String[]{this.fFormat.format(new Date()), potentialLeakID, className, allocationMethod == null ? unknown : allocationMethod, allocationTimestamp < 0L ? unknown : this.fFormat.format(allocationDate), stackTraceAsString == null ? indentedUnknown : stackTraceAsString, fieldNames.length() == 0 ? indentedUnknown : fieldNames.toString(), String.valueOf(size)};
        this.getWriter().println(this.convertLineSeparators(this.getStringLocalizer().IStringLocalizer_getLocalizedString("LeakHunter_Log_File_Message_Prefix")));
        this.getWriter().println(this.convertLineSeparators(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Log_File_Message_New_Potential_Leak", parameters)));
    }

    public synchronized void logNoLongerLeaking(String potentialLeakID, String className, int size) {
        this.getWriter().println(this.convertLineSeparators(this.getStringLocalizer().IStringLocalizer_getLocalizedString("LeakHunter_Log_File_Message_Prefix")));
        this.getWriter().println(this.convertLineSeparators(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Log_File_Message_No_Longer_Leaking", this.fFormat.format(new Date()), potentialLeakID, className, String.valueOf(size))));
    }

    public synchronized void logLeakingAgain(String potentialLeakID, String className, int size) {
        this.getWriter().println(this.convertLineSeparators(this.getStringLocalizer().IStringLocalizer_getLocalizedString("LeakHunter_Log_File_Message_Prefix")));
        this.getWriter().println(this.convertLineSeparators(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Log_File_Message_Leaking_Again", this.fFormat.format(new Date()), potentialLeakID, className, String.valueOf(size))));
    }

    public synchronized void logTimeout(int potentialLeakCount) {
        this.getWriter().println(this.convertLineSeparators(this.getStringLocalizer().IStringLocalizer_getLocalizedString("LeakHunter_Log_File_Message_Prefix")));
        this.getWriter().println(this.convertLineSeparators(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Log_File_Message_Timeout", this.fFormat.format(new Date()), String.valueOf(potentialLeakCount))));
    }

    @Override
    public synchronized void INameChangeListener_nameChanged(String newAgentName) {
        if (this.fBaseFilename != null && this.fFullFilename != null) {
            int len = newAgentName.length() + this.fBaseFilename.length();
            if (len > 253) {
                newAgentName = newAgentName.substring(0, newAgentName.length() - (len - 253));
                this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Log_File_Renaming_Truncated", newAgentName));
            }
            String newFilename = LogFileUtilities.appendIdentifierToLogFileName(this.fBaseFilename, newAgentName);
            this.tearDown();
            boolean success = LogFileUtilities.renameLogFile(this.fFullFilename, newFilename, this.isAppendMode(), 262144);
            FileOutputStream output = null;
            if (success) {
                try {
                    output = new FileOutputStream(newFilename, true);
                }
                catch (FileNotFoundException fnfe) {
                    success = false;
                    this.getModuleFeedback().verbose(fnfe);
                }
            }
            if (success) {
                this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Log_File_Renamed", this.fFullFilename, newFilename));
                this.fFullFilename = newFilename;
                this.fWriter = new PrintWriter(output, true);
            } else {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Log_File_Renaming_Failed", this.fFullFilename, newFilename));
                try {
                    output = new FileOutputStream(this.fFullFilename, true);
                    this.fWriter = new PrintWriter(output, true);
                }
                catch (FileNotFoundException fnfe) {
                    this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Log_File_Unable_To_Open_Log_File", this.fFullFilename, fnfe.getLocalizedMessage()));
                    this.getModuleFeedback().verbose(fnfe);
                    this.fWriter = new PrintWriter(new NullOutputStream());
                }
            }
        }
    }

    public synchronized void tearDown() {
        this.fWriter.flush();
        this.fWriter.close();
    }
}

