/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.leakhunter;

import com.wily.introscope.agent.leakhunter.IPotentialLeakDetector;
import com.wily.introscope.agent.leakhunter.LeakHunterSettings;

final class NNewHighsPotentialLeakDetector
implements IPotentialLeakDetector {
    private static final byte[] kSensitivityToNumHighsMapping = new byte[]{10, 9, 8, 7, 6, 5, 5, 4, 4, 3};
    private static final double[] kSensitivityToGrowthFactorMapping = new double[]{2.0, 1.8, 1.6, 1.4, 1.2, 1.15, 1.15, 1.1, 1.1, 1.05};
    private final byte fLeakSensitivity;
    private int fNextNewHigh;
    private int fCurrentHigh;
    private byte fNumHighs;
    private boolean fIsALeak;
    private short fNumChecksForLastIncrease;
    private short fNumChecksSinceLastIncrease;
    private short fNumChecksSinceExceededCurrentHigh;

    public NNewHighsPotentialLeakDetector(LeakHunterSettings settings) {
        this.fLeakSensitivity = (byte)(settings.getLeakSensitivity() - 1);
    }

    @Override
    public boolean IPotentialLeakDetector_hasLeak(long nowInMillis, int size, Object trackedObject) {
        this.updateTrackingState(size);
        this.checkForNewHigh();
        this.updateCurrentLeakState();
        return this.isALeak();
    }

    private boolean isALeak() {
        return this.fIsALeak;
    }

    private void updateTrackingState(int size) {
        if (this.fNumChecksSinceLastIncrease < Short.MAX_VALUE) {
            this.fNumChecksSinceLastIncrease = (short)(this.fNumChecksSinceLastIncrease + 1);
        }
        if (size > this.fCurrentHigh) {
            this.fCurrentHigh = size;
            this.fNumChecksSinceExceededCurrentHigh = 0;
        } else if (this.fNumChecksSinceExceededCurrentHigh < Short.MAX_VALUE) {
            this.fNumChecksSinceExceededCurrentHigh = (short)(this.fNumChecksSinceExceededCurrentHigh + 1);
        }
    }

    private void checkForNewHigh() {
        if (this.fCurrentHigh > this.fNextNewHigh) {
            this.fNextNewHigh = (int)((double)this.fCurrentHigh * kSensitivityToGrowthFactorMapping[this.fLeakSensitivity]);
            if (this.fNumHighs < 127) {
                this.fNumHighs = (byte)(this.fNumHighs + 1);
            }
            this.fNumChecksForLastIncrease = this.fNumChecksSinceLastIncrease;
            this.fNumChecksSinceLastIncrease = 0;
        }
    }

    private void updateCurrentLeakState() {
        this.fIsALeak = this.fNumHighs >= kSensitivityToNumHighsMapping[this.fLeakSensitivity] && this.fNumChecksSinceExceededCurrentHigh < this.fNumChecksForLastIncrease;
    }
}

