/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.sysview.httptracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.sysview.httptracer.WSClientCorrelationTracer;
import com.wily.powerpack.sysview.httptracer.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.net.URL;

public class URLConnectionCorrelationTracer
extends WSClientCorrelationTracer {
    private static final String kLaunchSessionSysviewCommunicationMethod = "LaunchSessionSysviewCommunicationMethod";
    private static final String kCommunicationMethod = "Communication Method";
    private static final String kCommunicationMethodHTTPValue = "HTTP";
    private static final String kLaunchSessionWithAgentsKey = "LaunchSessionWithAgents";
    private static final String kLaunchSessionWithAgentsValue = ".*";
    private static final String kNamespaceKey = "com.wily.powerpack.webservices.trace.NamespaceKey";
    private static final String kLaunchSessionSysviewTime = "LaunchSessionSysviewTime";

    public URLConnectionCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
    }

    @Override
    public void ITracer_finishTrace(int index, InvocationData data) {
        try {
            IModuleFeedbackChannel Logger = WSMUtils.getLogger();
            Logger.debug("In URLConnectionCorrelationTracer");
            ComponentTracer componentTracer = this.getComponentTracer();
            Object httpCon = data.getInvocationObject();
            String corIdStr = (String)WSMUtils.invokeMethodOnObject(httpCon, "getRequestProperty", new Class[]{String.class}, new Object[]{"CorID"});
            if (corIdStr == null || corIdStr.equals("")) {
                CorrelationId correlationId = new CorrelationId();
                corIdStr = correlationId.getOutgoingCorrelationIdStrippedForHeader();
                if (Logger.isDebugEnabled()) {
                    Logger.debug("URLConnectionCorrelationTracer has Correlation ID:" + corIdStr);
                }
                WSMUtils.invokeMethodOnObject(httpCon, "setRequestProperty", new Class[]{String.class, String.class}, new Object[]{"CorID", corIdStr});
            } else if (Logger.isDebugEnabled()) {
                Logger.debug("URLConnectionCorrelationTracer found Corrleation ID in HTTP header:" + corIdStr);
            }
            try {
                URL url = (URL)WSMUtils.invokeMethodOnObject(httpCon, "getURL");
                componentTracer.addExtraParameter("URL", url.getPath());
            }
            catch (Throwable t) {
                Logger.error("URLConnectionCorrelationTracer ITracer_finishTrace exception " + WSMUtils.dumpStackTrace(t));
            }
            try {
                componentTracer.addExtraParameter(kLaunchSessionSysviewCommunicationMethod, kCommunicationMethodHTTPValue);
                componentTracer.addExtraParameter(kCommunicationMethod, kCommunicationMethodHTTPValue);
                componentTracer.addExtraParameter(kLaunchSessionWithAgentsKey, kLaunchSessionWithAgentsValue);
            }
            catch (Throwable t) {
                Logger.error("URLConnectionCorrelationTracer ITracer_finishTrace exception " + WSMUtils.dumpStackTrace(t));
            }
        }
        catch (Throwable t) {
            try {
                WSMUtils.getLogger().error("URLConnectionCorrelationTracer ITracer_finishTrace exception " + WSMUtils.dumpStackTrace(t));
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.calculateReentrancyLevel(ReentrancyLevel.kNone);
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

