/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.spec.ds.classmonitor;

import com.wily.rave.spec.Digest;
import com.wily.rave.spec.IContentMetadataItem;
import com.wily.rave.spec.IContentSummary;
import com.wily.rave.spec.IDataSourceInstance;
import com.wily.rave.spec.SimpleContentMetadataItem;
import com.wily.rave.spec.ds.classmonitor.ClassContentSummary;
import com.wily.rave.utils.HashCodeUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DotnetClassContentSummary
extends ClassContentSummary
implements IContentSummary,
Externalizable {
    static final String CLASS_DIGEST = "Class Digest";
    static final String CURRENT_SIZE = "Class Size";
    private static final IContentMetadataItem[] EMPTY_CONTENT_METADATA_ARRAY = new IContentMetadataItem[0];
    private static final long serialVersionUID = 1L;
    private String className;
    private IDataSourceInstance dsInstance;
    private long size;
    private Digest digest;
    private transient IContentMetadataItem[] metadataContent;
    private String assemblyPath = null;
    private String assemblyVersion = null;

    public DotnetClassContentSummary() {
    }

    public DotnetClassContentSummary(String className, long size, byte[] digest, IDataSourceInstance dsInstance) {
        this.className = className;
        this.dsInstance = dsInstance;
        this.size = size;
        this.digest = new Digest(digest);
    }

    public DotnetClassContentSummary(String assemblyPath, String version, String className2, long size2, byte[] digest2, IDataSourceInstance dsInstance2) {
        this.className = className2;
        this.dsInstance = dsInstance2;
        this.size = size2;
        this.digest = new Digest(digest2);
        this.assemblyPath = assemblyPath;
        this.assemblyVersion = version;
    }

    @Override
    public long getChangeTimestamp() {
        return -1L;
    }

    @Override
    public String getResourceName() {
        String strFullName = this.className;
        return strFullName;
    }

    @Override
    public boolean hasMetadata() {
        return true;
    }

    @Override
    public String getDigestString() {
        return this.digest.toString();
    }

    @Override
    public IContentMetadataItem[] getMetadata() {
        if (this.metadataContent == null) {
            if (this.size < 0L) {
                this.metadataContent = EMPTY_CONTENT_METADATA_ARRAY;
            } else {
                this.metadataContent = new IContentMetadataItem[2];
                this.metadataContent[1] = new SimpleContentMetadataItem(CURRENT_SIZE, Long.toString(this.size));
                this.metadataContent[0] = new SimpleContentMetadataItem(CLASS_DIGEST, this.digest.toString());
            }
        }
        return this.metadataContent;
    }

    @Override
    public IDataSourceInstance getDataSourceInstance() {
        return this.dsInstance;
    }

    @Override
    public byte[] getDigest() {
        return this.digest.getBytes();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.assemblyPath);
        out.writeUTF(this.assemblyVersion);
        out.writeUTF(this.className);
        out.writeLong(1L);
        out.writeObject(this.dsInstance);
        out.writeObject(this.digest);
        out.writeLong(this.size);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.assemblyPath = in.readUTF();
        this.assemblyVersion = in.readUTF();
        this.className = in.readUTF();
        long oiLong = in.readLong();
        Long object = new Long(oiLong);
        if (object instanceof Long) {
            long serialUID = object;
            if (serialUID != 1L) {
                throw new ClassNotFoundException("Unknown serialVersionUID for ClassContentSummary: " + serialUID);
            }
            this.dsInstance = (IDataSourceInstance)in.readObject();
        } else if (object instanceof IDataSourceInstance) {
            this.dsInstance = (IDataSourceInstance)((Object)object);
        }
        this.digest = (Digest)in.readObject();
        this.size = in.readLong();
    }

    @Override
    public int hashCode() {
        int code = HashCodeUtils.accumulateHashCode(this.dsInstance.hashCode(), this.className);
        code = HashCodeUtils.accumulateHashCode(code, this.size);
        code = HashCodeUtils.accumulateHashCode(code, this.assemblyPath);
        return code;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DotnetClassContentSummary) {
            DotnetClassContentSummary otherClassContentSummary = (DotnetClassContentSummary)other;
            boolean result = true;
            if (this.assemblyPath != null) {
                result = this.assemblyPath.equals(otherClassContentSummary.assemblyPath);
            }
            if (result) {
                result = this.className.equals(otherClassContentSummary.className) && this.dsInstance.equals(otherClassContentSummary.dsInstance) && this.size == otherClassContentSummary.size && this.digest.equals(otherClassContentSummary.digest);
            }
            return result;
        }
        return false;
    }

    @Override
    public String getAssemblyPath() {
        return this.assemblyPath;
    }

    @Override
    public String getAssemblyVersion() {
        return this.assemblyVersion;
    }
}

