/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FastMD5Encoder {
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();
    private static final int BUFFER_SIZE = 65536;
    private static FastMD5Encoder sharedInstance;
    private final MessageDigest md5Java;

    private FastMD5Encoder() {
        try {
            this.md5Java = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to find MD5 provider. Exception: " + e.getMessage(), e);
        }
    }

    public static synchronized FastMD5Encoder getInstance() {
        if (sharedInstance == null) {
            sharedInstance = new FastMD5Encoder();
        }
        return sharedInstance;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] str = new char[bytes.length * 2];
        int i = 0;
        while (i != bytes.length) {
            byte b = bytes[i];
            str[i * 2] = HEX_ARRAY[b >>> 4 & 0xF];
            str[i * 2 + 1] = HEX_ARRAY[b & 0xF];
            ++i;
        }
        return new String(str);
    }

    public synchronized byte[] encode(byte[] data) {
        this.md5Java.reset();
        this.md5Java.update(data);
        return this.md5Java.digest();
    }

    public String encode(String data) {
        return FastMD5Encoder.bytesToHex(this.encode(data.getBytes()));
    }

    public byte[] encode(File f) throws IOException {
        FileInputStream fis = null;
        FilterInputStream dis = null;
        try {
            fis = new FileInputStream(f);
            dis = new DigestInputStream(fis, this.md5Java);
            byte[] buf = new byte[(int)Math.min(65536L, f.length())];
            while (dis.read(buf) != -1) {
            }
            byte[] byArray = this.md5Java.digest();
            return byArray;
        }
        finally {
            if (dis != null) {
                dis.close();
            } else if (fis != null) {
                fis.close();
            }
        }
    }
}

