/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent.trace;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.appmap.agent.AppDef;
import com.wily.introscope.appmap.agent.trace.AbstractStackBasedNameHelper;
import com.wily.introscope.appmap.agent.trace.AppMapApplicationCrossProcessHelper;
import com.wily.introscope.appmap.agent.trace.ICallbackOnLazyPushOwnerName;
import com.wily.introscope.spec.server.appmap.IAppMapOwner;
import java.util.List;
import java.util.Stack;

public class ApplicationNameHelper
extends AbstractStackBasedNameHelper {
    private static final ApplicationNameHelper kInstance = new ApplicationNameHelper();
    private static ThreadLocal fApplicationNameStack = new ThreadLocal(){

        protected Object initialValue() {
            return new Stack();
        }
    };

    private ApplicationNameHelper() {
        AppMapApplicationCrossProcessHelper.getInstance();
    }

    public static ApplicationNameHelper getInstance() {
        return kInstance;
    }

    @Override
    protected Stack getThreadLocalOwnerNameStack() {
        Stack currentApplicationNameStack = (Stack)fApplicationNameStack.get();
        return currentApplicationNameStack;
    }

    @Override
    protected void setOwnerNameInCrossProcess(SharedCrossProcessData cache, IAppMapOwner owner) {
        AppMapApplicationCrossProcessHelper.getInstance().setCalledProcessOwners(cache, this.getThreadLocalOwnerNameStack());
    }

    @Override
    protected List getOwnerNamesInCrossProcess(SharedCrossProcessData cache) {
        return AppMapApplicationCrossProcessHelper.getInstance().getCallingProcessOwners(cache);
    }

    @Override
    protected IAppMapOwner getLastRemoteOwnerInCrossProcess(SharedCrossProcessData cache) {
        List ownerlist = AppMapApplicationCrossProcessHelper.getInstance().getCallingProcessOwners(cache);
        if (ownerlist != null && !ownerlist.isEmpty()) {
            return (IAppMapOwner)ownerlist.get(ownerlist.size() - 1);
        }
        return null;
    }

    @Override
    public IAppMapOwner getNullOwner() {
        return AppDef.getNullInstance();
    }

    @Override
    public IAppMapOwner getOwnerFromData(String name, InvocationData data, boolean isStartTrace) {
        return AppDef.getInstance(name);
    }

    @Override
    public void pushCurrentOwnerNameForCrossProcess(SharedCrossProcessData cache, IAppMapOwner ownerName) {
        AppMapApplicationCrossProcessHelper.getInstance().setCalledProcessOwnersStringOnly(cache, ownerName.getName());
    }

    @Override
    public void popCurrentOwnerNameForCrossProcess(SharedCrossProcessData cache, IAppMapOwner ownerName) {
        AppMapApplicationCrossProcessHelper.getInstance().removeCalledProcessOwnersStringOnly(cache, ownerName.getName());
    }

    @Override
    public void popCurrentOwnerNameForCrossProcess(SharedCrossProcessData cache, String ownerName) {
        AppMapApplicationCrossProcessHelper.getInstance().removeCalledProcessOwnersStringOnly(cache, ownerName);
    }

    @Override
    public void lazyPushCurrentOwnerNameForCrossProcess(SharedCrossProcessData cache, ICallbackOnLazyPushOwnerName callback) {
        AppMapApplicationCrossProcessHelper.getInstance().setCalledProcessOwnersStringOnlyIfEmpty(cache, callback);
    }

    @Override
    public boolean reset() {
        this.getThreadLocalOwnerNameStack().clear();
        return true;
    }
}

