/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.connection;

import com.ca.apm.connection.WaitDelayStrategy;

public class ExponentialMaxDelayStrategy
implements WaitDelayStrategy {
    private final int initialReconnectDelayInSeconds;
    private final int maxReconnectDelayInSeconds;
    private long delayInMillis;
    private final long maxDelayInMillis;

    public ExponentialMaxDelayStrategy(int initialReconnectDelayInSeconds, int maxReconnectDelayInSeconds) {
        this.initialReconnectDelayInSeconds = initialReconnectDelayInSeconds;
        this.maxReconnectDelayInSeconds = maxReconnectDelayInSeconds;
        this.delayInMillis = this.initialReconnectDelayInSeconds * 1000;
        this.maxDelayInMillis = this.maxReconnectDelayInSeconds * 1000;
    }

    @Override
    public long getNextDelayInMillis() {
        this.delayInMillis *= 2L;
        this.delayInMillis = this.delayInMillis > this.maxDelayInMillis ? this.maxDelayInMillis : this.delayInMillis;
        return this.delayInMillis;
    }

    @Override
    public void resetDelay() {
        this.delayInMillis = this.initialReconnectDelayInSeconds * 1000;
    }
}

