/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.clamp;

import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.Module;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class GenericClamp {
    protected AtomicInteger metricCounter;
    protected boolean hasWarned = false;
    protected IAgent agent;
    protected Module module = new Module("Clamp");

    public GenericClamp(IAgent agent) {
        this.metricCounter = new AtomicInteger();
        this.agent = agent;
    }

    public void printClampWarning(String warningMessage) {
        if (!this.hasWarned) {
            this.log(warningMessage, 'w');
            this.hasWarned = true;
        }
    }

    public void incrementMetricCounter() {
        this.metricCounter.incrementAndGet();
        this.log("metric count: " + this.metricCounter.get(), 't');
    }

    protected void log(String message, char level) {
        switch (level) {
            case 'e': {
                this.agent.IAgent_getModuleFeedback().error(this.module, message);
                break;
            }
            case 'w': {
                this.agent.IAgent_getModuleFeedback().warn(this.module, message);
                break;
            }
            case 'i': {
                this.agent.IAgent_getModuleFeedback().info(this.module, message);
                break;
            }
            case 'd': {
                this.agent.IAgent_getModuleFeedback().debug(this.module, message);
                break;
            }
            case 't': {
                this.agent.IAgent_getModuleFeedback().trace(this.module, message);
                break;
            }
            default: {
                this.agent.IAgent_getModuleFeedback().info(this.module, message);
            }
        }
    }

    protected abstract boolean isClampHit();

    protected abstract boolean isClampValueValid(int var1);

    protected abstract void initializeClamp();
}

