# Configuration
The `bundle.profile`, JSON file configured in bundle.profile, `IntroscopeAgent.profile` contains the configuration of the Automatic Attribute Decoration extension. Configure the required properties from ACC or in the configuration file.

The bundle.profile contains a below property to configure the JSON file name
## JSON file configuration
 It Specifies the path to the Attribute Decoration Extension Configuration File 
 
    attribute.decoration.jsonFileName.configuration=<JSON file name>


	
Json file configuration will have Environment Variables, System Variables, Static Attributes, Sentinel File, Application Attributes, Manifest File configuration as below.
 
## Environment Variables Configuration
If you add an environment variable configuration, your components from this agent will have that attribute added to the component as "env."+&lt;environment variable name&gt; with the current value of that environment variable available to the agent.

	"environmentProperties": ["JAVA_HOME","TEMP"]

## System Variables Configuration
If you add system variables, your components from this agent will have that attribute added to the component as "sys."+&lt;system property name&gt; with the current value of that system property available to the agent.

	"systemProperties": ["os.name","os.version"]

## Static Attribute Configuration
Any entry of the form {"attributeName":"name","value":"val"} will produce an attribute &lt;name&gt;=&lt;val&gt; with the prefix "usr."

 	"staticAttributeConfiguration":[{"attributeName":"name","value":"val"},{"attributeName":"name2","value":"val2"}]

## External File Configuration
You can specify external files to retrieve attributes from. They are dynamically reloaded. The example configuration is:

    "externalFileConfiguration":[{"fileName":"/attributes.txt","prefix":"file","delimiter":":","includePrefix":"","excludePrefix":"","includeSuffix":"","excludeSuffix":""}]
	

where:


- - `fileName` is the full path/ relative path from WILY_HOME/core/config/ folder to the file you want to read. The user under which the application server and the java process are running must have read permissions for that file. 
- `attribute prefix` will be added to the attributes that are read from the file.
- `delimiter` is "=" or ":" and will split name/value using this delimiter.
- `includePrefix` is a string which will eliminate all entries from the file that do not start with this value. Empty = all entries included.
- `excludePrefix` is a string which will eliminate all entries from this file that do start with this value. Empty = no entries excluded.
- `includeSuffix` is a string which will eliminate all entries from the file that do not end with this value. Empty = all entries included.
- `excludeSuffix` is a string which will eliminate all entries from the file that do end with this value. Empty = no entries excluded.


## Sentinel File Configuration
It specifies external files that indicate that an attribute should be set. It is dynamically reloaded. An example configuration is:

    "sentinelFileConfiguration":[{"attributeName":"sentinel-file","fileName":"/.sentinel.file","valueIfFound":"true","valueIfNotFound":"false","setValueIfNotFound":"false"}]

where
- `attributeName` is the name of the attribute to set.
- `fileName` is the file path/relative file path from WILY_HOME/core/config/ folder whose presence we want to detect.
- `valueIfFound` is the value of the attribute if the file is found.
- `valueIfNotFound` is the value of the attribute if the file is not found.
- `setValueIfNotFound` is used to suppress the attribute if the file is not found.

## Application Attributes Configuration
It specifies attributes to be added for given application Name. These attributes will be added to all called components of a given application name. It is dynamically reloaded. An example configuration is:
  
  	"applicationConfiguration":[{"applicationName":"sampleAppliction","attributeName":"sample","value":"test"}]

where
- `applicationName` is the name of the application.
- `attributeName` is the name of the attribute to set.
- `value` is the value of the attribute.
    

## Manifest File Configuration
This specifies the pathname of an application war file/relative file path from WILY_HOME/core/config/ folder that will contain web applications deployed on application server that an attribute should be set. It reads the application's war file and adds the attributes. These attributes contains information such as Implementation-Version, Build-Jdk, etc. An example configuration is:

    "manifestFileConfiguration":[{"applicationName":"sampleAppliction", "fileName":"/apache-tomcat-6.0.48/webapps/sampleApplication.war"}]
    

### Note
- These are JSON properties, file path doesn't allow single backward slash  '\\' , make sure to escape it as '\\\\'. Environment, System, Static, External,Sentinel attributes will be added in the APM Infrastructure Layer and Application, Manifest attributes will be added in the Application Layer.
- All JSON file properties are cold.
