/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.correlation.logger.substituter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.correlation.logger.LogCorrelationConstants;
import com.wily.introscope.agent.correlation.logger.tracer.LogCorrelationTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogParamSubstituter {
    private static final Module kModule = LogCorrelationConstants.kModule;
    private static IModuleFeedbackChannel fFeedback;
    private static volatile List<InsertPattern> insertPatterns;
    private static volatile boolean isInitialized;

    public static void initialize(IAgent agent) {
        if (isInitialized) {
            return;
        }
        fFeedback = agent.IAgent_getModuleFeedback();
        fFeedback.info(kModule, "LogParamSubstituter created.");
        ArrayList<InsertPattern> patterns = new ArrayList<InsertPattern>();
        IndexedProperties props = agent.IAgent_getIndexedProperties();
        String patternNames = props.getProperty("com.ca.apm.log.correlation.substituter.patterns");
        if (patternNames != null) {
            String[] names;
            for (String name : names = patternNames.split(",")) {
                name = name.trim();
                InsertPattern entry = new InsertPattern();
                entry.name = name;
                entry.pattern = props.getProperty("com.ca.apm.log.correlation.substituter." + name + ".pattern");
                entry.regex = null;
                entry.type = InsertPattern.PatternType.Simple;
                String type = props.getProperty("com.ca.apm.log.correlation.substituter." + name + ".type");
                if ("regex".equals(type)) {
                    entry.type = InsertPattern.PatternType.Regex;
                    entry.regex = Pattern.compile(entry.pattern);
                }
                entry.index = props.getIntProperty("com.ca.apm.log.correlation.substituter." + name + ".index", 0);
                entry.prefix = props.getProperty("com.ca.apm.log.correlation.substituter." + name + ".prefix");
                entry.suffix = props.getProperty("com.ca.apm.log.correlation.substituter." + name + ".suffix");
                patterns.add(entry);
            }
        }
        insertPatterns = patterns;
        isInitialized = true;
    }

    private static InsertPattern findMatch(String text) {
        for (InsertPattern p : insertPatterns) {
            Matcher m;
            if (p.type == InsertPattern.PatternType.Regex && (m = p.regex.matcher(text)).find()) {
                return p;
            }
            if (p.pattern == null) {
                return p;
            }
            if (!text.contains(p.pattern)) continue;
            return p;
        }
        return null;
    }

    private static String inserCorid(InsertPattern p, String text, String corid) {
        StringBuilder newText = new StringBuilder();
        if (p.index == -1) {
            newText.append(text);
        }
        if (p.index > 0 && p.index < text.length()) {
            newText.append(text.substring(0, p.index));
        }
        if (p.prefix != null) {
            newText.append(p.prefix);
        }
        newText.append(corid);
        if (p.suffix != null) {
            newText.append(p.suffix);
        }
        if (p.index == 0) {
            newText.append(text);
        }
        if (p.index > 0 && p.index < text.length()) {
            newText.append(text.substring(p.index));
        }
        return newText.toString();
    }

    public static Object substituteResult(Object invokedObject, Object origObject) {
        String corid;
        if (!isInitialized) {
            return origObject;
        }
        if (!LogCorrelationTracer.isLoggerCorrelationEnabled()) {
            return origObject;
        }
        if (origObject instanceof String && (corid = LogCorrelationTracer.getCorrelationId()) != null) {
            String text = (String)origObject;
            InsertPattern p = LogParamSubstituter.findMatch(text);
            if (p == null) {
                return origObject;
            }
            String newText = LogParamSubstituter.inserCorid(p, text, corid);
            return newText;
        }
        return origObject;
    }

    static {
        insertPatterns = null;
        isInitialized = false;
    }

    static class InsertPattern {
        public String name;
        public String pattern;
        public Pattern regex;
        public PatternType type;
        public int index;
        public String prefix;
        public String suffix;

        InsertPattern() {
        }

        public static enum PatternType {
            Simple,
            Regex;

        }
    }
}

