/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.correlation.logger.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.correlation.logger.tracer.MdcPatternTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;

public class LogBackMdcPatternTracer
extends MdcPatternTracer {
    public LogBackMdcPatternTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
    }

    private Field findPrivateField(Class cl, String name) {
        Field result = null;
        while (result == null && cl != null) {
            try {
                result = cl.getDeclaredField(name);
            }
            catch (SecurityException e) {
                feedback.warn(sModule, "Failed to access log pattern", (Throwable)e);
                cl = cl.getSuperclass();
            }
            catch (NoSuchFieldException e) {
                cl = cl.getSuperclass();
            }
        }
        return result;
    }

    @Override
    public void ITracer_finishTrace(int index, InvocationData data) {
        try {
            Object obj = data.getInvocationObject();
            Class<?> clazz = obj.getClass();
            feedback.info(sModule, "Called class " + clazz.getCanonicalName());
            Field patternField = this.findPrivateField(clazz, "pattern");
            if (patternField == null) {
                feedback.warn(sModule, "Failed to find log pattern");
                return;
            }
            patternField.setAccessible(true);
            String newPattern = this.hackPattern(data.getInvocationParameterAsObject(0));
            if (newPattern != null) {
                patternField.set(obj, newPattern);
            }
        }
        catch (SecurityException e) {
            feedback.warn(sModule, "Failed to access log pattern", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            feedback.warn(sModule, "Failed to set log pattern", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            feedback.warn(sModule, "Failed to set log pattern", (Throwable)e);
        }
    }
}

