/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.correlation.logger.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.correlation.logger.LogCorrelationConstants;
import com.wily.introscope.agent.correlation.logger.substituter.LogParamSubstituter;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.ThreadCorrelationId;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import com.wily.util.properties.IndexedProperties;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LogCorrelationTracer
extends ASingleInstanceTracerFactory {
    private IAgent agent = null;
    private ReentrancyLevel fReEntryLeveL = this.calculateReentrancyLevel(ReentrancyLevel.kInstance);
    private static Module sModule = LogCorrelationConstants.kModule;
    private final IModuleFeedbackChannel feedback;
    private static final ThreadLocal<String> loggerCorrId = new ThreadLocal<String>(){};
    private static boolean isLogbackMdcCorrelationEnabled = false;
    private static boolean isLoggerCorrelationEnabled = false;
    private static volatile boolean initialized = false;
    private Method putMDCmethod = null;

    public LogCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.agent = agent;
        this.feedback = agent.IAgent_getModuleFeedback();
        if (initialized) {
            return;
        }
        LogParamSubstituter.initialize(agent);
        IndexedProperties props = agent.IAgent_getIndexedProperties();
        isLoggerCorrelationEnabled = props.getBooleanProperty("com.ca.apm.log.correlation.enable", false);
        isLogbackMdcCorrelationEnabled = props.getBooleanProperty("com.ca.apm.log.correlation.mdc.enable", false);
        if (isLogbackMdcCorrelationEnabled) {
            try {
                Class<?> clazz = Class.forName("org.slf4j.MDC", false, sample.getClass().getClassLoader());
                this.putMDCmethod = clazz.getMethod("put", String.class, String.class);
            }
            catch (ClassNotFoundException e) {
                this.feedback.warn(sModule, "Failed to load Managed Diagnostic Context: " + e.getMessage());
            }
            catch (SecurityException e) {
                this.feedback.warn(sModule, "Failed to load Managed Diagnostic Context " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                this.feedback.warn(sModule, "Failed to load Managed Diagnostic Context " + e.getMessage());
            }
        }
        initialized = true;
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        ThreadCorrelationId tid = new ThreadCorrelationId();
        SharedCrossProcessData cdata = tid.getOutgoingNonSerializedCrossProcessData();
        String corid = cdata.getCorrelationID();
        loggerCorrId.set(corid);
        if (this.putMDCmethod != null) {
            try {
                this.putMDCmethod.invoke(null, "wilycorid", corid);
            }
            catch (IllegalArgumentException e) {
                this.feedback.warn(sModule, "Failed to put Managed Diagnostic Context", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.feedback.warn(sModule, "Failed to put Managed Diagnostic Context", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.feedback.warn(sModule, "Failed to put Managed Diagnostic Context", (Throwable)e);
            }
        }
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
    }

    public static String getCorrelationId() {
        return loggerCorrId.get();
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReEntryLeveL;
    }

    public boolean ITracerFactory_isShutoff() {
        return !isLoggerCorrelationEnabled;
    }

    public static boolean isLoggerCorrelationEnabled() {
        return isLoggerCorrelationEnabled;
    }
}

