/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.correlation.logger.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.correlation.logger.LogCorrelationConstants;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogExplorationTracer
extends ASingleInstanceTracerFactory {
    private static final int MAX_PARAM_LEN = 64;
    private ReentrancyLevel fReEntryLeveL = this.calculateReentrancyLevel(ReentrancyLevel.kInstance);
    private static Module sModule = LogCorrelationConstants.kModule;
    private final IModuleFeedbackChannel feedback;
    private final String instrumentationPoint;
    private final String probeClass;
    private final IAgent agent;
    private final Pattern searchPattern;
    private final ConcurrentHashMap<String, Boolean> runTimeClassCache = new ConcurrentHashMap();

    public LogExplorationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.agent = agent;
        this.feedback = agent.IAgent_getModuleFeedback();
        this.probeClass = probeIdentification.getProbeClassName();
        this.instrumentationPoint = probeIdentification.getProbeClassName() + " " + probeIdentification.getProbeMethodName() + probeIdentification.getProbeMethodDescriptor();
        String pattern = attributeListing.get("name");
        this.searchPattern = pattern == null || ".*".equals(pattern) ? null : Pattern.compile(pattern);
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        Boolean there;
        StringBuilder argString = new StringBuilder("(");
        boolean matches = this.searchPattern == null;
        for (int i = 0; i < data.getInvocationParameterCount(); ++i) {
            Object arg = data.getInvocationParameterAsObject(i);
            if (i > 0) {
                argString.append(", ");
            }
            if (arg != null) {
                Matcher m;
                String str = arg.toString();
                if (arg instanceof String) {
                    argString.append("\"");
                }
                if (this.searchPattern != null && (m = this.searchPattern.matcher(str)).find()) {
                    matches = true;
                }
                if (str.length() > 64) {
                    argString.append(str.substring(0, 64));
                    argString.append("...");
                } else {
                    argString.append(str);
                }
                if (!(arg instanceof String)) continue;
                argString.append("\"");
                continue;
            }
            argString.append("null");
        }
        argString.append(")");
        if (!matches) {
            return;
        }
        String runtimeClass = null;
        Class<?> clazz = null;
        Object obj = data.getInvocationObject();
        if (obj != null) {
            clazz = obj.getClass();
        }
        if (clazz != null && (there = this.runTimeClassCache.putIfAbsent(runtimeClass = clazz.getName(), true)) == null) {
            this.dumpClassInfo(this.agent, data);
        }
        if (runtimeClass == null) {
            this.feedback.debug(sModule, "static" + this.instrumentationPoint + " " + argString.toString());
        } else if (this.probeClass.equals(runtimeClass)) {
            this.feedback.debug(sModule, this.instrumentationPoint + " " + argString.toString());
        } else {
            this.feedback.debug(sModule, runtimeClass + "->" + this.instrumentationPoint + " " + argString.toString());
        }
    }

    public void ITracer_finishTrace(int arg0, InvocationData arg1) {
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReEntryLeveL;
    }

    synchronized void dumpClassInfo(IAgent agent, InvocationData data) {
        Object obj = data.getInvocationObject();
        Class<?> className = data.getInvocationObject().getClass();
        ClassLoader cl = className.getClassLoader();
        String cName = className.getName();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(cName, false, cl);
            if (clazz != null) {
                this.feedback.debug("clazz is " + clazz.getName());
            } else {
                if (cl != null) {
                    this.feedback.debug("clazz is null and cannot be loaded by " + cl.toString());
                }
                clazz = Class.forName(cName, false, cl.getParent());
            }
            if (clazz == null) {
                if (cl != null && cl.getParent() != null) {
                    this.feedback.debug("clazz is still null and cannot be loaded by " + cl.getParent().toString());
                }
                clazz = Class.forName(cName, false, ClassLoader.getSystemClassLoader());
            }
            if (clazz == null) {
                this.feedback.debug("clazz is still null and cannot be loaded by the System CL either: " + ClassLoader.getSystemClassLoader().toString());
            }
        }
        catch (ClassNotFoundException e) {
            this.feedback.error((Throwable)e);
        }
        catch (Throwable t) {
            this.feedback.error(t);
        }
        if (obj != null && clazz != null) {
            Class<?> superClass;
            this.feedback.debug(sModule, "Runtime Class: " + className + "(" + clazz.getName() + ")");
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces != null && interfaces.length > 0) {
                for (int i = 0; i < interfaces.length; ++i) {
                    String interfaceName = interfaces[i].getName();
                    this.feedback.debug(sModule, "Implements: " + interfaceName);
                }
            }
            if ((superClass = clazz.getSuperclass()) != null) {
                this.feedback.debug(sModule, "Extends: " + superClass.getName());
            }
        }
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

