/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.correlation.logger.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.correlation.logger.LogCorrelationConstants;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import com.wily.util.properties.IndexedProperties;

public class MdcPatternTracer
extends ASingleInstanceTracerFactory {
    private static String wilyCorIdInsertPattern = "%X{wilycorid}";
    private static String wilyCorIdPattern;
    private static boolean mdcAutoInsertEnabled;
    private static volatile boolean initialized;
    private ReentrancyLevel fReEntryLeveL = this.calculateReentrancyLevel(ReentrancyLevel.kInstance);
    private static String wilyCorIdMdcKey;
    protected static Module sModule;
    protected static IModuleFeedbackChannel feedback;
    private static String DEFAULT_INSERT_BEFORE_PATTERN;
    private static String[] insertBeforePatternArr;

    public static void initialize(IAgent agent) {
        if (!initialized) {
            feedback = agent.IAgent_getModuleFeedback();
            IndexedProperties props = agent.IAgent_getIndexedProperties();
            mdcAutoInsertEnabled = props.getBooleanProperty("com.ca.apm.log.correlation.mdc.autoinsert", false) && props.getBooleanProperty("com.ca.apm.log.correlation.mdc.enable", false) && props.getBooleanProperty("com.ca.apm.log.correlation.enable", false);
            MdcPatternTracer.initializePatternHelper(props);
            wilyCorIdMdcKey = props.getProperty("com.ca.apm.log.correlation.mdc.key", wilyCorIdMdcKey);
            String prefix = props.getProperty("com.ca.apm.log.correlation.mdc.insert.prefix", "");
            String suffix = props.getProperty("com.ca.apm.log.correlation.mdc.insert.suffix", "");
            wilyCorIdPattern = "%X{" + wilyCorIdMdcKey + "}";
            wilyCorIdInsertPattern = prefix + wilyCorIdPattern + suffix;
            initialized = true;
        }
    }

    public MdcPatternTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        MdcPatternTracer.initialize(agent);
    }

    protected String hackPattern(Object o) {
        if (o instanceof String) {
            String origPattern = (String)o;
            feedback.info(sModule, "PatternLayoutBase pattern set: " + origPattern);
            if (origPattern.contains(wilyCorIdPattern)) {
                feedback.info(sModule, "Detected wilycorid already set.");
                return null;
            }
            for (String insertBeforePattern : insertBeforePatternArr) {
                int index = origPattern.indexOf(insertBeforePattern);
                if (index > 0) {
                    String newPattern = origPattern.substring(0, index) + wilyCorIdInsertPattern + origPattern.substring(index);
                    feedback.info(sModule, "New pattern is: " + newPattern);
                    return newPattern;
                }
                feedback.warn(sModule, "Cannot find insertion point in pattern: " + origPattern);
            }
        }
        feedback.warn(sModule, "Invalid argument type.");
        return null;
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReEntryLeveL;
    }

    public boolean ITracerFactory_isShutoff() {
        return !mdcAutoInsertEnabled;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }

    private static void initializePatternHelper(IndexedProperties props) {
        String patternValue = null;
        try {
            patternValue = props.getProperty("com.ca.apm.log.correlation.mdc.insert.before", DEFAULT_INSERT_BEFORE_PATTERN);
            insertBeforePatternArr = new String[]{patternValue};
            int openBracket = patternValue.indexOf(91);
            int closeBracket = patternValue.lastIndexOf(93);
            if (openBracket >= 0 && closeBracket > openBracket) {
                String arrContents = patternValue.substring(openBracket + 1, closeBracket);
                insertBeforePatternArr = arrContents.split("\\,");
            } else {
                feedback.info(sModule, "properly formated [ ] not found using prop value -->" + patternValue + "<-- as insert pattern");
            }
        }
        catch (Exception e) {
            feedback.info(sModule, "Parse exception: " + e.getMessage() + " using prop value -->" + patternValue + "<-- as insert pattern");
        }
    }

    static {
        mdcAutoInsertEnabled = false;
        initialized = false;
        wilyCorIdMdcKey = "wilycorid";
        sModule = LogCorrelationConstants.kModule;
        DEFAULT_INSERT_BEFORE_PATTERN = "%n";
        insertBeforePatternArr = new String[]{DEFAULT_INSERT_BEFORE_PATTERN};
    }
}

