/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.undertow;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncHttpBackendStartTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpDataResolver;
import com.wily.introscope.agent.undertow.UndertowHttpClientDataResolver;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class AsyncUndertowHttpBackendStartTracer
extends AsyncHttpBackendStartTracer {
    protected HttpDataResolver dataResolver = UndertowHttpClientDataResolver.getInstance();
    private Class<?> httpStringClass = null;
    private Constructor<?> httpStringConstructor = null;

    public AsyncUndertowHttpBackendStartTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        try {
            this.httpStringClass = Class.forName("io.undertow.util.HttpString", true, sampleTracedObject.getClass().getClassLoader());
            this.httpStringConstructor = this.httpStringClass.getConstructor(String.class);
        }
        catch (ClassNotFoundException e) {
            this.feedback.error(module, "Failed to initialize header insertion: " + e.getMessage());
            this.feedback.debug(module, "Failed to initialize header insertion: ", (Throwable)e);
        }
        catch (SecurityException e) {
            this.feedback.error(module, "Failed to initialize header insertion: " + e.getMessage());
            this.feedback.debug(module, "Failed to initialize header insertion: ", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.feedback.error(module, "Failed to initialize header insertion: " + e.getMessage());
            this.feedback.debug(module, "Failed to initialize header insertion: ", (Throwable)e);
        }
    }

    protected void insertHttpRequestHeader(InvocationData data, String key, String value) {
        try {
            Object request = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationParameterAsObject(0), (String)"getRequest", (Class[])new Class[0], (Object[])new Object[0]);
            Object headers = ReflectionUtils.invokeMethodOnObject((Object)request, (String)"getRequestHeaders", (Class[])new Class[0], (Object[])new Object[0]);
            Object httpStringKey = this.httpStringConstructor.newInstance(key);
            ReflectionUtils.invokeMethodOnObject((Object)headers, (String)"add", (Class[])new Class[]{this.httpStringClass, String.class}, (Object[])new Object[]{httpStringKey, value});
        }
        catch (IllegalArgumentException e) {
            this.feedback.error(module, "Failed to insert header to request: " + e.getMessage());
            this.feedback.debug(module, "Failed to insert header to request: ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.feedback.error(module, "Failed to insert header to request: " + e.getMessage());
            this.feedback.debug(module, "Failed to insert header to request: ", (Throwable)e);
        }
        catch (SecurityException e) {
            this.feedback.error(module, "Failed to insert header to request: " + e.getMessage());
            this.feedback.debug(module, "Failed to insert header to request: ", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.feedback.error(module, "Failed to insert header to request: " + e.getMessage());
            this.feedback.debug(module, "Failed to insert header to request: ", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.feedback.error(module, "Failed to insert header to request: " + e.getMessage());
            this.feedback.debug(module, "Failed to insert header to request: ", (Throwable)e);
        }
        catch (InstantiationException e) {
            this.feedback.error(module, "Failed to insert header to request: " + e.getMessage());
            this.feedback.debug(module, "Failed to insert header to request: ", (Throwable)e);
        }
    }

    protected String getHttpMethod(InvocationData data) {
        return this.dataResolver.getHttpMethod(this.getAgent(), data);
    }
}

