/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.undertow;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpDataResolver;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.util.ReflectionLookupException;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;

public class UndertowHttpClientDataResolver
implements HttpDataResolver {
    private static final Module module = new Module("UndertowClientDataResolver");
    private static final HttpDataResolver instance = new UndertowHttpClientDataResolver();

    private UndertowHttpClientDataResolver() {
    }

    public static HttpDataResolver getInstance() {
        return instance;
    }

    public URI getUri(IAgent agent, InvocationData data) {
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        try {
            Object connection = data.getInvocationObject();
            Object address = ReflectionUtils.invokeMethodOnObject((Object)connection, (String)"getPeerAddress", (boolean)true, (IModuleFeedbackChannel)feedback);
            String host = null;
            int port = 80;
            if (address instanceof InetSocketAddress) {
                InetSocketAddress a = (InetSocketAddress)address;
                port = a.getPort();
                host = a.getHostName();
            }
            Object req = this.getRequestObject(data, feedback);
            String schema = "http";
            Object path = ReflectionUtils.invokeMethodOnObject((Object)req, (String)"getPath", (boolean)true, (IModuleFeedbackChannel)feedback);
            if (path != null) {
                return new URI(schema, null, host, port, path.toString(), null, null);
            }
        }
        catch (IllegalArgumentException e) {
            feedback.error(module, "Failed to resolve HTTP method: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP method: ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            feedback.error(module, "Failed to resolve HTTP method: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP method: ", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            feedback.error(module, "Failed to resolve HTTP method: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP method: ", (Throwable)e);
        }
        catch (ReflectionLookupException e) {
            feedback.error(module, "Failed to resolve HTTP method: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP method: ", (Throwable)e);
        }
        catch (URISyntaxException e) {
            feedback.error(module, "Failed to resolve HTTP method: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP method: ", (Throwable)e);
        }
        return BackendProtocolsConstants.UNKNOWN_URI;
    }

    private Object getRequestObject(InvocationData data, IModuleFeedbackChannel feedback) {
        try {
            Object exchange = data.getInvocationParameterAsObject(0);
            Object request = ReflectionUtils.invokeMethodOnObject((Object)exchange, (String)"getRequest", (boolean)true, (IModuleFeedbackChannel)feedback);
            return request;
        }
        catch (IllegalArgumentException e) {
            feedback.error(module, "Failed to resolve HTTP request: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP request: ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            feedback.error(module, "Failed to resolve HTTP request: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP request: ", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            feedback.error(module, "Failed to resolve HTTP request: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP request: ", (Throwable)e);
        }
        catch (ReflectionLookupException e) {
            feedback.error(module, "Failed to resolve HTTP request: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP request: ", (Throwable)e);
        }
        return null;
    }

    private Object getResponseObject(InvocationData data, IModuleFeedbackChannel feedback) {
        try {
            Object exchange = data.getInvocationObject();
            Object response = ReflectionUtils.invokeMethodOnObject((Object)exchange, (String)"getResponse", (boolean)true, (IModuleFeedbackChannel)feedback);
            return response;
        }
        catch (IllegalArgumentException e) {
            feedback.error(module, "Failed to resolve HTTP response: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP response: ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            feedback.error(module, "Failed to resolve HTTP response: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP response: ", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            feedback.error(module, "Failed to resolve HTTP response: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP response: ", (Throwable)e);
        }
        catch (ReflectionLookupException e) {
            feedback.error(module, "Failed to resolve HTTP response: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP response: ", (Throwable)e);
        }
        return null;
    }

    public String getHttpMethod(IAgent agent, InvocationData data) {
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        String methodResult = null;
        try {
            Object req = this.getRequestObject(data, feedback);
            Object method = ReflectionUtils.invokeMethodOnObject((Object)req, (String)"getMethod", (boolean)true, (IModuleFeedbackChannel)feedback);
            if (method != null) {
                methodResult = method.toString();
            }
        }
        catch (IllegalArgumentException e) {
            feedback.error(module, "Failed to resolve HTTP method: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP method: ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            feedback.error(module, "Failed to resolve HTTP method: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP method: ", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            feedback.error(module, "Failed to resolve HTTP method: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP method: ", (Throwable)e);
        }
        catch (ReflectionLookupException e) {
            feedback.error(module, "Failed to resolve HTTP method: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP method: ", (Throwable)e);
        }
        return methodResult;
    }

    public int getHttpStatusCode(IAgent agent, InvocationData data) {
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        try {
            Object response = this.getResponseObject(data, feedback);
            Object status = ReflectionUtils.invokeMethodOnObject((Object)response, (String)"getResponseCode", (boolean)true, (IModuleFeedbackChannel)feedback);
            if (status != null && status instanceof Integer) {
                return (Integer)status;
            }
        }
        catch (IllegalArgumentException e) {
            feedback.error(module, "Failed to resolve HTTP status code: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP status code: ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            feedback.error(module, "Failed to resolve HTTP status code: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP status code: ", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            feedback.error(module, "Failed to resolve HTTP status code: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP status code: ", (Throwable)e);
        }
        catch (ReflectionLookupException e) {
            feedback.error(module, "Failed to resolve HTTP status code: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP status code: ", (Throwable)e);
        }
        return -1;
    }

    public String getHttpStatusMessage(IAgent agent, InvocationData data) {
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        try {
            Object response = this.getResponseObject(data, feedback);
            Object status = ReflectionUtils.invokeMethodOnObject((Object)response, (String)"getStatus", (boolean)true, (IModuleFeedbackChannel)feedback);
            if (status != null) {
                return (String)status;
            }
        }
        catch (IllegalArgumentException e) {
            feedback.error(module, "Failed to resolve HTTP status reason: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP status reason: ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            feedback.error(module, "Failed to resolve HTTP status reason: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP status reason: ", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            feedback.error(module, "Failed to resolve HTTP status reason: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP status reason: ", (Throwable)e);
        }
        catch (ReflectionLookupException e) {
            feedback.error(module, "Failed to resolve HTTP status reason: " + e.getMessage());
            feedback.debug(module, "Failed to resolve HTTP status reason: ", (Throwable)e);
        }
        return null;
    }
}

