/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.directives.ClassModificationFilter;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.util.CollectionEquivalenceCheckers;
import com.wily.util.HashCodeUtils;
import com.wily.util.adt.trie.PackagePrefixMatchingTrie;
import com.wily.util.adt.trie.Trie;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IContainerName;
import com.wily.util.classfile.IContainerPrefix;
import com.wily.util.classfile.IPackageName;
import com.wily.util.classfile.IPackagePrefix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class ClassModificationFilterBuilder {
    private List fSkipContainerPrefixes = new ArrayList();
    private List fSkipContainers = new ArrayList();
    private PackagePrefixMatchingTrie fDoNotSkipPackagePrefixes = new PackagePrefixMatchingTrie();
    private List fSkipPackagePrefixes = new ArrayList();
    private List fSkipPackages = new ArrayList();
    private List fSkipClasses = new ArrayList();
    private List fSkipMethods = new ArrayList();
    private Map fSkipMethodsForClasses = new HashMap();
    private Map fSkipMethodsForClassesExceptions = new HashMap();
    private List fSkipMatchingClasses = new ArrayList();
    private List fForceProcessClassesPostmain = new ArrayList();
    private List fForceProcessClassesPremain = new ArrayList();
    private ICompilerLog fLog;
    private List fSkipDynamicInstrumentationContainerPrefixes;
    private List fSkipDynamicInstrumentationContainers;
    private List fSkipDynamicInstrumentationPackagePrefixes;
    private List fSkipDynamicInstrumentationPackages;
    private List fSkipDynamicInstrumentationClasses;
    private List fSkipIntelligentInstrumentationPackagePrefixes;
    private List fIncludeIntelligentInstrumentationPackagePrefixes;

    public ClassModificationFilterBuilder(ICompilerLog log) {
        this.fLog = log;
        this.fSkipDynamicInstrumentationContainerPrefixes = new ArrayList();
        this.fSkipDynamicInstrumentationContainers = new ArrayList();
        this.fSkipDynamicInstrumentationPackagePrefixes = new ArrayList();
        this.fSkipDynamicInstrumentationPackages = new ArrayList();
        this.fSkipDynamicInstrumentationClasses = new ArrayList();
        this.fSkipIntelligentInstrumentationPackagePrefixes = new ArrayList();
        this.fIncludeIntelligentInstrumentationPackagePrefixes = new ArrayList();
    }

    public void skipIntelligentInstrumentationPackagePrefix(IPackagePrefix prefix) {
        this.fSkipIntelligentInstrumentationPackagePrefixes.add(prefix.getPrefixString());
    }

    public void includeIntelligentInstrumentationPackagePrefix(IPackagePrefix prefix) {
        this.fIncludeIntelligentInstrumentationPackagePrefixes.add(prefix.getPrefixString());
    }

    public void skipDynamicInstrumentationClass(IClassName className) {
        this.fSkipDynamicInstrumentationClasses.add(className.getContainerAndPackageAndNameString());
    }

    public void skipDynamicInstrumentationPackage(IPackageName packageName) {
        this.fSkipDynamicInstrumentationPackages.add(packageName.toString());
    }

    public void skipDynamicInstrumentationPackagePrefix(IPackagePrefix prefix) {
        this.fSkipDynamicInstrumentationPackagePrefixes.add(prefix.getPrefixString());
    }

    public void skipDynamicInstrumentationContainer(IContainerName containerName) {
        this.fSkipDynamicInstrumentationContainers.add(containerName.toString());
    }

    public void skipDynamicInstrumentationContainerPrefix(IContainerPrefix prefix) {
        this.fSkipDynamicInstrumentationContainerPrefixes.add(prefix.getPrefixString());
    }

    public void skipClass(IClassName className) {
        this.fSkipClasses.add(className.getContainerAndPackageAndNameString());
    }

    public void skipMethodForClass(IClassName className, IMethodMatcher matcher) {
        HashSet<IMethodMatcher> methodsToSkip = (HashSet<IMethodMatcher>)this.fSkipMethodsForClasses.get(className);
        if (methodsToSkip == null) {
            methodsToSkip = new HashSet<IMethodMatcher>();
            this.fSkipMethodsForClasses.put(className, methodsToSkip);
        }
        methodsToSkip.add(matcher);
    }

    public void doNotSkipMethodForClass(IClassName className, IMethodMatcher matcher) {
        HashSet<IMethodMatcher> methods = (HashSet<IMethodMatcher>)this.fSkipMethodsForClassesExceptions.get(className);
        if (methods == null) {
            methods = new HashSet<IMethodMatcher>();
            this.fSkipMethodsForClassesExceptions.put(className, methods);
        }
        methods.add(matcher);
    }

    public void skipMethod(IMethodMatcher methodName) {
        this.fSkipMethods.add(methodName);
    }

    public void doNotSkipPackagePrefix(String packagePrefix) {
        this.fDoNotSkipPackagePrefixes.insert(packagePrefix);
    }

    public void skipPackage(IPackageName packageName) {
        this.fSkipPackages.add(packageName.toString());
    }

    public void skipPackagePrefix(IPackagePrefix prefix) {
        this.fSkipPackagePrefixes.add(prefix.getPrefixString());
    }

    public void skipContainer(IContainerName containerName) {
        this.fSkipContainers.add(containerName.toString());
    }

    public void skipContainerPrefix(IContainerPrefix prefix) {
        this.fSkipContainerPrefixes.add(prefix.getPrefixString());
    }

    public void skipMatchingClass(IClassMatcher matcher) {
        this.fSkipMatchingClasses.add(matcher);
    }

    public void addInstrumentableBootstrapClassPostmain(IClassName className) {
        this.fForceProcessClassesPostmain.add(className.getContainerAndPackageAndNameString());
    }

    public void addInstrumentableBootstrapClassPremain(IClassName className) {
        this.fForceProcessClassesPremain.add(className.getContainerAndPackageAndNameString());
    }

    public void addClassModificationFilter(ClassModificationFilterBuilder filter) {
        this.fSkipContainers.addAll(filter.fSkipContainers);
        this.fSkipContainerPrefixes.addAll(filter.fSkipContainerPrefixes);
        this.fDoNotSkipPackagePrefixes.merge((Trie)filter.fDoNotSkipPackagePrefixes);
        this.fSkipPackages.addAll(filter.fSkipPackages);
        this.fSkipPackagePrefixes.addAll(filter.fSkipPackagePrefixes);
        this.fSkipClasses.addAll(filter.fSkipClasses);
        this.fSkipMethods.addAll(filter.fSkipMethods);
        this.fSkipMethodsForClasses.putAll(filter.fSkipMethodsForClasses);
        this.fSkipMethodsForClassesExceptions.putAll(filter.fSkipMethodsForClassesExceptions);
        this.fSkipMatchingClasses.addAll(filter.fSkipMatchingClasses);
        this.fForceProcessClassesPostmain.addAll(filter.fForceProcessClassesPostmain);
        this.fForceProcessClassesPremain.addAll(filter.fForceProcessClassesPremain);
        this.fSkipDynamicInstrumentationContainers.addAll(filter.fSkipDynamicInstrumentationContainers);
        this.fSkipDynamicInstrumentationContainerPrefixes.addAll(filter.fSkipDynamicInstrumentationContainerPrefixes);
        this.fSkipDynamicInstrumentationPackages.addAll(filter.fSkipDynamicInstrumentationPackages);
        this.fSkipDynamicInstrumentationPackagePrefixes.addAll(filter.fSkipDynamicInstrumentationPackagePrefixes);
        this.fSkipDynamicInstrumentationClasses.addAll(filter.fSkipDynamicInstrumentationClasses);
        this.fSkipIntelligentInstrumentationPackagePrefixes.addAll(filter.fSkipIntelligentInstrumentationPackagePrefixes);
        this.fIncludeIntelligentInstrumentationPackagePrefixes.addAll(filter.fIncludeIntelligentInstrumentationPackagePrefixes);
    }

    public void addClassModificationFilter(ClassModificationFilter filter) {
        this.fSkipContainers.addAll(filter.getSkipContainers());
        this.fSkipContainerPrefixes.addAll(filter.getSkipContainerPrefixes());
        this.fDoNotSkipPackagePrefixes.merge((Trie)filter.getDoNotSkipPackagePrefixes());
        this.fSkipPackages.addAll(filter.getSkipPackages());
        this.fSkipPackagePrefixes.addAll(filter.getSkipPackagePrefixes());
        this.fSkipClasses.addAll(filter.getSkipClasses());
        this.fSkipMethods.addAll(filter.getSkipMethods());
        this.fSkipMethodsForClasses.putAll(filter.getSkipMethodsForClasses());
        this.fSkipMethodsForClassesExceptions.putAll(filter.getSkipMethodsForClassesExceptions());
        this.fSkipMatchingClasses.addAll(filter.getSkipMatchingClasses());
        this.fForceProcessClassesPostmain.addAll(filter.getForceProcessClassesPostmain());
        this.fForceProcessClassesPremain.addAll(filter.getForceProcessClassesPremain());
        this.fSkipDynamicInstrumentationContainers.addAll(filter.getSkipDynamicInstrumentationContainers());
        this.fSkipDynamicInstrumentationContainerPrefixes.addAll(filter.getSkipDynamicInstrumentationContainerPrefixes());
        this.fSkipDynamicInstrumentationPackages.addAll(filter.getSkipDynamicInstrumentationPackages());
        this.fSkipDynamicInstrumentationPackagePrefixes.addAll(filter.getSkipDynamicInstrumentationPackagePrefixes());
        this.fSkipDynamicInstrumentationClasses.addAll(filter.getSkipDynamicInstrumentationClasses());
        this.fSkipIntelligentInstrumentationPackagePrefixes.addAll(filter.getSkipIntelligentInstrumentationPackagePrefixes());
        this.fIncludeIntelligentInstrumentationPackagePrefixes.addAll(filter.getIncludeIntelligentInstrumentationPackagePrefixes());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassModificationFilterBuilder) {
            ClassModificationFilterBuilder cmf = (ClassModificationFilterBuilder)obj;
            return CollectionEquivalenceCheckers.listsAreEquivalent((List)this.fSkipClasses, (List)cmf.fSkipClasses) && CollectionEquivalenceCheckers.listsAreEquivalent((List)this.fSkipPackages, (List)cmf.fSkipPackages) && CollectionEquivalenceCheckers.listsAreEquivalent((List)this.fSkipPackagePrefixes, (List)cmf.fSkipPackagePrefixes) && CollectionEquivalenceCheckers.listsAreEquivalent((List)this.fSkipContainers, (List)cmf.fSkipContainers) && CollectionEquivalenceCheckers.listsAreEquivalent((List)this.fSkipContainerPrefixes, (List)cmf.fSkipContainerPrefixes) && CollectionEquivalenceCheckers.listsAreEquivalent((List)this.fSkipMethods, (List)cmf.fSkipMethods) && CollectionEquivalenceCheckers.listsAreEquivalent((List)this.fSkipMatchingClasses, (List)cmf.fSkipMatchingClasses) && CollectionEquivalenceCheckers.listsAreEquivalent((List)this.fForceProcessClassesPostmain, (List)cmf.fForceProcessClassesPostmain) && CollectionEquivalenceCheckers.listsAreEquivalent((List)this.fForceProcessClassesPremain, (List)cmf.fForceProcessClassesPremain) && this.fSkipMethodsForClasses.equals(cmf.fSkipMethodsForClasses) && this.fDoNotSkipPackagePrefixes.equals((Object)cmf.fDoNotSkipPackagePrefixes) && this.fSkipMethodsForClassesExceptions.equals(cmf.fSkipMethodsForClassesExceptions);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipClasses.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fDoNotSkipPackagePrefixes.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipPackages.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipPackagePrefixes.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipContainers.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipContainerPrefixes.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipMethods.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipMethodsForClasses.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipMethodsForClassesExceptions.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipMatchingClasses.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fForceProcessClassesPostmain.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fForceProcessClassesPremain.hashCode());
        return result;
    }

    public ClassModificationFilter generateFilter() {
        return new ClassModificationFilter(this.fSkipClasses, this.fDoNotSkipPackagePrefixes, this.fSkipPackages, this.fSkipPackagePrefixes, this.fSkipContainers, this.fSkipContainerPrefixes, this.fSkipMethods, this.fSkipMethodsForClasses, this.fSkipMethodsForClassesExceptions, this.fSkipMatchingClasses, this.fForceProcessClassesPostmain, this.fForceProcessClassesPremain, this.fSkipDynamicInstrumentationContainerPrefixes, this.fSkipDynamicInstrumentationContainers, this.fSkipDynamicInstrumentationPackagePrefixes, this.fSkipDynamicInstrumentationPackages, this.fSkipDynamicInstrumentationClasses, this.fSkipIntelligentInstrumentationPackagePrefixes, this.fIncludeIntelligentInstrumentationPackagePrefixes);
    }

    public int debug_getSkipCount() {
        return this.fSkipContainerPrefixes.size() + this.fSkipContainers.size() + this.fSkipPackagePrefixes.size() + this.fSkipPackages.size() + this.fSkipClasses.size() + this.fSkipMethods.size() + this.fSkipMethodsForClasses.size() + this.fSkipMethodsForClassesExceptions.size() + this.fSkipMatchingClasses.size() + this.fSkipMethodsForClasses.size();
    }
}

