/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.datetime;

import com.wily.util.datetime.DateFormatException;
import com.wily.utilities.properties.Messages;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class UIDateParser {
    private static DateFormat canonicalDateFormat;
    private static UIDateParser defaultInstance;
    private Locale locale;
    private DateFormat friendlyTimestampFormat;
    private String[] dayFormats;
    private final String[] hourFormats;
    private final ArrayList<DateFormat> timestampFormats;

    public static UIDateParser getInstance() {
        if (defaultInstance == null) {
            defaultInstance = new UIDateParser();
        }
        return defaultInstance;
    }

    public UIDateParser() {
        this(Locale.getDefault(), TimeZone.getDefault());
    }

    public UIDateParser(Locale loc, TimeZone tz) {
        try {
            canonicalDateFormat = new SimpleDateFormat(Messages.getString("UIDateParser.CanonicalDateFormat"), Locale.getDefault());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            canonicalDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.getDefault());
            System.err.println("UIDateParser.CanonicalDateFormat " + Messages.getString("UIDateParser.CanonicalDateFormat") + " has an invalid value in locale " + Locale.getDefault().getLanguage());
        }
        this.dayFormats = new String[]{Messages.getString("UIDateParser.DayFormat1"), Messages.getString("UIDateParser.DayFormat2")};
        this.hourFormats = new String[]{Messages.getString("UIDateParser.HourFormat1"), Messages.getString("UIDateParser.HourFormat2")};
        this.timestampFormats = new ArrayList();
        this.locale = loc;
        int d = 0;
        while (d < this.dayFormats.length) {
            try {
                this.timestampFormats.add(new SimpleDateFormat(this.dayFormats[d], this.locale));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.handleDayFormatError(d);
                this.timestampFormats.add(new SimpleDateFormat(this.dayFormats[d], this.locale));
            }
            ++d;
        }
        int h = 0;
        while (h < this.hourFormats.length) {
            int n = 0;
            while (n < this.dayFormats.length) {
                try {
                    this.timestampFormats.add(new SimpleDateFormat(String.valueOf(this.dayFormats[n]) + " " + this.hourFormats[h], this.locale));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.handleDayFormatError(n);
                    this.timestampFormats.add(new SimpleDateFormat(String.valueOf(this.dayFormats[n]) + " " + this.hourFormats[h], this.locale));
                }
                ++n;
            }
            ++h;
        }
        Collections.sort(this.timestampFormats, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((SimpleDateFormat)o1).toPattern();
                String s2 = ((SimpleDateFormat)o2).toPattern();
                if (s1.length() > s2.length()) {
                    return -1;
                }
                return 1;
            }
        });
        this.timestampFormats.add(0, SimpleDateFormat.getDateTimeInstance(2, 3, this.locale));
        this.friendlyTimestampFormat = SimpleDateFormat.getDateTimeInstance(3, 3, this.locale);
        this.timestampFormats.add(0, SimpleDateFormat.getDateInstance(2, this.locale));
        this.timestampFormats.add(0, SimpleDateFormat.getDateInstance(3, this.locale));
        this.timestampFormats.add(0, this.friendlyTimestampFormat);
        for (SimpleDateFormat simpleDateFormat : this.timestampFormats) {
            simpleDateFormat.setTimeZone(tz);
            simpleDateFormat.setLenient(false);
        }
    }

    private void handleDayFormatError(int d) {
        System.err.println("UIDateParser.DayFormat " + this.dayFormats[d] + " has an invalid value in locale " + Locale.getDefault().getLanguage());
        this.dayFormats = new String[2];
        this.dayFormats[0] = "MM/dd/yyyy";
        this.dayFormats[1] = "MM-dd-yyyy";
    }

    public String formatFriendlyTimestamp(Date d) {
        if (d == null) {
            return "";
        }
        return this.friendlyTimestampFormat.format(d);
    }

    public Date parseTimestamp(String s) throws DateFormatException {
        if (s == null || s.length() == 0) {
            return null;
        }
        s = s.trim();
        for (DateFormat f : this.timestampFormats) {
            ParsePosition p;
            Date date = f.parse(s, p = new ParsePosition(0));
            if (date == null || p.getIndex() < s.length()) continue;
            return date;
        }
        throw new DateFormatException(Messages.getString("UIDateParser.DateFormatError_Log", (Object)s));
    }

    public static String getCanonicalStringRep(Date d) {
        if (d != null) {
            return canonicalDateFormat.format(d);
        }
        return "";
    }

    public static Date parseCanonicalString(String timestamp) throws DateFormatException {
        if (timestamp != null && timestamp.length() > 0) {
            try {
                return canonicalDateFormat.parse(timestamp);
            }
            catch (ParseException parseException) {
                throw new DateFormatException(Messages.getString("UIDateParser.InvalidTimestampError_Log", (Object)timestamp));
            }
        }
        return null;
    }
}

