/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.disk;

import com.wily.util.clock.MasterClock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DiskAccessLock {
    public static final long kRandomIOReleaseRateMS = 500L;
    private static final boolean sDebug = false;
    private final ReadWriteLock fLock = new ReentrantReadWriteLock(true);
    private final ThreadLocal<Integer> fRandomThreadLocal = new ThreadLocal();
    private final ThreadLocal<Integer> fSequentialThreadLocal = new ThreadLocal();
    private final ThreadLocal<TimingAndStackTrace> fTimingAndStackTrace = new ThreadLocal();

    private int getRandomThreadCount() {
        Integer i = this.fRandomThreadLocal.get();
        if (i == null) {
            return 0;
        }
        return i;
    }

    private void setRandomThreadCount(int i) {
        this.fRandomThreadLocal.set(i);
    }

    private int getSequentialThreadCount() {
        Integer i = this.fSequentialThreadLocal.get();
        if (i == null) {
            return 0;
        }
        return i;
    }

    private void setSequentialThreadCount(int i) {
        this.fSequentialThreadLocal.set(i);
    }

    public void acquireRandomIOLock() {
        if (this.getRandomThreadCount() == 0) {
            while (true) {
                try {
                    this.fLock.readLock().lockInterruptibly();
                    this.fTimingAndStackTrace.set(new TimingAndStackTrace());
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        this.setRandomThreadCount(this.getRandomThreadCount() + 1);
    }

    public void releaseRandomIOLock() {
        int count = this.getRandomThreadCount();
        this.setRandomThreadCount(--count);
        if (count == 0) {
            this.fTimingAndStackTrace.get().release();
            this.fLock.readLock().unlock();
        }
    }

    public void acquireSequentialIOLock() {
        if (this.getSequentialThreadCount() == 0) {
            while (true) {
                try {
                    long start = MasterClock.currentTimeMillis();
                    this.fLock.writeLock().lockInterruptibly();
                    long acquireTime = MasterClock.currentTimeMillis() - start;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        this.setSequentialThreadCount(this.getSequentialThreadCount() + 1);
    }

    public void releaseSequentialIOLock() {
        int count = this.getSequentialThreadCount();
        this.setSequentialThreadCount(--count);
        if (count == 0) {
            this.fLock.writeLock().unlock();
        }
    }

    private static class TimingAndStackTrace {
        private static long kWarningTime = 6000L;
        private long fStartTime;
        private Exception fStack;

        public void release() {
        }
    }
}

