/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.event;

import com.wily.EDU.oswego.cs.dl.util.concurrent.Executor;
import com.wily.util.ICloseable;
import com.wily.util.event.AListenerClosureRunnable;
import com.wily.util.event.AListenerEvent;
import com.wily.util.event.ARewindingBasketable;
import com.wily.util.event.AddToCollectionRunnable;
import com.wily.util.event.BasketableNotFoundException;
import com.wily.util.event.IBasketListener;
import com.wily.util.event.IBasketableListener;
import com.wily.util.event.IListenerClosure;
import com.wily.util.event.RemoveFromCollectionRunnable;
import com.wily.util.event.RewindRunnable;
import com.wily.util.event.SynchronousExecutor;
import com.wily.util.exception.UnexpectedExceptionError;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.utilities.properties.Messages;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class ARewindingBasket {
    private final IModuleFeedbackChannel fFeedback;
    private final Object fBasketLock;
    private final HashMap fBasketables;
    private final Vector fListeners;
    private final List fAllBasketablesListenersList;

    protected ARewindingBasket(IModuleFeedbackChannel feedback, Class basketListenerClass, Object basketLock) {
        this.fFeedback = feedback;
        this.fBasketLock = basketLock;
        this.fBasketables = new HashMap();
        this.fListeners = new Vector();
        this.fAllBasketablesListenersList = new ArrayList();
    }

    private Object getBasketLock() {
        return this.fBasketLock;
    }

    IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ARewindingBasketable lookupBasketableFromKey(Object key) {
        if (key == null) {
            return null;
        }
        Object object = this.getBasketLock();
        synchronized (object) {
            return (ARewindingBasketable)this.fBasketables.get(key);
        }
    }

    private Object lookupValueFromKey(Object key) {
        ARewindingBasketable basketable = this.lookupBasketableFromKey(key);
        if (basketable != null) {
            return basketable.IBasketable_getBasketableValue();
        }
        return null;
    }

    private Object findValueFromKey(Object key) throws BasketableNotFoundException {
        Object value = this.IBasket_lookupValueFromKey(key);
        if (value == null) {
            throw new BasketableNotFoundException();
        }
        return value;
    }

    public abstract Executor getExecutor();

    void execute(Runnable runnable) {
        try {
            this.getExecutor().execute(runnable);
        }
        catch (InterruptedException e) {
            this.getModuleFeedback().debug(e);
        }
    }

    public abstract AListenerEvent IBasket_allocateBasketEvent(int var1);

    public IModuleFeedbackChannel IBasket_getModuleFeedback() {
        return this.getModuleFeedback();
    }

    public Object IBasket_lookupValueFromKey(Object key) {
        return this.lookupValueFromKey(key);
    }

    public Object IBasket_findValueFromKey(Object key) throws BasketableNotFoundException {
        return this.findValueFromKey(key);
    }

    public int getSize() {
        return this.fBasketables.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addBasketable(ARewindingBasketable basketable) {
        Object object = this.getBasketLock();
        synchronized (object) {
            this.fBasketables.put(basketable.IBasketable_getBasketableKey(), basketable);
            this.broadcastFireBasketableAvailable(basketable);
            for (IBasketableListener listener : this.fAllBasketablesListenersList) {
                basketable.IBasketable_addBroadcastListener(listener);
            }
        }
    }

    public final void removeBasketable(ARewindingBasketable basketable) throws BasketableNotFoundException {
        this.removeBasketableQuietly(basketable);
        this.broadcastFireBasketableDisappeared(basketable);
        basketable.noticeRemoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeBasketableQuietly(ARewindingBasketable basketable) throws BasketableNotFoundException {
        Object object = this.getBasketLock();
        synchronized (object) {
            if (!this.fBasketables.containsKey(basketable.IBasketable_getBasketableKey())) {
                throw new BasketableNotFoundException(String.valueOf(Messages.getString("ARewindingBasket.BasketableNotFoundError_Log")) + basketable.toString());
            }
            this.fBasketables.remove(basketable.IBasketable_getBasketableKey());
        }
        for (IBasketableListener listener : this.fAllBasketablesListenersList) {
            basketable.IBasketable_removeBroadcastListener(listener);
        }
    }

    public ICloseable addBroadcastListenerWithRewind(IBasketListener listener, boolean synchronous) {
        SynchronousExecutor executor = synchronous ? new SynchronousExecutor() : this.getExecutor();
        return this.addBroadcastListenerWithRewind(listener, executor);
    }

    public ICloseable addBroadcastListenerWithRewind(IBasketListener listener) {
        return this.addBroadcastListenerWithRewind(listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICloseable addBroadcastListenerWithRewind(IBasketListener listener, Executor executor) {
        try {
            ListenerCloseable closeable = new ListenerCloseable(listener);
            Assertion.wilyAssert(listener != null, Messages.getString("ARewindingBasket.NullListenerError_Log"));
            Object object = this.getBasketLock();
            synchronized (object) {
                executor.execute((Runnable)new RewindBasketableRunnable(listener));
                AListenerEvent rewindFinishedEvent = this.allocateBasketEvent(1002);
                executor.execute((Runnable)new RewindRunnable(listener, rewindFinishedEvent));
                this.basketPostAddBroadcastListener(listener);
            }
            return closeable;
        }
        catch (InterruptedException e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBroadcastListener(IBasketListener listener) {
        Assertion.wilyAssert(listener != null, Messages.getString("ARewindingBasket.NullListenerError_Log"));
        Object object = this.getBasketLock();
        synchronized (object) {
            this.basketPostRemoveBroadcastListener(listener);
        }
    }

    public ICloseable addBroadcastAllBasketablesListenerWithRewind(IBasketableListener listener, boolean synchronous) {
        SynchronousExecutor executor = synchronous ? new SynchronousExecutor() : this.getExecutor();
        return this.addBroadcastAllBasketablesListenerWithRewind(listener, executor);
    }

    public ICloseable addBroadcastAllBasketablesListenerWithRewind(IBasketableListener listener) {
        return this.addBroadcastAllBasketablesListenerWithRewind(listener, this.getExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICloseable addBroadcastAllBasketablesListenerWithRewind(IBasketableListener listener, Executor executor) {
        Assertion.wilyAssert(listener != null, Messages.getString("ARewindingBasket.NullListenerError_Log"));
        Object object = this.getBasketLock();
        synchronized (object) {
            boolean addResult = this.fAllBasketablesListenersList.add(listener);
            Assertion.wilyAssert(addResult);
            Iterator i = this.getBasketablesIterator();
            while (i.hasNext()) {
                ARewindingBasketable basketable = (ARewindingBasketable)i.next();
                basketable.addBroadcastListenerWithRewind(listener, executor);
            }
            AListenerEvent rewindFinishedEvent = this.allocateBasketEvent(1002);
            try {
                executor.execute((Runnable)new RewindRunnable(listener, rewindFinishedEvent));
            }
            catch (InterruptedException e) {
                throw new UnexpectedExceptionError(e);
            }
        }
        return new AllBasketablesListenerCloseable(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICloseable addBroadcastAllBasketablesListener(IBasketableListener listener) {
        Assertion.wilyAssert(listener != null, Messages.getString("ARewindingBasket.NullListenerError_Log"));
        Object object = this.getBasketLock();
        synchronized (object) {
            boolean addResult = this.fAllBasketablesListenersList.add(listener);
            Assertion.wilyAssert(addResult);
            Iterator i = this.getBasketablesIterator();
            while (i.hasNext()) {
                ARewindingBasketable basketable = (ARewindingBasketable)i.next();
                basketable.IBasketable_addBroadcastListener(listener);
            }
        }
        return new AllBasketablesListenerCloseable(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBroadcastAllBasketablesListener(IBasketableListener listener) {
        Assertion.wilyAssert(listener != null, Messages.getString("ARewindingBasket.NullListenerError_Log"));
        Object object = this.getBasketLock();
        synchronized (object) {
            this.fAllBasketablesListenersList.remove(listener);
            Iterator i = this.getBasketablesIterator();
            while (i.hasNext()) {
                ARewindingBasketable basketable = (ARewindingBasketable)i.next();
                basketable.IBasketable_removeBroadcastListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lobotomize() {
        Object object = this.getBasketLock();
        synchronized (object) {
            this.fBasketables.clear();
        }
    }

    public void close() {
        this.lobotomize();
        this.fAllBasketablesListenersList.clear();
        this.fListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] IBasket_getAllValuesArray(Object[] candidateArray) {
        Object object = this.getBasketLock();
        synchronized (object) {
            Collection basketables = this.getBasketablesCollection();
            Object[] result = (Object[])Array.newInstance(candidateArray.getClass().getComponentType(), basketables.size());
            Iterator allEggs = basketables.iterator();
            int index = 0;
            while (allEggs.hasNext()) {
                ARewindingBasketable currentEgg = (ARewindingBasketable)allEggs.next();
                result[index++] = currentEgg.IBasketable_getBasketableValue();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map IBasket_getMap() {
        Object object = this.getBasketLock();
        synchronized (object) {
            return new HashMap(this.fBasketables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection IBasket_getValues() {
        Object object = this.getBasketLock();
        synchronized (object) {
            return new ArrayList(this.getBasketablesCollection());
        }
    }

    private AListenerEvent allocateBasketEvent(int eventID) {
        return this.IBasket_allocateBasketEvent(eventID);
    }

    AListenerEvent allocateBasketableEvent(int eventID, ARewindingBasketable basketable) {
        return basketable.IBasketable_allocateEvent(eventID);
    }

    private void broadcastFireBasketableAvailable(ARewindingBasketable basketable) {
        AListenerEvent availableEvent = this.getBasketableAvailableEvent(basketable);
        this.broadcastListenerClosure(this.getBasketableAvailableClosure(availableEvent));
    }

    public void broadcastListenerClosure(IListenerClosure closure) {
        this.execute(new AListenerClosureRunnable(closure){

            @Override
            public EventListener[] getEventListeners() {
                return ARewindingBasket.this.getListenerSnapshot();
            }
        });
    }

    EventListener[] getListenerSnapshot() {
        return this.fListeners.toArray(new EventListener[0]);
    }

    void noticeBasketableStateChange(final AListenerEvent changeEvent) {
        IListenerClosure closure = new IListenerClosure(){

            @Override
            public void execute(EventListener listener) {
                ((IBasketListener)listener).basketableChanged(changeEvent);
            }
        };
        this.broadcastListenerClosure(closure);
    }

    private IListenerClosure getBasketableAvailableClosure(final AListenerEvent availableEvent) {
        return new IListenerClosure(){

            @Override
            public void execute(EventListener listener) {
                ((IBasketListener)listener).basketablesAvailable(Arrays.asList(availableEvent));
            }
        };
    }

    private IListenerClosure getBasketableDisappearedClosure(final AListenerEvent disappearedEvent) {
        return new IListenerClosure(){

            @Override
            public void execute(EventListener listener) {
                ((IBasketListener)listener).basketablesDisappeared(Arrays.asList(disappearedEvent));
            }
        };
    }

    private AListenerEvent getBasketableAvailableEvent(ARewindingBasketable basketable) {
        AListenerEvent availableEvent = this.allocateBasketableEvent(1003, basketable);
        return availableEvent;
    }

    private void broadcastFireBasketableDisappeared(ARewindingBasketable basketable) {
        AListenerEvent disappearedEvent = this.allocateBasketableEvent(1004, basketable);
        this.broadcastListenerClosure(this.getBasketableDisappearedClosure(disappearedEvent));
    }

    private Collection getBasketablesCollection() {
        return this.fBasketables.values();
    }

    private Iterator getBasketablesIterator() {
        return this.getBasketablesCollection().iterator();
    }

    private void basketPostAddBroadcastListener(EventListener listener) {
        Assertion.wilyAssert(listener != null, Messages.getString("ARewindingBasket.NullListenerError_Log"));
        this.execute(new AddToCollectionRunnable(this.fListeners, listener));
    }

    private void basketPostRemoveBroadcastListener(EventListener listener) {
        Assertion.wilyAssert(listener != null, Messages.getString("ARewindingBasket.NullListenerError_Log"));
        this.execute(new RemoveFromCollectionRunnable(this.fListeners, listener));
    }

    private class AllBasketablesListenerCloseable
    implements ICloseable {
        private final IBasketableListener fListener;

        public AllBasketablesListenerCloseable(IBasketableListener listener) {
            this.fListener = listener;
        }

        @Override
        public void close() {
            ARewindingBasket.this.removeBroadcastAllBasketablesListener(this.fListener);
        }
    }

    private class ListenerCloseable
    implements ICloseable {
        private final IBasketListener fListener;

        public ListenerCloseable(IBasketListener listener) {
            this.fListener = listener;
        }

        @Override
        public void close() {
            ARewindingBasket.this.removeBroadcastListener(this.fListener);
        }
    }

    private class RewindBasketableRunnable
    implements Runnable {
        private final IBasketListener fListener;
        private final Collection fEvents;

        public RewindBasketableRunnable(IBasketListener listener) {
            this.fListener = listener;
            this.fEvents = new ArrayList();
            Iterator i = ARewindingBasket.this.getBasketablesIterator();
            while (i.hasNext()) {
                AListenerEvent event = ARewindingBasket.this.getBasketableAvailableEvent((ARewindingBasketable)i.next());
                this.fEvents.add(event);
            }
        }

        @Override
        public void run() {
            this.fListener.basketablesAvailable(this.fEvents);
        }
    }
}

