/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.string;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class StringUtils {
    public static String insertLineAfterLine(String textblock, String textToInsert, String locatorRegEx) throws IOException {
        String lineSep = System.getProperty("line.separator");
        Pattern p = Pattern.compile("");
        try {
            p = Pattern.compile(locatorRegEx);
        }
        catch (PatternSyntaxException pse) {
            System.out.println("Invalid regular expression: " + locatorRegEx);
            pse.printStackTrace();
            return textblock;
        }
        int lineCtr = 0;
        int lineLoc = 0;
        StringReader sr = new StringReader(textblock);
        BufferedReader in = new BufferedReader(sr);
        String line = in.readLine();
        while (line != null) {
            ++lineCtr;
            Matcher m = p.matcher(line);
            if (m.find()) {
                lineLoc = lineCtr;
                System.out.println("\tMatch at line #" + lineCtr);
            }
            line = in.readLine();
        }
        lineCtr = 0;
        line = null;
        sr.reset();
        in = new BufferedReader(sr);
        line = in.readLine();
        StringBuilder buf = new StringBuilder();
        while (line != null) {
            buf.append(line).append(lineSep);
            if (++lineCtr == lineLoc) {
                buf.append(textToInsert).append(lineSep);
                System.out.println("\tInsert after line #" + lineCtr);
            }
            line = in.readLine();
        }
        return buf.toString();
    }

    public static String insertLineAfterParagraph(String textblock, String textToInsert, String locatorRegEx) throws IOException {
        String lineSep = System.getProperty("line.separator");
        Pattern insPattern = Pattern.compile("");
        Pattern locPattern = Pattern.compile("");
        try {
            insPattern = Pattern.compile("^( |\\t)*?$");
            locPattern = Pattern.compile(locatorRegEx);
        }
        catch (PatternSyntaxException pse) {
            System.out.println("Invalid regular expression: " + locatorRegEx);
            pse.printStackTrace();
            return textblock;
        }
        int lineCtr = 0;
        int lineCt = 0;
        int lineLoc = 0;
        boolean lineBit = false;
        StringReader sr = new StringReader(textblock);
        BufferedReader in = new BufferedReader(sr);
        String line = in.readLine();
        while (line != null) {
            ++lineCtr;
            Matcher m = locPattern.matcher(line);
            if (m.find()) {
                lineLoc = lineCtr;
                System.out.println("\tMatch at line #" + lineCtr);
            }
            line = in.readLine();
        }
        lineCt = lineCtr;
        lineCtr = 0;
        line = null;
        sr.reset();
        in = new BufferedReader(sr);
        line = in.readLine();
        StringBuilder buf = new StringBuilder();
        while (line != null) {
            Matcher m = insPattern.matcher(line);
            buf.append(line).append(lineSep);
            if (++lineCtr >= lineLoc && !lineBit && (m.find() || lineCtr >= lineCt)) {
                buf.append(textToInsert).append(lineSep).append(lineSep);
                lineBit = true;
                System.out.println("\tBlank line or EOD at line #" + lineCtr);
                System.out.println("\tInsert after line #" + lineCtr);
            }
            line = in.readLine();
        }
        return buf.toString();
    }

    public static int getPropLength(String prop) {
        String[] splitProp = prop.split("\\.");
        return splitProp.length;
    }

    public static String shortenProp(String prop) {
        StringBuilder buf = new StringBuilder();
        String[] splitProp = prop.split("\\.");
        int len = splitProp.length;
        if (len >= 3) {
            int x = 0;
            while (x <= 2) {
                buf.append(splitProp[x]).append(".");
                ++x;
            }
            return buf.toString();
        }
        return prop;
    }
}

