/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.sysview.ctgtracer.eci;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.enterprise.EnterpriseAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.transactiontrace.TransactionTraceController;
import com.wily.introscope.spec.server.transactiontrace.AndTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.powerpack.sysview.ctgtracer.eci.GUIDGenerator;
import com.wily.powerpack.sysview.ctgtracer.eci.JavaGatewayNameFormatter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class JavaGatewayFlowPerThreadTracer {
    private static final ThreadLocal<JavaGatewayFlowPerThreadTracer> threadUniqueJavaGatewayFlowTracer = new ThreadLocal<JavaGatewayFlowPerThreadTracer>(){

        @Override
        protected JavaGatewayFlowPerThreadTracer initialValue() {
            return null;
        }
    };
    static boolean guidInjectionByTracer = false;
    static boolean restoreOriginalCommarea = true;
    private static final String COR = "Cor";
    public static final String CorCTGIDValue = "IScopeCTGID";
    private static final String FILTER_CHECK = "filterCheck";
    private HashMap<String, String> sourceParameters = null;
    private static final int GUID_BUFFER_SIZE = 32;
    private static final int SEQUENCE_ID_BUFFER_SIZE = 32;
    private static final int PROP_FLAG_BUFFER_SIZE = 1;
    private static final String REMOVABLE_COMMAREA_EYECATCHER = "#CA/WILY";
    private static final String FIXED_COMMAREA_EYECATCHER = "@CA/WILY";
    private static final String IBM037 = "IBM037";
    static byte[] EBCDIC_REMOVABLE_COMMAREA_EYECATCHER = null;
    private static byte[] EBCDIC_FIXED_COMMAREA_EYECATCHER = null;
    private static byte[] EBCDIC_SYSVIEW_SEQUENCE_ID_VALUE = null;
    private static byte[] EBCDIC_SYSVIEW_TT_PROP_FLAG_VALUE_TRUE = null;
    private static byte[] EBCDIC_SYSVIEW_TT_PROP_FLAG_VALUE_FALSE = null;
    static final int CTG_TRACER_REGION_SIZE = "@CA/WILY".length() * 2 + 32 + 32 + 1;
    private static final int MAX_COMMAREA_SIZE_ALLOWED_FOR_ALL_PROTOCOLS = 32659;
    private static final int MAX_COMMAREA_SIZE_TO_INJECT_BUFFER = 32659 - CTG_TRACER_REGION_SIZE;
    private static final String SYSVIEW_INTEGRATION_CHANNEL = "WILY_CHANNEL";
    private static final String SYSVIEW_INTEGRATION_GUID = "WILY_CTG_GUID";
    private static final String SYSVIEW_SEQUENCE_ID_NAME = "WILY_SEQ_ID";
    private static final String SYSVIEW_SEQUENCE_ID_VALUE = "1:1";
    private static final String SYSVIEW_TT_PROP_FLAG = "WILY_PROP_FLAG";
    private static final String SYSVIEW_TT_PROP_FLAG_VALUE_TRUE = "1";
    private static final String SYSVIEW_TT_PROP_FLAG_VALUE_FALSE = "0";
    private static final String SYSVIEW_LOGGING_MODULE_NAME = "SysviewCTGFlowTracer";
    private static final String kGetContainerMethodKey = "getContainer";
    private static final String kCreateContainerMethodKey = "createContainer";
    private static final String kSetChannelMethodKey = "setChannel";
    private static final String kDeleteContainerMethodKey = "deleteContainer";
    private static final String kCommarea_Length = "Commarea_Length";
    private static final String kGetNameMethodKey = "getName";
    private static final String kisCommareaOutboundLengthMethod = "isCommareaOutboundLength";
    private static final String kgetCommareaOutboundLengthMethod = "getCommareaOutboundLength";
    private static final String ksetCommareaOutboundLengthMethod = "setCommareaOutboundLength";
    private static final String kExtendMode = "Extend_Mode";
    private static final String kLaunchSessionWithAgentsKey = "LaunchSessionWithAgents";
    private static final String kLaunchSessionWithAgentsValue = "(SYSVIEW.*|Cross-Enterprise.*)";
    private static final String kLaunchSessionSysviewTransactionName = "LaunchSessionSysviewTransactionName";
    private static final String kLaunchSessionSysviewTime = "LaunchSessionSysviewTime";
    private static final String kLaunchSessionSysviewProgramName = "LaunchSessionSysviewProgramName";
    private static IModuleFeedbackChannel feedbackChannel = null;
    private static Module module = new Module("SysviewCTGFlowTracer");
    private static final String PROPERTY_INJECTION_BY_TRACER = "introscope.ctg.tracer.inject.guid";
    private static final String PROPERTY_IPIC_SUPPORTED = "ceapm.ipic.supported";
    private static final String PROPERTY_COMMAREA_SAMPLING_SUPPORTED = "ceapm.commarea.sampling.supported";
    private static final String PROPERTY_COMMAREA_PROGRAM_NAME_REGEX = "ceapm.commarea.program.name.regex";
    private static final String PROPERTY_CHANNEL_PROGRAM_NAME_REGEX = "ceapm.channel.program.name.regex";
    private static final String PROPERTY_NODATA_PROGRAM_NAME_REGEX = "ceapm.nodata.program.name.regex";
    private static final String PROPERTY_RESTORE_ORIGINAL_COMMAREA_BYTES = "ceapm.commarea.restore.bytes";
    private static boolean initializedConfiguration = false;
    private static boolean injectDuringSampling = false;
    private static boolean IPICisSupported = false;
    private static String commareaProgramNameRegex = null;
    private static String channelProgramNameRegex = null;
    private static String nodataProgramNameRegex = null;
    static Pattern commareaProgramNamePattern = null;
    static Pattern channelProgramNamePattern = null;
    static Pattern nodataProgramNamePattern = null;
    private static GUIDGenerator globalIDGenerator = GUIDGenerator.getInstance();
    private static boolean reportOldCTGErrorOnlyOnce = false;
    public static final int ECI_NO_EXTEND = 0;
    public static final int ECI_EXTENDED = 1;
    public static final int ECI_COMMIT = 2;
    public static final int ECI_BACKOUT = 4;
    int luwState = 0;
    private String luwUuid = null;
    private int originalOutboundDataLength = -1;
    byte[] originalCommareaBytes = null;
    byte[] tracerCommareaBytes = null;
    private int originalCommarea_Length = -1;
    private boolean decorationWasInserted = false;
    private boolean weDecorated = false;
    private boolean weAddedAChannel = false;
    private boolean insertedGUIDContainer = false;
    private boolean insertedSeqIDContainer = false;
    private boolean insertedPropFlagContainer = false;

    public static void initialize(IAgent agent) {
        feedbackChannel = agent.IAgent_getModuleFeedback();
        if (!initializedConfiguration) {
            JavaGatewayFlowPerThreadTracer.initializeConstants();
            guidInjectionByTracer = agent.IAgent_getIndexedProperties().getBooleanProperty(PROPERTY_INJECTION_BY_TRACER);
            injectDuringSampling = agent.IAgent_getIndexedProperties().getBooleanProperty(PROPERTY_COMMAREA_SAMPLING_SUPPORTED);
            IPICisSupported = agent.IAgent_getIndexedProperties().getBooleanProperty(PROPERTY_IPIC_SUPPORTED);
            restoreOriginalCommarea = agent.IAgent_getIndexedProperties().getBooleanProperty(PROPERTY_RESTORE_ORIGINAL_COMMAREA_BYTES, true);
            commareaProgramNameRegex = agent.IAgent_getIndexedProperties().getProperty(PROPERTY_COMMAREA_PROGRAM_NAME_REGEX);
            if (commareaProgramNameRegex != null && !commareaProgramNameRegex.equals("*") && !commareaProgramNameRegex.equals(".*")) {
                commareaProgramNamePattern = Pattern.compile(commareaProgramNameRegex);
            }
            if ((channelProgramNameRegex = agent.IAgent_getIndexedProperties().getProperty(PROPERTY_CHANNEL_PROGRAM_NAME_REGEX)) != null && !channelProgramNameRegex.equals("*") && !channelProgramNameRegex.equals(".*")) {
                channelProgramNamePattern = Pattern.compile(channelProgramNameRegex);
            }
            if ((nodataProgramNameRegex = agent.IAgent_getIndexedProperties().getProperty(PROPERTY_NODATA_PROGRAM_NAME_REGEX)) != null && !nodataProgramNameRegex.equals("*") && !nodataProgramNameRegex.equals(".*")) {
                nodataProgramNamePattern = Pattern.compile(nodataProgramNameRegex);
            }
            initializedConfiguration = true;
        }
    }

    static void initializeConstants() {
        try {
            EBCDIC_REMOVABLE_COMMAREA_EYECATCHER = REMOVABLE_COMMAREA_EYECATCHER.getBytes(IBM037);
            EBCDIC_FIXED_COMMAREA_EYECATCHER = FIXED_COMMAREA_EYECATCHER.getBytes(IBM037);
            EBCDIC_SYSVIEW_SEQUENCE_ID_VALUE = SYSVIEW_SEQUENCE_ID_VALUE.getBytes(IBM037);
            EBCDIC_SYSVIEW_TT_PROP_FLAG_VALUE_TRUE = SYSVIEW_TT_PROP_FLAG_VALUE_TRUE.getBytes(IBM037);
            EBCDIC_SYSVIEW_TT_PROP_FLAG_VALUE_FALSE = SYSVIEW_TT_PROP_FLAG_VALUE_FALSE.getBytes(IBM037);
        }
        catch (Exception ex) {
            feedbackChannel.debug(module, ex.getLocalizedMessage());
        }
    }

    private JavaGatewayFlowPerThreadTracer() {
    }

    public static JavaGatewayFlowPerThreadTracer getInstance() {
        JavaGatewayFlowPerThreadTracer javaGatewayFlowPerThreadTracer = threadUniqueJavaGatewayFlowTracer.get();
        if (javaGatewayFlowPerThreadTracer == null) {
            javaGatewayFlowPerThreadTracer = new JavaGatewayFlowPerThreadTracer();
            threadUniqueJavaGatewayFlowTracer.set(javaGatewayFlowPerThreadTracer);
            javaGatewayFlowPerThreadTracer.clear();
        }
        return javaGatewayFlowPerThreadTracer;
    }

    public static IModuleFeedbackChannel getFeedbackChannel() {
        return feedbackChannel;
    }

    public String getLuwUuid() {
        return this.luwUuid;
    }

    public boolean isWeDecorated() {
        return this.weDecorated;
    }

    public void clear() {
        this.originalOutboundDataLength = -1;
        this.originalCommareaBytes = null;
        this.tracerCommareaBytes = null;
        this.originalCommarea_Length = -1;
        this.decorationWasInserted = false;
        this.weDecorated = false;
        this.weAddedAChannel = false;
        this.insertedGUIDContainer = false;
        this.insertedSeqIDContainer = false;
        this.insertedPropFlagContainer = false;
    }

    public static void startTraceThreadSpecific(IAgent agent, int tracerIndex, InvocationData data) {
        JavaGatewayFlowPerThreadTracer javaGatewayFlowPerThreadTracer = JavaGatewayFlowPerThreadTracer.getInstance();
        if (javaGatewayFlowPerThreadTracer != null) {
            javaGatewayFlowPerThreadTracer.startTrace(agent, tracerIndex, data);
        }
    }

    public void startTrace(IAgent agent, int tracerIndex, InvocationData data) {
        block5: {
            this.clear();
            try {
                if (injectDuringSampling || this.checkForDurationOrCTGFilter()) {
                    Integer requestCode;
                    Object gatewayRequest = data.getInvocationParameterAsObject(0);
                    Map<String, Object> propertiesMap = JavaGatewayNameFormatter.getPropertiesHashMap(data);
                    if (propertiesMap != null && (requestCode = (Integer)propertiesMap.get("CTG Code Type")) == JavaGatewayNameFormatter.RequestCode_ECI) {
                        Object channel = propertiesMap.get("channel");
                        if (channel == null && !reportOldCTGErrorOnlyOnce && !propertiesMap.containsKey("channel")) {
                            feedbackChannel.warn("An older version of CTG appears to be installed. Channels are not supported in this version.");
                            feedbackChannel.warn("Programs using the COMMAREA will still be functional but for channels, CTG 7.2.0.0 or higher will have to be used.");
                            JavaGatewayFlowPerThreadTracer.setReportOldCtgErrorOnlyOnce(true);
                            JavaGatewayFlowPerThreadTracer.setIpicIsSupported(false);
                        }
                        Object commarea = propertiesMap.get("Commarea");
                        String programName = (String)propertiesMap.get("Program Name");
                        boolean propFlagEnable = agent.IAgent_getComponentTracer().shouldCurrentTraceBePropagated();
                        this.insertDecoration(agent, propertiesMap, channel, commarea, gatewayRequest.getClass(), gatewayRequest, propFlagEnable, programName);
                    }
                    break block5;
                }
                return;
            }
            catch (Exception ex) {
                feedbackChannel.error(module, "Exception startTrace.  Reason: " + ex.getLocalizedMessage());
            }
        }
    }

    public static void finishTraceThreadSpecific(ComponentTracer componentTracer, int tracerIndex, InvocationData data) {
        JavaGatewayFlowPerThreadTracer javaGatewayFlowPerThreadTracer = JavaGatewayFlowPerThreadTracer.getInstance();
        if (javaGatewayFlowPerThreadTracer != null) {
            javaGatewayFlowPerThreadTracer.finishTrace(componentTracer, tracerIndex, data);
        }
    }

    public void finishTrace(ComponentTracer componentTracer, int tracerIndex, InvocationData data) {
        try {
            if (this.weDecorated) {
                String uuid = this.getLuwUuid();
                componentTracer.addCorrelationParameter(uuid, CorCTGIDValue);
                componentTracer.addExtraParameter(COR + uuid, CorCTGIDValue);
                long clockElapsedTimeInMicros = data.getWallClockElapsedTime() * 1000L;
                long estimatedDurationThreshold = (clockElapsedTimeInMicros - 500L) / 2L;
                if (clockElapsedTimeInMicros == 0L) {
                    estimatedDurationThreshold = 0L;
                }
                componentTracer.addExtraParameter(kLaunchSessionSysviewTime, String.valueOf(estimatedDurationThreshold));
            }
            this.cleanupTraceInjections(data);
        }
        catch (Exception ex) {
            feedbackChannel.debug(module, ex.getLocalizedMessage());
        }
    }

    public void addParameters(InvocationData data, Map<String, String> parameters) {
        try {
            Map<String, Object> propertiesMap = JavaGatewayNameFormatter.getPropertiesHashMap(data);
            if (propertiesMap != null) {
                String classNameOfGatewayRequest = (String)propertiesMap.get("CTG Request Class");
                String ctgRequestType = (String)propertiesMap.get("CTG Request Type");
                String serverName = (String)propertiesMap.get("CTG Server Name");
                String programName = (String)propertiesMap.get("Program Name");
                String transactionName = (String)propertiesMap.get("Transaction Name");
                String extendModeName = (String)propertiesMap.get("CTG Extend Mode");
                String communicationsMethodStr = (String)propertiesMap.get("Communication Method");
                String userID = (String)propertiesMap.get("User ID");
                String xaRequestType = (String)propertiesMap.get("XA Request Type");
                if (classNameOfGatewayRequest != null) {
                    parameters.put("CTG Request Class", classNameOfGatewayRequest);
                }
                if (ctgRequestType != null) {
                    parameters.put("CTG Request Type", ctgRequestType);
                }
                if (programName != null) {
                    parameters.put("Program Name", programName);
                    parameters.put(kLaunchSessionSysviewProgramName, programName);
                }
                if (serverName != null) {
                    parameters.put("CTG Server Name", serverName);
                }
                if (transactionName != null) {
                    parameters.put("Transaction Name", transactionName);
                    parameters.put(kLaunchSessionWithAgentsKey, kLaunchSessionWithAgentsValue);
                    parameters.put(kLaunchSessionSysviewTransactionName, transactionName);
                }
                if (extendModeName != null) {
                    parameters.put("CTG Extend Mode", extendModeName);
                }
                if (communicationsMethodStr != null) {
                    parameters.put("Communication Method", communicationsMethodStr);
                }
                if (userID != null) {
                    parameters.put("User ID", userID);
                }
                if (xaRequestType != null) {
                    parameters.put("XA Request Type", xaRequestType);
                }
            }
        }
        catch (Exception exception) {}
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean checkForDurationOrCTGFilter() {
        try {
            TransactionTraceController ttc = ((EnterpriseAgent)AgentShim.getAgent()).getTransactionTraceController();
            int i = 0;
            while (i < ttc.getFilterCount()) {
                ITransactionTraceFilter filter = ttc.getFilterAt(i);
                String filterName = filter.getClass().getName();
                if (filterName.compareToIgnoreCase("com.wily.introscope.spec.server.transactiontrace.AndTransactionTraceFilter") == 0) {
                    AndTransactionTraceFilter andTransactionTraceFilter = (AndTransactionTraceFilter)filter;
                    ITransactionTraceFilter[] andFilters = andTransactionTraceFilter.getContainedTransactionFilters();
                    int aFilterIndex = 0;
                    while (aFilterIndex < andFilters.length) {
                        ITransactionTraceFilter aFilter = andFilters[aFilterIndex];
                        String andFilterName = aFilter.getClass().getName();
                        if (andFilterName.compareToIgnoreCase("com.wily.introscope.ext.sysview.namefilter.TimeTracerFilter") == 0 || andFilterName.compareToIgnoreCase("com.wily.introscope.spec.server.transactiontrace.ThresholdTransactionTraceFilter") == 0) {
                            return true;
                        }
                        if (andFilterName.compareToIgnoreCase("com.wily.introscope.ext.sysview.namefilter.ProgramNameTracerFilter") == 0 || andFilterName.compareToIgnoreCase("com.wily.introscope.ext.sysview.namefilter.TransactionNameTracerFilter") == 0 || andFilterName.compareToIgnoreCase("com.wily.introscope.ext.sysview.namefilter.ServerNameTracerFilter") == 0) {
                            return true;
                        }
                        ++aFilterIndex;
                    }
                } else {
                    if (filterName.compareToIgnoreCase("com.wily.introscope.ext.sysview.namefilter.TimeTracerFilter") == 0 || filterName.compareToIgnoreCase("com.wily.introscope.spec.server.transactiontrace.ThresholdTransactionTraceFilter") == 0) {
                        return true;
                    }
                    if (filterName.compareToIgnoreCase("com.wily.introscope.ext.sysview.namefilter.ProgramNameTracerFilter") == 0 || filterName.compareToIgnoreCase("com.wily.introscope.ext.sysview.namefilter.TransactionNameTracerFilter") == 0 || filterName.compareToIgnoreCase("com.wily.introscope.ext.sysview.namefilter.ServerNameTracerFilter") == 0) {
                        return true;
                    }
                }
                ++i;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean passesFilter(String transactionName, String programName) {
        try {
            TransactionTraceController ttc = ((EnterpriseAgent)AgentShim.getAgent()).getTransactionTraceController();
            if (this.sourceParameters == null) {
                this.sourceParameters = new HashMap();
            } else {
                this.sourceParameters.clear();
            }
            this.sourceParameters.put("Transaction Name", transactionName);
            this.sourceParameters.put("Program Name", programName);
            TransactionComponentData tcde = new TransactionComponentData(FILTER_CHECK, 12345L, 123L, this.sourceParameters);
            return this.filterCheck(tcde, ttc);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean filterCheck(TransactionComponentData tcde, TransactionTraceController ttc) {
        boolean passesFilter = false;
        int i = 0;
        while (i < ttc.getFilterCount()) {
            ITransactionTraceFilter filter = ttc.getFilterAt(i);
            if (filter.ITransactionTraceFilter_passesFilter(tcde)) {
                passesFilter = true;
                break;
            }
            ++i;
        }
        return passesFilter;
    }

    public void cleanupTraceInjections(InvocationData data) {
        Object eciRequest = data.getInvocationParameterAsObject(0);
        this.cleanupTraceInjectionsOfEciRequest(eciRequest);
    }

    void cleanupTraceInjectionsOfEciRequest(Object eciRequest) {
        block28: {
            if (this.decorationWasInserted || this.insertedGUIDContainer || this.weAddedAChannel) {
                try {
                    Method getNameMethod;
                    String channelName;
                    Object channel;
                    Class<?> classOfEciRequest = eciRequest.getClass();
                    this.decorationWasInserted = false;
                    Object responseCommarea = classOfEciRequest.getDeclaredField("Commarea").get(eciRequest);
                    if (responseCommarea != null) {
                        byte[] responseCommareaBytes = (byte[])responseCommarea;
                        int commarea_Length = classOfEciRequest.getDeclaredField(kCommarea_Length).getInt(eciRequest);
                        int newCommarea_Length = this.FindEyecatcher(responseCommareaBytes, commarea_Length, EBCDIC_REMOVABLE_COMMAREA_EYECATCHER);
                        if (newCommarea_Length >= 0) {
                            this.PadBufferWithZeros(responseCommareaBytes, newCommarea_Length, commarea_Length);
                        }
                        if (this.originalCommareaBytes != null && restoreOriginalCommarea && responseCommareaBytes == this.tracerCommareaBytes && commarea_Length > 0 && commarea_Length <= this.originalCommareaBytes.length) {
                            System.arraycopy(responseCommareaBytes, 0, this.originalCommareaBytes, 0, commarea_Length);
                            if (commarea_Length < this.originalCommareaBytes.length) {
                                this.PadBufferWithZeros(this.originalCommareaBytes, commarea_Length, this.originalCommareaBytes.length);
                            }
                            try {
                                classOfEciRequest.getDeclaredField("Commarea").set(eciRequest, this.originalCommareaBytes);
                            }
                            catch (Exception ex) {
                                feedbackChannel.debug(module, ex.getLocalizedMessage());
                            }
                        }
                        this.originalCommareaBytes = null;
                        this.tracerCommareaBytes = null;
                        if (this.originalCommarea_Length >= 0) {
                            try {
                                classOfEciRequest.getDeclaredField(kCommarea_Length).set(eciRequest, this.originalCommarea_Length);
                            }
                            catch (Exception ex) {
                                feedbackChannel.debug(module, ex.getLocalizedMessage());
                            }
                            this.originalCommarea_Length = -1;
                        }
                        if (this.originalOutboundDataLength >= 0) {
                            try {
                                Method setCommareaOutboundLengthMethod = classOfEciRequest.getMethod(ksetCommareaOutboundLengthMethod, Integer.TYPE);
                                setCommareaOutboundLengthMethod.invoke(eciRequest, this.originalOutboundDataLength);
                            }
                            catch (Exception ex) {
                                feedbackChannel.debug(module, ex.getLocalizedMessage());
                            }
                            this.originalOutboundDataLength = -1;
                        }
                    }
                    if ((channel = classOfEciRequest.getDeclaredField("channel").get(eciRequest)) == null) break block28;
                    Method deleteContainerMethod = null;
                    if (this.insertedGUIDContainer || this.insertedSeqIDContainer || this.insertedPropFlagContainer) {
                        deleteContainerMethod = channel.getClass().getMethod(kDeleteContainerMethodKey, String.class);
                        if (this.insertedGUIDContainer) {
                            try {
                                deleteContainerMethod.invoke(channel, SYSVIEW_INTEGRATION_GUID);
                            }
                            catch (Exception e) {
                                feedbackChannel.debug(module, e.getLocalizedMessage());
                            }
                        }
                        if (this.insertedSeqIDContainer) {
                            try {
                                deleteContainerMethod.invoke(channel, SYSVIEW_SEQUENCE_ID_NAME);
                            }
                            catch (Exception e) {
                                feedbackChannel.debug(module, e.getLocalizedMessage());
                            }
                        }
                        if (this.insertedPropFlagContainer) {
                            try {
                                deleteContainerMethod.invoke(channel, SYSVIEW_TT_PROP_FLAG);
                            }
                            catch (Exception e) {
                                feedbackChannel.debug(module, e.getLocalizedMessage());
                            }
                        }
                    }
                    if ((channelName = (String)(getNameMethod = channel.getClass().getMethod(kGetNameMethodKey, new Class[0])).invoke(channel, new Object[0])).compareToIgnoreCase(SYSVIEW_INTEGRATION_CHANNEL) == 0) {
                        Method setChannelMethod = classOfEciRequest.getMethod(kSetChannelMethodKey, channel.getClass());
                        try {
                            setChannelMethod.invoke(eciRequest, new Object[1]);
                        }
                        catch (Exception e) {
                            feedbackChannel.debug(module, e.getLocalizedMessage());
                        }
                    }
                }
                catch (Exception ex) {
                    feedbackChannel.debug(module, ex.getLocalizedMessage());
                }
            }
        }
    }

    private boolean CheckAndInsertGUIDAndSequence(Map<String, Object> propertiesMap, Class<? extends Object> classOfEciRequest, Object eciRequest, Object commarea, String uuid, boolean propFlagEnable) {
        int commarea_Length = 0;
        byte[] commareaBytes = (byte[])commarea;
        int eyeCatcherStart = -1;
        try {
            commarea_Length = classOfEciRequest.getDeclaredField(kCommarea_Length).getInt(eciRequest);
        }
        catch (Exception ex) {
            feedbackChannel.debug(module, "Failure getting Commarea_Length" + ex.getLocalizedMessage());
            return false;
        }
        this.initOriginalOutboundDataLength(classOfEciRequest, eciRequest);
        if (commarea_Length < this.originalOutboundDataLength) {
            commarea_Length = this.originalOutboundDataLength;
        }
        if (commarea_Length == 0) {
            commarea_Length = commareaBytes.length;
        }
        if ((eyeCatcherStart = this.FindEyecatcher(commareaBytes, commarea_Length, EBCDIC_FIXED_COMMAREA_EYECATCHER)) < 0) {
            if (!guidInjectionByTracer) {
                return false;
            }
            this.InsertBufferAndGuidAndSequence(propertiesMap, classOfEciRequest, eciRequest, commareaBytes, commarea_Length, uuid, propFlagEnable);
        } else {
            this.FillInGuidAndSequence(commareaBytes, eyeCatcherStart, uuid, propFlagEnable);
            if (propertiesMap != null) {
                propertiesMap.put("Communication Method", "CommArea Static");
            }
        }
        return true;
    }

    private void InsertBufferAndGuidAndSequence(Map<String, Object> propertiesMap, Class<? extends Object> classOfEciRequest, Object eciRequest, byte[] commarea, int commarea_Length, String uuidString, boolean propFlagEnable) {
        byte[] newCommarea = null;
        int newCommarea_Length = commarea_Length + CTG_TRACER_REGION_SIZE;
        if (commarea_Length > MAX_COMMAREA_SIZE_TO_INJECT_BUFFER) {
            return;
        }
        if (commarea == null) {
            newCommarea = new byte[newCommarea_Length];
        } else {
            this.originalCommareaBytes = commarea;
            if (commarea.length < newCommarea_Length) {
                newCommarea = new byte[newCommarea_Length];
                System.arraycopy(commarea, 0, newCommarea, 0, commarea.length);
            } else {
                newCommarea = commarea;
            }
        }
        this.tracerCommareaBytes = newCommarea;
        int endOfArray = commarea_Length;
        System.arraycopy(EBCDIC_REMOVABLE_COMMAREA_EYECATCHER, 0, newCommarea, endOfArray, REMOVABLE_COMMAREA_EYECATCHER.length());
        endOfArray += REMOVABLE_COMMAREA_EYECATCHER.length();
        try {
            System.arraycopy(uuidString.getBytes(IBM037), 0, newCommarea, endOfArray, uuidString.length());
            endOfArray += 32;
        }
        catch (Exception ex) {
            feedbackChannel.debug(module, ex.getLocalizedMessage());
        }
        System.arraycopy(EBCDIC_SYSVIEW_SEQUENCE_ID_VALUE, 0, newCommarea, endOfArray, SYSVIEW_SEQUENCE_ID_VALUE.length());
        int endOfSequenceIDBuffer = newCommarea.length - REMOVABLE_COMMAREA_EYECATCHER.length();
        int startOfSequenceIDBuffer = endOfSequenceIDBuffer - 32 + EBCDIC_SYSVIEW_SEQUENCE_ID_VALUE.length;
        this.PadBufferWithBlanks(newCommarea, startOfSequenceIDBuffer, endOfSequenceIDBuffer);
        newCommarea[endOfArray += 32] = propFlagEnable ? EBCDIC_SYSVIEW_TT_PROP_FLAG_VALUE_TRUE[0] : EBCDIC_SYSVIEW_TT_PROP_FLAG_VALUE_FALSE[0];
        System.arraycopy(EBCDIC_REMOVABLE_COMMAREA_EYECATCHER, 0, newCommarea, ++endOfArray, REMOVABLE_COMMAREA_EYECATCHER.length());
        endOfArray += REMOVABLE_COMMAREA_EYECATCHER.length();
        this.initOriginalOutboundDataLength(classOfEciRequest, eciRequest);
        if (this.originalOutboundDataLength > 0 && this.originalOutboundDataLength < commarea_Length) {
            this.PadBufferWithZeros(newCommarea, this.originalOutboundDataLength, commarea_Length);
        }
        try {
            if (newCommarea != commarea) {
                classOfEciRequest.getDeclaredField("Commarea").set(eciRequest, newCommarea);
            }
        }
        catch (Exception ex) {
            feedbackChannel.debug(module, ex.getLocalizedMessage());
            return;
        }
        try {
            classOfEciRequest.getDeclaredField(kCommarea_Length).setInt(eciRequest, newCommarea_Length);
            this.originalCommarea_Length = commarea_Length;
        }
        catch (Exception ex) {
            feedbackChannel.debug(module, ex.getLocalizedMessage());
            return;
        }
        try {
            if (this.originalOutboundDataLength >= 0) {
                Method setCommareaOutboundLengthMethod = classOfEciRequest.getMethod(ksetCommareaOutboundLengthMethod, Integer.TYPE);
                setCommareaOutboundLengthMethod.invoke(eciRequest, newCommarea_Length);
            }
        }
        catch (Exception ex) {
            feedbackChannel.debug(module, ex.getLocalizedMessage());
            return;
        }
        this.decorationWasInserted = true;
        this.weDecorated = true;
        if (propertiesMap != null) {
            propertiesMap.put("Communication Method", "CommArea Dynamic");
        }
    }

    private void FillInGuidAndSequence(byte[] commarea, int eyeCatcherStart, String uuidString, boolean propFlagEnable) {
        int bufferStart = eyeCatcherStart + FIXED_COMMAREA_EYECATCHER.length();
        byte[] uuid = null;
        this.weDecorated = true;
        try {
            uuid = uuidString.getBytes(IBM037);
        }
        catch (Exception ex) {
            feedbackChannel.debug(module, ex.getLocalizedMessage());
            return;
        }
        System.arraycopy(uuid, 0, commarea, bufferStart, uuid.length);
        byte[] sequence = null;
        int sequenceLength = -1;
        try {
            sequence = EBCDIC_SYSVIEW_SEQUENCE_ID_VALUE;
            sequenceLength = sequence.length > 32 ? 32 : sequence.length;
        }
        catch (Exception ex) {
            feedbackChannel.debug(module, ex.getLocalizedMessage());
        }
        System.arraycopy(sequence, 0, commarea, bufferStart + 32, sequenceLength);
        int endOfSequenceIDBuffer = commarea.length - REMOVABLE_COMMAREA_EYECATCHER.length();
        int startOfSequenceIDBuffer = endOfSequenceIDBuffer - 32 + EBCDIC_SYSVIEW_SEQUENCE_ID_VALUE.length;
        this.PadBufferWithBlanks(commarea, startOfSequenceIDBuffer, endOfSequenceIDBuffer);
        commarea[bufferStart + 32 + 32] = propFlagEnable ? EBCDIC_SYSVIEW_TT_PROP_FLAG_VALUE_TRUE[0] : EBCDIC_SYSVIEW_TT_PROP_FLAG_VALUE_FALSE[0];
    }

    private int FindEyecatcher(byte[] mainArray, int commarea_Length, byte[] subSequence) {
        if (commarea_Length < CTG_TRACER_REGION_SIZE || mainArray.length < commarea_Length) {
            return -1;
        }
        int j = 0;
        int endPoint = CTG_TRACER_REGION_SIZE;
        int i = commarea_Length - FIXED_COMMAREA_EYECATCHER.length();
        while (i < endPoint) {
            if (mainArray[i] != subSequence[j]) {
                return -1;
            }
            ++i;
            ++j;
        }
        j = 0;
        endPoint = commarea_Length - CTG_TRACER_REGION_SIZE + FIXED_COMMAREA_EYECATCHER.length();
        i = commarea_Length - CTG_TRACER_REGION_SIZE;
        while (i < endPoint) {
            if (mainArray[i] != subSequence[j]) {
                return -1;
            }
            ++i;
            ++j;
        }
        return commarea_Length - CTG_TRACER_REGION_SIZE;
    }

    private void initOriginalOutboundDataLength(Class<? extends Object> classOfEciRequest, Object eciRequest) {
        try {
            Method isCommareaOutboundLengthMethod = classOfEciRequest.getMethod(kisCommareaOutboundLengthMethod, new Class[0]);
            Object result = isCommareaOutboundLengthMethod.invoke(eciRequest, new Object[0]);
            boolean isCommareaOutboundLengthSet = (Boolean)result;
            if (isCommareaOutboundLengthSet) {
                Method getCommareaOutboundLengthMethod = classOfEciRequest.getMethod(kgetCommareaOutboundLengthMethod, new Class[0]);
                Integer outBoundLen = (Integer)getCommareaOutboundLengthMethod.invoke(eciRequest, new Object[0]);
                this.originalOutboundDataLength = outBoundLen;
            }
        }
        catch (Exception ex) {
            feedbackChannel.debug(module, ex.getLocalizedMessage());
            return;
        }
    }

    private void PadBufferWithBlanks(byte[] commarea, int start, int end) {
        int i = start;
        while (i < end) {
            commarea[i] = 64;
            ++i;
        }
    }

    private void PadBufferWithZeros(byte[] commarea, int start, int end) {
        int i = start;
        while (i < end) {
            commarea[i] = 0;
            ++i;
        }
    }

    String generateUUIDforLUW(Class<? extends Object> classOfEciRequest, Object eciRequest) {
        int extendMode;
        try {
            extendMode = classOfEciRequest.getDeclaredField(kExtendMode).getInt(eciRequest);
        }
        catch (Exception exception) {
            extendMode = 0;
            this.luwState = 0;
        }
        if (this.luwState == 1) {
            if (extendMode == 2 || extendMode == 4) {
                this.luwState = 0;
            }
            if (this.luwUuid == null) {
                this.luwUuid = globalIDGenerator.generateKey();
            }
            return this.luwUuid;
        }
        if (extendMode == 1) {
            this.luwState = 1;
        }
        this.luwUuid = globalIDGenerator.generateKey();
        return this.luwUuid;
    }

    void insertDecoration(IAgent agent, Map<String, Object> propertiesMap, Object channel, Object commarea, Class<? extends Object> classOfEciRequest, Object eciRequest, boolean propFlagEnable, String programName) {
        block25: {
            try {
                if (programName == null) {
                    programName = "";
                }
                if (commarea == null) {
                    if (channel == null) {
                        if (!IPICisSupported) {
                            if (!guidInjectionByTracer) {
                                return;
                            }
                            if (nodataProgramNamePattern == null || nodataProgramNamePattern.matcher(programName).matches()) {
                                String uuid = this.generateUUIDforLUW(classOfEciRequest, eciRequest);
                                this.InsertBufferAndGuidAndSequence(propertiesMap, classOfEciRequest, eciRequest, null, 0, uuid, propFlagEnable);
                                return;
                            }
                            return;
                        }
                        if (channelProgramNamePattern != null && !channelProgramNamePattern.matcher(programName).matches()) {
                            return;
                        }
                        try {
                            Constructor<?> channelConstructor = JavaGatewayNameFormatter.loadChannelConstructor(eciRequest);
                            Object newChannelInsertedByTracer = channelConstructor.newInstance(SYSVIEW_INTEGRATION_CHANNEL);
                            Method setChannelMethod = eciRequest.getClass().getMethod(kSetChannelMethodKey, newChannelInsertedByTracer.getClass());
                            setChannelMethod.invoke(eciRequest, newChannelInsertedByTracer);
                            channel = newChannelInsertedByTracer;
                            this.weAddedAChannel = true;
                        }
                        catch (Exception ex) {
                            feedbackChannel.debug(module, ex.getLocalizedMessage());
                            return;
                        }
                        catch (NoClassDefFoundError t) {
                            feedbackChannel.debug((Throwable)t);
                            return;
                        }
                    } else if (channelProgramNamePattern != null && !channelProgramNamePattern.matcher(programName).matches()) {
                        return;
                    }
                    Class[] getContainerParms = new Class[]{String.class};
                    Method getContainerMethod = channel.getClass().getMethod(kGetContainerMethodKey, getContainerParms);
                    Method createContainerMethod = channel.getClass().getMethod(kCreateContainerMethodKey, String.class, String.class);
                    try {
                        getContainerMethod.invoke(channel, SYSVIEW_INTEGRATION_GUID);
                    }
                    catch (Exception exception) {
                        String uuid = this.generateUUIDforLUW(classOfEciRequest, eciRequest);
                        createContainerMethod.invoke(channel, SYSVIEW_INTEGRATION_GUID, uuid);
                        this.insertedGUIDContainer = true;
                        this.weDecorated = true;
                    }
                    try {
                        getContainerMethod.invoke(channel, SYSVIEW_SEQUENCE_ID_NAME);
                    }
                    catch (Exception exception) {
                        createContainerMethod.invoke(channel, SYSVIEW_SEQUENCE_ID_NAME, SYSVIEW_SEQUENCE_ID_VALUE);
                        this.insertedSeqIDContainer = true;
                    }
                    try {
                        getContainerMethod.invoke(channel, SYSVIEW_TT_PROP_FLAG);
                    }
                    catch (Exception exception) {
                        if (propFlagEnable) {
                            createContainerMethod.invoke(channel, SYSVIEW_TT_PROP_FLAG, SYSVIEW_TT_PROP_FLAG_VALUE_TRUE);
                        } else {
                            createContainerMethod.invoke(channel, SYSVIEW_TT_PROP_FLAG, SYSVIEW_TT_PROP_FLAG_VALUE_FALSE);
                        }
                        this.insertedPropFlagContainer = true;
                    }
                    if (propertiesMap != null) {
                        propertiesMap.put("Communication Method", "CTG Channel");
                    }
                    break block25;
                }
                if (!guidInjectionByTracer) {
                    return;
                }
                if (commareaProgramNamePattern != null && !commareaProgramNamePattern.matcher(programName).matches()) {
                    return;
                }
                String uuid = this.generateUUIDforLUW(classOfEciRequest, eciRequest);
                this.CheckAndInsertGUIDAndSequence(propertiesMap, classOfEciRequest, eciRequest, commarea, uuid, propFlagEnable);
            }
            catch (Exception ex) {
                feedbackChannel.error(module, "Failed to insert decoration: " + ex.getLocalizedMessage());
            }
        }
    }

    private static final void setIpicIsSupported(boolean isSupported) {
        IPICisSupported = isSupported;
    }

    private static final void setReportOldCtgErrorOnlyOnce(boolean reportOnce) {
        reportOldCTGErrorOnlyOnce = reportOnce;
    }
}

