/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.weblogic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.StringUtils;
import java.util.Map;

public class SEIStubNameFormatter
implements INameFormatter,
KConstants {
    private final IAgent agent;
    public static final String kPropertyNamespace = "wily.jaxws.client.namespace";
    public static final String kPropertyOperation = "wily.jaxws.client.operationname";
    public static final String kPropertyEndpoint = "javax.xml.ws.service.endpoint.address";
    public static final String kPropertyWsdlServiceName = "wily.jaxws.client.wsdlservicename";

    public SEIStubNameFormatter(IAgent agent) {
        this.agent = agent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        if (name == null) {
            return null;
        }
        String operationName = null;
        String serviceName = null;
        String namespace = null;
        String wsdlServiceName = null;
        try {
            Object objJAXWSProxyHandler = data.getInvocationObject();
            Object objRequestContext = WSMUtils.invokeMethodOnObject(objJAXWSProxyHandler, "getRequestContext");
            Map mapRequestContext = (Map)objRequestContext;
            if (name.indexOf("{servicename}", 0) >= 0) {
                serviceName = (String)mapRequestContext.get(kPropertyEndpoint);
                if (serviceName == null) {
                    serviceName = "UnknownService";
                }
                serviceName = WSMUtils.formatToBeResourceSafe(serviceName);
                name = StringUtils.replace((String)name, (String)"{servicename}", (String)serviceName);
            }
            if (name.indexOf("{wsdlservicename}", 0) >= 0) {
                wsdlServiceName = (String)mapRequestContext.get(kPropertyWsdlServiceName);
                if (wsdlServiceName == null) {
                    wsdlServiceName = "UnknownService";
                }
                wsdlServiceName = WSMUtils.formatToBeResourceSafe(wsdlServiceName);
                name = StringUtils.replace((String)name, (String)"{wsdlservicename}", (String)wsdlServiceName);
            }
            if (name.indexOf("{namespace}", 0) >= 0) {
                namespace = (String)mapRequestContext.get(kPropertyNamespace);
                if (namespace == null) {
                    namespace = serviceName;
                }
                namespace = WSMUtils.formatToBeResourceSafe(namespace);
                name = StringUtils.replace((String)name, (String)"{namespace}", (String)namespace);
            }
            if (name.indexOf("{operationname}", 0) >= 0) {
                operationName = (String)mapRequestContext.get(kPropertyOperation);
                if (operationName == null) {
                    operationName = "UnknownOperationName";
                }
                operationName = WSMUtils.formatToBeResourceSafe(operationName);
                name = StringUtils.replace((String)name, (String)"{operationname}", (String)operationName);
            }
        }
        catch (Exception e) {
            this.agent.IAgent_getModuleFeedback().error((Throwable)e);
        }
        return name;
    }
}

