/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.trace;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.brtm.trace.common.MutableInteger;
import com.wily.introscope.agent.brtm.trace.common.PPSimpleTracer;
import com.wily.introscope.agent.brtm.utilities.EncryptionDecryptionUtils;
import com.wily.introscope.agent.brtm.utilities.InternalDataUtils;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.feedback.DelegatingFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;
import java.util.Map;

public class BALevelTwoHelperTracer
extends PPSimpleTracer
implements ITracer {
    private static final Module BA_MODULE = new Module("BrowserAgent");
    private static IAgent agent;
    private static IModuleFeedbackChannel feedback;
    private String servletName;
    private static ThreadLocal stackDepthLocal;

    public BALevelTwoHelperTracer(IAgent a, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) throws AgentNotAvailableException {
        super(a, parameters, probe, sampleTracedObject);
        agent = a;
        feedback = new DelegatingFeedbackChannel(agent.IAgent_getModuleFeedback(), BA_MODULE);
        this.servletName = this.getServletName(probe, feedback);
    }

    private String getServletName(ProbeIdentification probe, IModuleFeedbackChannel feedback2) {
        String name = probe.getRuntimeSimpleClassName();
        if (name != null && name.length() > 0) {
            name = EncryptionDecryptionUtils.encrypt(name, feedback);
        }
        return name;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        stackDepth.inc();
        if (stackDepth.getValue() > 1) {
            return;
        }
        if (data.getInvocationParameterCount() < 2) {
            return;
        }
        Object shouldAddResponseDecoration = BTThreadLocalAdministrator.getInstance().get("shouldAddResponseCookie");
        if (shouldAddResponseDecoration instanceof Boolean && ((Boolean)shouldAddResponseDecoration).booleanValue()) {
            Object params;
            HashMap<String, String> paramsAll = new HashMap<String, String>();
            if (this.servletName != null && this.servletName.length() > 0) {
                paramsAll.put("apmServletName", this.servletName);
            } else if (feedback.isTraceEnabled()) {
                feedback.trace(BA_MODULE, "can not get servlet name");
            }
            Map httpParams = data.getServletParameterMap();
            if (httpParams != null) {
                InternalDataUtils.addUserIDWebappName(httpParams, feedback, paramsAll);
            }
            if ((params = BTThreadLocalAdministrator.getInstance().get("agentInfo")) instanceof Map) {
                paramsAll.putAll((Map)params);
            }
            BTThreadLocalAdministrator.getInstance().insert("agentInfo", paramsAll);
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        stackDepth.dec();
        if (stackDepth.getValue() > 0) {
            return;
        }
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return (agent.IAgent_getComponentTracer().isAgentOldMode() ? Boolean.FALSE : BTThreadLocalAdministrator.getInstance().isResponseDecorationAPMDataEnabled()) == false;
    }

    static {
        stackDepthLocal = new ThreadLocal(){

            public Object initialValue() {
                return new MutableInteger();
            }
        };
    }
}

