/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.trace;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.brtm.trace.common.MutableInteger;
import com.wily.introscope.agent.brtm.trace.common.PPSimpleTracer;
import com.wily.introscope.agent.brtm.utilities.KBRTMConstants;
import com.wily.introscope.agent.brtm.utilities.WrapperFactoryUtils;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.feedback.DelegatingFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class BrtmHTTPResponseTracer
extends PPSimpleTracer
implements ITracer {
    private static final String SET_CONTENT_TYPE = "setContentType";
    private static final Module BRTM_MODULE = new Module("BrowserAgent");
    private static IAgent agent;
    public static final String[] methodNames;
    public static final String[] overrideClassName;
    private static ThreadLocal stackDepthLocal;

    public BrtmHTTPResponseTracer(IAgent a, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) throws AgentNotAvailableException {
        super(a, parameters, probe, sampleTracedObject);
        agent = a;
        new DelegatingFeedbackChannel(agent.IAgent_getModuleFeedback(), BRTM_MODULE);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        stackDepth.inc();
        if (stackDepth.getValue() > 1) {
            return;
        }
        this.decorateResponse(data);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String methodName = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        stackDepth.dec();
        if (!SET_CONTENT_TYPE.equalsIgnoreCase(methodName)) {
            if (stackDepth.getValue() > 0) {
                return;
            }
        } else {
            this.decorateResponse(data);
        }
    }

    private void decorateResponse(InvocationData data) {
        String createdCookie;
        Object shouldAddResponseDecoration;
        BTThreadLocalAdministrator.getInstance().insert("endTime", (Object)data.getWallClockTime());
        Object wrapperCreated = BTThreadLocalAdministrator.getInstance().get("brtm-response-wrapper-created");
        if (wrapperCreated instanceof Boolean && !((Boolean)BTThreadLocalAdministrator.getInstance().get("brtm-response-wrapper-created")).booleanValue() && (shouldAddResponseDecoration = BTThreadLocalAdministrator.getInstance().get("shouldAddResponseCookie")) instanceof Boolean && ((Boolean)shouldAddResponseDecoration).booleanValue() && (createdCookie = BTThreadLocalAdministrator.getInstance().getString("createdCookie")) == null) {
            this.decorateCookieAndHeader(data);
        }
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return (agent.IAgent_getComponentTracer().isAgentOldMode() ? Boolean.FALSE : BTThreadLocalAdministrator.getInstance().isResponseDecorationEnabled()) == false;
    }

    private void decorateCookieAndHeader(InvocationData invocationData) {
        WrapperFactoryUtils wrapperFactoryUtil = (WrapperFactoryUtils)BTThreadLocalAdministrator.getInstance().get("wrapperFactoryUtil");
        Object factoryObject = wrapperFactoryUtil.getFactoryObject();
        Object[] argArray = new Object[1];
        Class[] argClassArray = new Class[1];
        argArray[0] = invocationData.getInvocationObject();
        argClassArray[0] = Object.class;
        BrtmHTTPResponseTracer.invokeReturnsVoid(factoryObject, invocationData, 3, argArray, argClassArray, wrapperFactoryUtil.getMethodCache());
    }

    static {
        methodNames = KBRTMConstants.methodNames;
        overrideClassName = KBRTMConstants.overrideClassName;
        stackDepthLocal = new ThreadLocal(){

            public Object initialValue() {
                return new MutableInteger();
            }
        };
    }
}

