/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.utilities;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationProperty;

public class ConfigUtils {
    private static final Module BA_MODULE = new Module("BrowserAgent");
    private static IAgent agent;
    private static IModuleFeedbackChannel feedback;
    private static String COOKIE_ENABLED_PROPERTY;
    private static boolean enableCookieFlag;

    public static void initializeProperties(IAgent agent0, IModuleFeedbackChannel feedback1) {
        agent = agent0;
        feedback = feedback1;
        agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new BACookieEnabledProperty(agent), true);
    }

    public static boolean enableCookie() {
        return enableCookieFlag;
    }

    static {
        COOKIE_ENABLED_PROPERTY = "introscope.agent.browseragent.response.decoration.cookie.enabled";
        enableCookieFlag = true;
    }

    static final class BACookieEnabledProperty
    extends BooleanConfigurationProperty {
        private BACookieEnabledProperty(IAgent agent) {
            super(COOKIE_ENABLED_PROPERTY, Boolean.TRUE, "Enables/Disables Response Cookie Decoration for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), BA_MODULE, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            enableCookieFlag = (Boolean)newValue;
            boolean sustainabilityMetricsOn = BTThreadLocalAdministrator.getInstance().isSustainabilityMetricEnabled();
            if (enableCookieFlag) {
                if (sustainabilityMetricsOn) {
                    agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:" + COOKIE_ENABLED_PROPERTY).IIntegerCounterDataAccumulator_setValue(1);
                }
                agent.IAgent_getModuleFeedback().info(BA_MODULE, "Response Cookie Decoration is enabled");
            } else {
                if (sustainabilityMetricsOn) {
                    agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:" + COOKIE_ENABLED_PROPERTY).IIntegerCounterDataAccumulator_setValue(0);
                }
                agent.IAgent_getModuleFeedback().info(BA_MODULE, "Response Cookie Decoration is disabled");
            }
        }
    }
}

